/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;

public class HistoryCleanupBatch {
    public static final int MAX_BATCH_SIZE = 500;
    private List<String> historicProcessInstanceIds = Collections.emptyList();
    private List<String> historicDecisionInstanceIds = Collections.emptyList();
    private List<String> historicCaseInstanceIds = Collections.emptyList();
    private List<String> historicBatchIds = Collections.emptyList();

    public List<String> getHistoricProcessInstanceIds() {
        return this.historicProcessInstanceIds;
    }

    public void setHistoricProcessInstanceIds(List<String> historicProcessInstanceIds) {
        this.historicProcessInstanceIds = historicProcessInstanceIds;
    }

    public List<String> getHistoricDecisionInstanceIds() {
        return this.historicDecisionInstanceIds;
    }

    public void setHistoricDecisionInstanceIds(List<String> historicDecisionInstanceIds) {
        this.historicDecisionInstanceIds = historicDecisionInstanceIds;
    }

    public List<String> getHistoricCaseInstanceIds() {
        return this.historicCaseInstanceIds;
    }

    public void setHistoricCaseInstanceIds(List<String> historicCaseInstanceIds) {
        this.historicCaseInstanceIds = historicCaseInstanceIds;
    }

    public List<String> getHistoricBatchIds() {
        return this.historicBatchIds;
    }

    public void setHistoricBatchIds(List<String> historicBatchIds) {
        this.historicBatchIds = historicBatchIds;
    }

    public int size() {
        return this.historicProcessInstanceIds.size() + this.historicDecisionInstanceIds.size() + this.historicCaseInstanceIds.size() + this.historicBatchIds.size();
    }

    public void performCleanup() {
        CommandContext commandContext = Context.getCommandContext();
        if (this.historicProcessInstanceIds.size() > 0) {
            commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByIds(this.historicProcessInstanceIds);
            this.recordValue("history-cleanup-removed-process-instances", this.historicProcessInstanceIds.size());
        }
        if (this.historicDecisionInstanceIds.size() > 0) {
            commandContext.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstanceByIds(this.historicDecisionInstanceIds);
            this.recordValue("history-cleanup-removed-decision-instances", this.historicDecisionInstanceIds.size());
        }
        if (this.historicCaseInstanceIds.size() > 0) {
            commandContext.getHistoricCaseInstanceManager().deleteHistoricCaseInstancesByIds(this.historicCaseInstanceIds);
            this.recordValue("history-cleanup-removed-case-instances", this.historicCaseInstanceIds.size());
        }
        if (this.historicBatchIds.size() > 0) {
            commandContext.getHistoricBatchManager().deleteHistoricBatchesByIds(this.historicBatchIds);
            this.recordValue("history-cleanup-removed-batch-operations", this.historicBatchIds.size());
        }
    }

    protected void recordValue(String name, long value) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getCommandContext().getProcessEngineConfiguration();
        if (processEngineConfiguration.isHistoryCleanupMetricsEnabled()) {
            processEngineConfiguration.getDbMetricsReporter().reportValueAtOnce(name, value);
        }
    }
}

