/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.batch;

import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.migration.AbstractMigrationCmd;
import org.camunda.bpm.engine.impl.migration.MigrationLogger;
import org.camunda.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;

public class MigrateProcessInstanceBatchCmd
extends AbstractMigrationCmd<Batch> {
    protected static final MigrationLogger LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;

    public MigrateProcessInstanceBatchCmd(MigrationPlanExecutionBuilderImpl migrationPlanExecutionBuilder) {
        super(migrationPlanExecutionBuilder);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        MigrationPlan migrationPlan = this.executionBuilder.getMigrationPlan();
        Collection<String> processInstanceIds = this.collectProcessInstanceIds(commandContext);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Migration plan cannot be null", "migration plan", (Object)migrationPlan);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot empty", "process instance ids", processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "process instance ids", processInstanceIds);
        ProcessDefinitionEntity sourceProcessDefinition = this.resolveSourceProcessDefinition(commandContext);
        ProcessDefinitionEntity targetProcessDefinition = this.resolveTargetProcessDefinition(commandContext);
        this.checkAuthorizations(commandContext, sourceProcessDefinition, targetProcessDefinition, processInstanceIds);
        this.writeUserOperationLog(commandContext, sourceProcessDefinition, targetProcessDefinition, processInstanceIds.size(), true);
        BatchEntity batch = this.createBatch(commandContext, migrationPlan, processInstanceIds, sourceProcessDefinition);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    @Override
    protected void checkAuthorizations(CommandContext commandContext, ProcessDefinitionEntity sourceDefinition, ProcessDefinitionEntity targetDefinition, Collection<String> processInstanceIds) {
        commandContext.getAuthorizationManager().checkAuthorization(Permissions.CREATE, Resources.BATCH);
        super.checkAuthorizations(commandContext, sourceDefinition, targetDefinition, processInstanceIds);
    }

    protected BatchEntity createBatch(CommandContext commandContext, MigrationPlan migrationPlan, Collection<String> processInstanceIds, ProcessDefinitionEntity sourceProcessDefinition) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        BatchJobHandler<MigrationBatchConfiguration> batchJobHandler = this.getBatchJobHandler(processEngineConfiguration);
        MigrationBatchConfiguration configuration = new MigrationBatchConfiguration(new ArrayList<String>(processInstanceIds), migrationPlan, this.executionBuilder.isSkipCustomListeners(), this.executionBuilder.isSkipIoMappings());
        BatchEntity batch = new BatchEntity();
        batch.setType(batchJobHandler.getType());
        batch.setTotalJobs(this.calculateSize(processEngineConfiguration, configuration));
        batch.setBatchJobsPerSeed(processEngineConfiguration.getBatchJobsPerSeed());
        batch.setInvocationsPerBatchJob(processEngineConfiguration.getInvocationsPerBatchJob());
        batch.setConfigurationBytes(batchJobHandler.writeConfiguration(configuration));
        batch.setTenantId(sourceProcessDefinition.getTenantId());
        commandContext.getBatchManager().insert(batch);
        return batch;
    }

    protected int calculateSize(ProcessEngineConfigurationImpl engineConfiguration, MigrationBatchConfiguration batchConfiguration) {
        int invocationsPerBatchJob = engineConfiguration.getInvocationsPerBatchJob();
        int processInstanceCount = batchConfiguration.getIds().size();
        return (int)Math.ceil(processInstanceCount / invocationsPerBatchJob);
    }

    protected BatchJobHandler<MigrationBatchConfiguration> getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("instance-migration");
    }
}

