/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.rbac;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.casbin.jcasbin.rbac.Role;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.Util;

public class DefaultRoleManager
implements RoleManager {
    private Map<String, Role> allRoles = new HashMap<String, Role>();
    private int maxHierarchyLevel;

    public DefaultRoleManager(int maxHierarchyLevel) {
        this.maxHierarchyLevel = maxHierarchyLevel;
    }

    private boolean hasRole(String name) {
        return this.allRoles.containsKey(name);
    }

    private Role createRole(String name) {
        if (this.hasRole(name)) {
            return this.allRoles.get(name);
        }
        Role role = new Role(name);
        this.allRoles.put(name, role);
        return role;
    }

    @Override
    public void clear() {
        this.allRoles.clear();
    }

    @Override
    public void addLink(String name1, String name2, String ... domain) {
        if (domain.length == 1) {
            name1 = domain[0] + "::" + name1;
            name2 = domain[0] + "::" + name2;
        } else if (domain.length > 1) {
            throw new Error("error: domain should be 1 parameter");
        }
        Role role1 = this.createRole(name1);
        Role role2 = this.createRole(name2);
        role1.addRole(role2);
    }

    @Override
    public void deleteLink(String name1, String name2, String ... domain) {
        if (domain.length == 1) {
            name1 = domain[0] + "::" + name1;
            name2 = domain[0] + "::" + name2;
        } else if (domain.length > 1) {
            throw new Error("error: domain should be 1 parameter");
        }
        if (!this.hasRole(name1) || !this.hasRole(name2)) {
            throw new Error("error: name1 or name2 does not exist");
        }
        Role role1 = this.createRole(name1);
        Role role2 = this.createRole(name2);
        role1.deleteRole(role2);
    }

    @Override
    public boolean hasLink(String name1, String name2, String ... domain) {
        if (domain.length == 1) {
            name1 = domain[0] + "::" + name1;
            name2 = domain[0] + "::" + name2;
        } else if (domain.length > 1) {
            throw new Error("error: domain should be 1 parameter");
        }
        if (name1.equals(name2)) {
            return true;
        }
        if (!this.hasRole(name1) || !this.hasRole(name2)) {
            return false;
        }
        Role role1 = this.createRole(name1);
        return role1.hasRole(name2, this.maxHierarchyLevel);
    }

    @Override
    public List<String> getRoles(String name, String ... domain) {
        if (domain.length == 1) {
            name = domain[0] + "::" + name;
        } else if (domain.length > 1) {
            throw new Error("error: domain should be 1 parameter");
        }
        if (!this.hasRole(name)) {
            throw new Error("error: name does not exist");
        }
        List<String> roles = this.createRole(name).getRoles();
        if (domain.length == 1) {
            for (int i = 0; i < roles.size(); ++i) {
                roles.set(i, roles.get(i).substring(domain[0].length() + 2, roles.get(i).length()));
            }
        }
        return roles;
    }

    @Override
    public List<String> getUsers(String name) {
        if (!this.hasRole(name)) {
            throw new Error("error: name does not exist");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Role role : this.allRoles.values()) {
            if (!role.hasDirectRole(name)) continue;
            names.add(role.name);
        }
        return names;
    }

    @Override
    public void printRoles() {
        for (Role role : this.allRoles.values()) {
            Util.logPrint(role.toString());
        }
    }
}

