/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Watcher;

public class SyncedEnforcer
extends Enforcer {
    private static final ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();

    public SyncedEnforcer() {
    }

    public SyncedEnforcer(String modelPath, String policyFile) {
        super(modelPath, policyFile);
    }

    public SyncedEnforcer(String modelPath, Adapter adapter) {
        super(modelPath, adapter);
    }

    public SyncedEnforcer(Model m, Adapter adapter) {
        super(m, adapter);
    }

    public SyncedEnforcer(Model m) {
        super(m);
    }

    public SyncedEnforcer(String modelPath) {
        super(modelPath);
    }

    public SyncedEnforcer(String modelPath, String policyFile, boolean enableLog) {
        super(modelPath, policyFile, enableLog);
    }

    @Override
    public void setWatcher(Watcher watcher) {
        this.watcher = watcher;
        watcher.setUpdateCallback(this::loadPolicy);
    }

    @Override
    public void clearPolicy() {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            super.clearPolicy();
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public void loadPolicy() {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            super.loadPolicy();
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public void loadFilteredPolicy(Object filter) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            super.loadFilteredPolicy(filter);
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public void savePolicy() {
        try {
            READ_WRITE_LOCK.readLock().lock();
            super.savePolicy();
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public void buildRoleLinks() {
        try {
            READ_WRITE_LOCK.readLock().lock();
            super.buildRoleLinks();
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public boolean enforce(Object ... rvals) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.enforce(rvals);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<String> getAllSubjects() {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getAllSubjects();
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<String> getAllObjects() {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getAllObjects();
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<String> getAllNamedObjects(String ptype) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getAllNamedObjects(ptype);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<String> getAllActions() {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getAllActions();
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<String> getAllNamedActions(String ptype) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getAllNamedActions(ptype);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<String> getAllRoles() {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getAllRoles();
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<String> getAllNamedRoles(String ptype) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getAllNamedRoles(ptype);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<List<String>> getPolicy() {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getPolicy();
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<String>> getFilteredPolicy(int fieldIndex, String ... fieldValues) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getFilteredPolicy(fieldIndex, fieldValues);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<List<String>> getNamedPolicy(String ptype) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getNamedPolicy(ptype);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<String>> getFilteredNamedPolicy(String ptype, int fieldIndex, String ... fieldValues) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getFilteredNamedPolicy(ptype, fieldIndex, fieldValues);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<List<String>> getGroupingPolicy() {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getGroupingPolicy();
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<String> getRolesForUser(String name) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getRolesForUser(name);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<String>> getFilteredGroupingPolicy(int fieldIndex, String ... fieldValues) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getFilteredGroupingPolicy(fieldIndex, fieldValues);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<List<String>> getNamedGroupingPolicy(String ptype) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getNamedGroupingPolicy(ptype);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<String>> getFilteredNamedGroupingPolicy(String ptype, int fieldIndex, String ... fieldValues) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getFilteredNamedGroupingPolicy(ptype, fieldIndex, fieldValues);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public boolean hasPolicy(List<String> params) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasPolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public boolean hasPolicy(String ... params) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasPolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNamedPolicy(String ptype, List<String> params) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasNamedPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNamedPolicy(String ptype, String ... params) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasNamedPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public boolean addPolicy(List<String> params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addPolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean addPolicy(String ... params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addPolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addNamedPolicy(String ptype, List<String> params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addNamedPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addNamedPolicy(String ptype, String ... params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addNamedPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean removePolicy(List<String> params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removePolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean removePolicy(String ... params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removePolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFilteredPolicy(int fieldIndex, String ... fieldValues) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removeFilteredPolicy(fieldIndex, fieldValues);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNamedPolicy(String ptype, List<String> params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removeNamedPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNamedPolicy(String ptype, String ... params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removeNamedPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFilteredNamedPolicy(String ptype, int fieldIndex, String ... fieldValues) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removeFilteredNamedPolicy(ptype, fieldIndex, fieldValues);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean hasGroupingPolicy(List<String> params) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasGroupingPolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public boolean hasGroupingPolicy(String ... params) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasGroupingPolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNamedGroupingPolicy(String ptype, List<String> params) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasNamedGroupingPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNamedGroupingPolicy(String ptype, String ... params) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasNamedGroupingPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public boolean addGroupingPolicy(List<String> params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addGroupingPolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean addGroupingPolicy(String ... params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addGroupingPolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addNamedGroupingPolicy(String ptype, List<String> params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addNamedGroupingPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addNamedGroupingPolicy(String ptype, String ... params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addNamedGroupingPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean removeGroupingPolicy(List<String> params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removeGroupingPolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean removeGroupingPolicy(String ... params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removeGroupingPolicy(params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFilteredGroupingPolicy(int fieldIndex, String ... fieldValues) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removeFilteredGroupingPolicy(fieldIndex, fieldValues);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNamedGroupingPolicy(String ptype, List<String> params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removeNamedGroupingPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNamedGroupingPolicy(String ptype, String ... params) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removeNamedGroupingPolicy(ptype, params);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFilteredNamedGroupingPolicy(String ptype, int fieldIndex, String ... fieldValues) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.removeFilteredNamedGroupingPolicy(ptype, fieldIndex, fieldValues);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public List<String> getUsersForRole(String name) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getUsersForRole(name);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRoleForUser(String name, String role) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasRoleForUser(name, role);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRoleForUser(String user, String role) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addRoleForUser(user, role);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRoleForUser(String user, String role) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deleteRoleForUser(user, role);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean deleteRolesForUser(String user) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deleteRolesForUser(user);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean deleteUser(String user) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deleteUser(user);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public void deleteRole(String role) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            super.deleteRole(role);
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean deletePermission(String ... permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deletePermission(permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean deletePermission(List<String> permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deletePermission(permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermissionForUser(String user, String ... permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addPermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermissionForUser(String user, List<String> permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addPermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePermissionForUser(String user, String ... permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deletePermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePermissionForUser(String user, List<String> permission) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deletePermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public boolean deletePermissionsForUser(String user) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deletePermissionsForUser(user);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public List<List<String>> getPermissionsForUser(String user) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getPermissionsForUser(user);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPermissionForUser(String user, String ... permission) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasPermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPermissionForUser(String user, List<String> permission) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            boolean bl = super.hasPermissionForUser(user, permission);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRolesForUserInDomain(String name, String domain) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getRolesForUserInDomain(name, domain);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<String>> getPermissionsForUserInDomain(String user, String domain) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getPermissionsForUserInDomain(user, domain);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRoleForUserInDomain(String user, String role, String domain) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.addRoleForUserInDomain(user, role, domain);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRoleForUserInDomain(String user, String role, String domain) {
        try {
            READ_WRITE_LOCK.writeLock().lock();
            boolean bl = super.deleteRoleForUserInDomain(user, role, domain);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getImplicitRolesForUser(String name, String ... domain) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<String> list = super.getImplicitRolesForUser(name, domain);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    @Override
    public List<List<String>> getImplicitPermissionsForUser(String user) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            List<List<String>> list = super.getImplicitPermissionsForUser(user);
            return list;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }
}

