/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.rbac;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.casbin.jcasbin.rbac.DefaultRoleManager;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.SyncedLRUCache;
import org.casbin.jcasbin.util.Util;

public class DomainManager
implements RoleManager {
    private static final String DEFAULT_DOMAIN = "casbin::default";
    private Map<String, DefaultRoleManager> rmMap;
    private int maxHierarchyLevel;
    private BiPredicate<String, String> matchingFunc;
    private BiPredicate<String, String> domainMatchingFunc;
    private SyncedLRUCache<String, Boolean> domainMatchingFuncCache;

    public DomainManager(int maxHierarchyLevel) {
        this(maxHierarchyLevel, null, null);
    }

    public DomainManager(int maxHierarchyLevel, BiPredicate<String, String> matchingFunc, BiPredicate<String, String> domainMatchingFunc) {
        this.clear();
        this.maxHierarchyLevel = maxHierarchyLevel;
        this.matchingFunc = matchingFunc;
        this.domainMatchingFunc = domainMatchingFunc;
    }

    public void addMatchingFunc(String name, BiPredicate<String, String> matchingFunc) {
        this.matchingFunc = matchingFunc;
        this.rmMap.values().forEach(rm -> rm.addMatchingFunc(name, matchingFunc));
    }

    public void addDomainMatchingFunc(String name, BiPredicate<String, String> domainMatchingFunc) {
        this.domainMatchingFunc = domainMatchingFunc;
        this.rebuild();
    }

    private void rebuild() {
        HashMap<String, DefaultRoleManager> rmMap = new HashMap<String, DefaultRoleManager>(this.rmMap);
        this.clear();
        rmMap.forEach((domain, rm) -> rm.allRoles.values().forEach(user -> user.roles.keySet().forEach(roleName -> this.addLink(user.getName(), (String)roleName, (String)domain))));
    }

    private String domainName(String ... domain) {
        return domain.length == 0 ? DEFAULT_DOMAIN : domain[0];
    }

    private DefaultRoleManager getRoleManager(String domain, boolean store) {
        DefaultRoleManager rm = this.rmMap.get(domain);
        if (rm == null) {
            rm = new DefaultRoleManager(this.maxHierarchyLevel, this.matchingFunc, null);
            if (store) {
                this.rmMap.put(domain, rm);
            }
            if (this.domainMatchingFunc != null) {
                for (Map.Entry<String, DefaultRoleManager> entry : this.rmMap.entrySet()) {
                    String domain2 = entry.getKey();
                    DefaultRoleManager rm2 = entry.getValue();
                    if (domain.equals(domain2) || !this.match(domain, domain2)) continue;
                    rm.copyFrom(rm2);
                }
            }
        }
        return rm;
    }

    private boolean match(String str, String pattern) {
        String cacheKey = String.join((CharSequence)"$$", str, pattern);
        Boolean matched = this.domainMatchingFuncCache.get(cacheKey);
        if (matched == null) {
            matched = this.domainMatchingFunc != null ? Boolean.valueOf(this.domainMatchingFunc.test(str, pattern)) : Boolean.valueOf(str.equals(pattern));
            this.domainMatchingFuncCache.put(cacheKey, matched);
        }
        return matched;
    }

    @Override
    public void clear() {
        this.rmMap = new HashMap<String, DefaultRoleManager>();
        this.domainMatchingFuncCache = new SyncedLRUCache(100);
    }

    @Override
    public void addLink(String name1, String name2, String ... domain) {
        DefaultRoleManager roleManager = this.getRoleManager(this.domainName(domain), true);
        roleManager.addLink(name1, name2, domain);
        if (this.domainMatchingFunc != null) {
            this.rmMap.forEach((domain2, rm) -> {
                if (!this.domainName(domain).equals(domain2) && this.match((String)domain2, this.domainName(domain))) {
                    rm.addLink(name1, name2, domain);
                }
            });
        }
    }

    @Override
    public void deleteLink(String name1, String name2, String ... domain) {
        DefaultRoleManager roleManager = this.getRoleManager(this.domainName(domain), true);
        roleManager.deleteLink(name1, name2, domain);
        if (this.domainMatchingFunc != null) {
            this.rmMap.forEach((domain2, rm) -> {
                if (!this.domainName(domain).equals(domain2) && this.match((String)domain2, this.domainName(domain))) {
                    rm.deleteLink(name1, name2, domain);
                }
            });
        }
    }

    @Override
    public boolean hasLink(String name1, String name2, String ... domain) {
        DefaultRoleManager roleManager = this.getRoleManager(this.domainName(domain), false);
        return roleManager.hasLink(name1, name2, domain);
    }

    @Override
    public List<String> getRoles(String name, String ... domain) {
        DefaultRoleManager roleManager = this.getRoleManager(this.domainName(domain), false);
        return roleManager.getRoles(name, domain);
    }

    @Override
    public List<String> getUsers(String name, String ... domain) {
        DefaultRoleManager roleManager = this.getRoleManager(this.domainName(domain), false);
        return roleManager.getUsers(name, domain);
    }

    public String toString() {
        ArrayList roles = new ArrayList();
        this.rmMap.forEach((domain, rm) -> {
            ArrayList domainRoles = new ArrayList();
            rm.allRoles.values().forEach(role -> {
                if (!"".equals(role.toString())) {
                    domainRoles.add(role.toString());
                }
            });
            roles.add(domain + ": " + String.join((CharSequence)", ", domainRoles));
        });
        return String.join((CharSequence)"\n", roles);
    }

    @Override
    public void printRoles() {
        Util.logPrintfInfo("{}", this);
    }
}

