/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.casbin.jcasbin.main.SyncedEnforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.BatchAdapter;
import org.casbin.jcasbin.persist.UpdatableAdapter;
import org.casbin.jcasbin.util.Util;

public class DistributedEnforcer
extends SyncedEnforcer {
    public DistributedEnforcer() {
    }

    public DistributedEnforcer(String modelPath, String policyFile) {
        super(modelPath, policyFile);
    }

    public DistributedEnforcer(String modelPath, Adapter adapter) {
        super(modelPath, adapter);
    }

    public DistributedEnforcer(Model m, Adapter adapter) {
        super(m, adapter);
    }

    public DistributedEnforcer(Model m) {
        super(m);
    }

    public DistributedEnforcer(String modelPath) {
        super(modelPath);
    }

    public DistributedEnforcer(String modelPath, String policyFile, boolean enableLog) {
        super(modelPath, policyFile, enableLog);
    }

    public List<List<String>> addPolicySelf(BooleanSupplier shouldPersist, String sec, String ptype, List<List<String>> rules) {
        ArrayList<List<String>> noExistsPolicy = new ArrayList<List<String>>();
        for (List<String> rule : rules) {
            if (!this.model.hasPolicy(sec, ptype, rule)) continue;
            noExistsPolicy.add(rule);
        }
        if (shouldPersist.getAsBoolean()) {
            try {
                if (this.adapter instanceof BatchAdapter) {
                    ((BatchAdapter)this.adapter).addPolicies(sec, ptype, rules);
                }
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return null;
            }
        }
        this.model.addPolicies(sec, ptype, noExistsPolicy);
        if (sec.equals("g")) {
            try {
                this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_ADD, ptype, noExistsPolicy);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return noExistsPolicy;
            }
        }
        System.out.println();
        return rules;
    }

    public List<List<String>> removePolicySelf(BooleanSupplier shouldPersist, String sec, String ptype, List<List<String>> rules) {
        if (shouldPersist.getAsBoolean()) {
            try {
                if (this.adapter instanceof BatchAdapter) {
                    ((BatchAdapter)this.adapter).removePolicies(sec, ptype, rules);
                }
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return null;
            }
        }
        this.model.removePolicies(sec, ptype, rules);
        if (sec.equals("g")) {
            try {
                this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_REMOVE, ptype, (List)rules);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return rules;
            }
        }
        return rules;
    }

    public List<List<String>> removeFilteredPolicySelf(BooleanSupplier shouldPersist, String sec, String ptype, int fieldIndex, String ... fieldValues) {
        if (shouldPersist.getAsBoolean()) {
            try {
                this.adapter.removeFilteredPolicy(sec, ptype, fieldIndex, fieldValues);
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return null;
            }
        }
        List<List<String>> effects = this.model.removeFilteredPolicyReturnsEffects(sec, ptype, fieldIndex, fieldValues);
        if (sec.equals("g")) {
            try {
                this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_REMOVE, ptype, (List)effects);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return effects;
            }
        }
        return effects;
    }

    public void clearPolicySelf(BooleanSupplier shouldPersist) {
        if (shouldPersist.getAsBoolean()) {
            try {
                this.adapter.savePolicy(null);
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return;
            }
        }
        this.model.clearPolicy();
    }

    public boolean updatePolicySelf(BooleanSupplier shouldPersist, String sec, String ptype, List<String> oldRule, List<String> newRule) {
        boolean ruleUpdated;
        if (shouldPersist.getAsBoolean()) {
            try {
                if (this.adapter instanceof UpdatableAdapter) {
                    ((UpdatableAdapter)this.adapter).updatePolicy(sec, ptype, oldRule, newRule);
                }
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        if (!(ruleUpdated = this.model.updatePolicy(sec, ptype, oldRule, newRule))) {
            return false;
        }
        ArrayList<List<String>> rules = new ArrayList<List<String>>();
        if (sec.equals("g")) {
            try {
                rules.add(oldRule);
                this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_REMOVE, ptype, rules);
            }
            catch (Exception e) {
                return false;
            }
            try {
                rules.add(newRule);
                this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_ADD, ptype, rules);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

