/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.rbac;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.casbin.jcasbin.rbac.DomainRoles;
import org.casbin.jcasbin.rbac.Role;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.Util;

public class DefaultRoleManager
implements RoleManager {
    private static String defaultDomain = "casbin::default";
    private Map<String, DomainRoles> allDomains = new HashMap<String, DomainRoles>();
    private int maxHierarchyLevel;
    private BiPredicate<String, String> matchingFunc;
    private BiPredicate<String, String> domainMatchingFunc;

    public DefaultRoleManager(int maxHierarchyLevel) {
        this(maxHierarchyLevel, null, null);
    }

    public DefaultRoleManager(int maxHierarchyLevel, BiPredicate<String, String> matchingFunc, BiPredicate<String, String> domainMatchingFunc) {
        this.maxHierarchyLevel = maxHierarchyLevel;
        this.matchingFunc = matchingFunc;
        this.domainMatchingFunc = domainMatchingFunc;
    }

    private String domainName(String ... domain) {
        return domain.length == 0 ? defaultDomain : domain[0];
    }

    private DomainRoles getMatchingDomainRoles(String ... domain) {
        if (this.domainMatchingFunc != null) {
            return this.generateTempRoles(this.domainName(domain));
        }
        return this.getOrCreateDomainRoles(this.domainName(domain));
    }

    private DomainRoles generateTempRoles(String domain) {
        this.allDomains.computeIfAbsent(domain, k -> new DomainRoles());
        DomainRoles allRoles = new DomainRoles();
        Set<String> patternDomains = this.getPatternMatchedDomainNames(domain);
        patternDomains.forEach(p -> {
            this.allDomains.computeIfAbsent((String)p, k -> new DomainRoles());
            this.createTempRolesForDomain(allRoles, (String)p);
        });
        return allRoles;
    }

    private Set<String> getPatternMatchedDomainNames(String domain) {
        HashSet<String> patternDomains = new HashSet<String>();
        patternDomains.add(domain);
        if (this.domainMatchingFunc != null) {
            this.allDomains.keySet().stream().filter(d -> this.domainMatchingFunc.test(domain, (String)d)).forEach(patternDomains::add);
        }
        return patternDomains;
    }

    private void createTempRolesForDomain(DomainRoles allRoles, String domainName) {
        this.allDomains.get(domainName).forEach((roleName, role) -> {
            Role role1 = allRoles.createRole(role.getName(), this.matchingFunc);
            role.getRoles().forEach(role2Name -> {
                Role role3 = allRoles.createRole((String)role2Name, this.matchingFunc);
                role1.addRole(role3);
            });
        });
    }

    @Override
    public void clear() {
        this.allDomains.clear();
        this.allDomains.put(defaultDomain, new DomainRoles());
    }

    private DomainRoles getOrCreateDomainRoles(String domain) {
        return this.allDomains.computeIfAbsent(domain, k -> new DomainRoles());
    }

    @Override
    public void addLink(String name1, String name2, String ... domain) {
        if (domain.length > 1) {
            throw new IllegalArgumentException("error: domain should be 1 parameter");
        }
        DomainRoles allRoles = this.getOrCreateDomainRoles(this.domainName(domain));
        Role role1 = allRoles.getOrCreate(name1);
        Role role2 = allRoles.getOrCreate(name2);
        role1.addRole(role2);
    }

    @Override
    public void deleteLink(String name1, String name2, String ... domain) {
        if (domain.length > 1) {
            throw new IllegalArgumentException("error: domain should be 1 parameter");
        }
        DomainRoles allRoles = this.getOrCreateDomainRoles(this.domainName(domain));
        if (!allRoles.hasRole(name1) || !allRoles.hasRole(name2)) {
            throw new IllegalArgumentException("error: name1 or name2 does not exist");
        }
        Role role1 = allRoles.getOrCreate(name1);
        Role role2 = allRoles.getOrCreate(name2);
        role1.deleteRole(role2);
    }

    @Override
    public boolean hasLink(String name1, String name2, String ... domain) {
        this.isValidDomainOrThrow(domain);
        if (name1.equals(name2)) {
            return true;
        }
        DomainRoles allRoles = this.getMatchingDomainRoles(domain);
        if (!allRoles.hasRole(name1, this.matchingFunc) || !allRoles.hasRole(name2, this.matchingFunc)) {
            return false;
        }
        Role role1 = allRoles.createRole(name1, this.matchingFunc);
        return role1.hasRole(name2, this.maxHierarchyLevel);
    }

    private void isValidDomainOrThrow(String ... domain) {
        if (domain.length > 1) {
            throw new IllegalArgumentException("error: domain should be 1 parameter");
        }
        if (domain.length >= 1 && "*".equals(domain[0])) {
            throw new IllegalArgumentException("error: domain can't be *");
        }
    }

    @Override
    public List<String> getRoles(String name, String ... domain) {
        if (domain.length > 1) {
            throw new IllegalArgumentException("error: domain should be 1 parameter");
        }
        DomainRoles allRoles = this.getMatchingDomainRoles(domain);
        if (!allRoles.hasRole(name, this.matchingFunc)) {
            Util.logPrintfError("error: name does not exist", new Object[0]);
            return Collections.emptyList();
        }
        return allRoles.createRole(name, this.matchingFunc).getRoles();
    }

    @Override
    public List<String> getUsers(String name, String ... domain) {
        if (domain.length > 1) {
            throw new IllegalArgumentException("error: domain should be 1 parameter");
        }
        DomainRoles allRoles = this.getMatchingDomainRoles(domain);
        if (!allRoles.hasRole(name, this.domainMatchingFunc)) {
            throw new IllegalArgumentException("error: name does not exist");
        }
        ArrayList<String> names = new ArrayList<String>();
        allRoles.forEach((roleName, role) -> {
            if (role.hasDirectRole(name)) {
                names.add((String)roleName);
            }
        });
        return names;
    }

    @Override
    public void printRoles() {
        this.allDomains.forEach((domain, roles) -> roles.forEach((name, role) -> Util.logPrint(role.toString())));
    }
}

