/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.api.smsProxy;

import org.dromara.sms4j.comm.config.SmsConfig;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtil;
import org.dromara.sms4j.comm.utils.TimeExpiredPoolCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedProcess {
    private static final Logger log = LoggerFactory.getLogger(RestrictedProcess.class);
    static Long minTimer = 60000L;
    static Long accTimer = 86400000L;

    /*
     * Enabled aggressive block sorting
     */
    public SmsBlendException process(SmsConfig config, String args) throws Exception {
        TimeExpiredPoolCache instance = TimeExpiredPoolCache.getInstance();
        Integer accountMax = config.getAccountMax();
        Integer minuteMax = config.getMinuteMax();
        if (SmsUtil.isNotEmpty((Object)accountMax)) {
            Integer i = (Integer)instance.get(args + "max");
            if (SmsUtil.isEmpty((Object)i)) {
                instance.put(args + "max", (Object)1, accTimer.longValue());
            } else {
                if (i > accountMax) {
                    log.info("The phone:" + args + ",number of short messages reached the maximum today");
                    return new SmsBlendException("The phone:" + args + ",number of short messages reached the maximum today");
                }
                instance.put(args + "max", (Object)(i + 1), accTimer.longValue());
            }
        }
        if (!SmsUtil.isNotEmpty((Object)minuteMax)) return null;
        Integer o = (Integer)instance.get(args);
        if (!SmsUtil.isNotEmpty((Object)o)) {
            instance.put(args, (Object)1, minTimer.longValue());
            return null;
        }
        if (o < minuteMax) {
            instance.put(args, (Object)(o + 1), minTimer.longValue());
            return null;
        }
        log.info("The phone:", (Object)(args + " Text messages are sent too often\uff01"));
        return new SmsBlendException("The phone:", args + " Text messages are sent too often\uff01");
    }
}

