/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.api.dao;

import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.sms4j.api.dao.SmsDao;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsDaoDefaultImpl
implements SmsDao {
    private static final Logger log = LoggerFactory.getLogger(SmsDaoDefaultImpl.class);
    private static volatile SmsDaoDefaultImpl INSTANCE;
    private static final Timer TIMER;
    private static final ConcurrentHashMap<String, DataWrapper> DATA_MAP;
    private static final long DEFAULT_CACHE_TIME = 86400000L;
    private static final long TIMER_INTERVAL = 30000L;

    private SmsDaoDefaultImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsDaoDefaultImpl getInstance() {
        if (null != INSTANCE) return INSTANCE;
        Class<SmsDaoDefaultImpl> clazz = SmsDaoDefaultImpl.class;
        synchronized (SmsDaoDefaultImpl.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new SmsDaoDefaultImpl();
            SmsDaoDefaultImpl.initTimer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public void set(String key, Object value, long cacheTime) {
        cacheTime *= 1000L;
        DataWrapper dataWrapper = DATA_MAP.get(key);
        if (null != dataWrapper) {
            dataWrapper.update(value, cacheTime);
        } else {
            dataWrapper = new DataWrapper(value, cacheTime);
            DATA_MAP.put(key, dataWrapper);
        }
    }

    @Override
    public void set(String key, Object value) {
        this.set(key, value, 86400000L);
    }

    @Override
    public Object get(String key) {
        DataWrapper dataWrapper = DATA_MAP.get(key);
        if (dataWrapper != null && !dataWrapper.isExpired()) {
            return dataWrapper.data;
        }
        return null;
    }

    @Override
    public Object remove(String key) {
        return DATA_MAP.remove(key);
    }

    @Override
    public void clean() {
        DATA_MAP.clear();
    }

    private static void initTimer() {
        TIMER.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    SmsDaoDefaultImpl.clearExpiredData();
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new SmsBlendException(e.getMessage());
                }
            }
        }, 30000L, 30000L);
    }

    private static void clearExpiredData() {
        LinkedList<String> expiredKeyList = new LinkedList<String>();
        for (Map.Entry<String, DataWrapper> entry : DATA_MAP.entrySet()) {
            if (!entry.getValue().isExpired()) continue;
            expiredKeyList.add(entry.getKey());
        }
        for (String key : expiredKeyList) {
            DATA_MAP.remove(key);
        }
    }

    static {
        TIMER = new Timer();
        DATA_MAP = new ConcurrentHashMap();
    }

    private static class DataWrapper {
        private Object data;
        private long expiredTime;
        private long cacheTime;

        private DataWrapper(Object data, long cacheTime) {
            this.update(data, cacheTime);
        }

        public void update(Object data, long cacheTime) {
            this.data = data;
            this.cacheTime = cacheTime;
            this.expiredTime = System.currentTimeMillis() + cacheTime;
        }

        public boolean isExpired() {
            if (this.expiredTime > 0L) {
                return System.currentTimeMillis() > this.expiredTime;
            }
            return true;
        }

        public Object getData() {
            return this.data;
        }

        public long getExpiredTime() {
            return this.expiredTime;
        }

        public long getCacheTime() {
            return this.cacheTime;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public void setExpiredTime(long expiredTime) {
            this.expiredTime = expiredTime;
        }

        public void setCacheTime(long cacheTime) {
            this.cacheTime = cacheTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataWrapper)) {
                return false;
            }
            DataWrapper other = (DataWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpiredTime() != other.getExpiredTime()) {
                return false;
            }
            if (this.getCacheTime() != other.getCacheTime()) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expiredTime = this.getExpiredTime();
            result = result * 59 + (int)($expiredTime >>> 32 ^ $expiredTime);
            long $cacheTime = this.getCacheTime();
            result = result * 59 + (int)($cacheTime >>> 32 ^ $cacheTime);
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "SmsDaoDefaultImpl.DataWrapper(data=" + this.getData() + ", expiredTime=" + this.getExpiredTime() + ", cacheTime=" + this.getCacheTime() + ")";
        }
    }
}

