/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.comm.utils;

import cn.hutool.core.util.StrUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import org.dromara.sms4j.comm.config.SmsSqlConfig;
import org.dromara.sms4j.comm.exception.SmsSqlException;
import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.comm.utils.SmsUtil;

public class JDBCTool {
    public static final String SELECT = "select {},{} from {} where {} = {}";
    private static final String ERR_CONFIG = "One configuration was expected, but {} was found. Please check your database configuration";
    private final SmsSqlConfig config;
    private Connection connection;

    public JDBCTool(SmsSqlConfig config, Connection connection) {
        this.config = config;
        this.connection = connection;
    }

    public JDBCTool(SmsSqlConfig config) {
        this.config = config;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public static Map<String, String> selectConfig() {
        Map<String, String> select = BeanFactory.getJDBCTool().select();
        if (select.size() == 0) {
            throw new SmsSqlException("No valid configuration was scanned. Please check whether the configuration file or database link is normal");
        }
        return select;
    }

    public Connection getConn() {
        Connection connection;
        if (SmsUtil.isEmpty(this.config.getUrl())) {
            throw new SmsSqlException("The configuration file failed to be loaded");
        }
        try {
            String url = this.config.getDatabaseName().isEmpty() ? this.config.getUrl() : this.config.getUrl() + "/" + this.config.getDatabaseName();
            connection = DriverManager.getConnection(url, this.config.getUsername(), this.config.getPassword());
        }
        catch (SQLException e) {
            throw new SmsSqlException(e.getMessage());
        }
        return connection;
    }

    public Map<String, String> select(String sql) {
        if (Objects.isNull(this.connection)) {
            this.connection = this.getConn();
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, String> map = new Hashtable<String, String>();
        try {
            preparedStatement = this.connection.prepareStatement(sql, 1003, 1007);
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String data = resultSet.getString(this.config.getConfigName());
                String supplier = resultSet.getString(this.config.getSupplierFieldName());
                map.put(supplier, data);
            }
            this.close(this.connection, preparedStatement, resultSet);
        }
        catch (SQLException e) {
            try {
                throw new SmsSqlException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(this.connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        return map;
    }

    private void close(Connection conn, PreparedStatement stmt, ResultSet rs) {
        if (conn != null) {
            // empty if block
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new SmsSqlException(e.getMessage());
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new SmsSqlException(e.getMessage());
            }
        }
    }

    public Map<String, String> select() {
        String format = StrUtil.format((CharSequence)SELECT, (Object[])new Object[]{this.config.getConfigName(), this.config.getSupplierFieldName(), this.config.getTableName(), this.config.getStartName(), this.config.getIsStart()});
        return this.select(format);
    }
}

