/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.starter.config;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.dromara.sms4j.aliyun.config.AlibabaFactory;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.proxy.SmsProcessor;
import org.dromara.sms4j.api.universal.SupplierConfig;
import org.dromara.sms4j.api.verify.PhoneVerify;
import org.dromara.sms4j.baidu.config.BaiduFactory;
import org.dromara.sms4j.budingyun.config.BudingV2Factory;
import org.dromara.sms4j.chuanglan.config.ChuangLanFactory;
import org.dromara.sms4j.cloopen.config.CloopenFactory;
import org.dromara.sms4j.comm.enums.ConfigType;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.core.datainterface.SmsReadConfig;
import org.dromara.sms4j.core.factory.SmsFactory;
import org.dromara.sms4j.core.proxy.EnvirmentHolder;
import org.dromara.sms4j.core.proxy.SmsProxyFactory;
import org.dromara.sms4j.core.proxy.processor.BlackListProcessor;
import org.dromara.sms4j.core.proxy.processor.BlackListRecordingProcessor;
import org.dromara.sms4j.core.proxy.processor.CoreMethodParamValidateProcessor;
import org.dromara.sms4j.core.proxy.processor.RestrictedProcessor;
import org.dromara.sms4j.ctyun.config.CtyunFactory;
import org.dromara.sms4j.danmi.config.DanMiFactory;
import org.dromara.sms4j.dingzhong.config.DingZhongFactory;
import org.dromara.sms4j.emay.config.EmayFactory;
import org.dromara.sms4j.huawei.config.HuaweiFactory;
import org.dromara.sms4j.jdcloud.config.JdCloudFactory;
import org.dromara.sms4j.jg.config.JgFactory;
import org.dromara.sms4j.lianlu.config.LianLuFactory;
import org.dromara.sms4j.luosimao.config.LuoSiMaoFactory;
import org.dromara.sms4j.mas.config.MasFactory;
import org.dromara.sms4j.netease.config.NeteaseFactory;
import org.dromara.sms4j.provider.config.SmsConfig;
import org.dromara.sms4j.provider.factory.BaseProviderFactory;
import org.dromara.sms4j.provider.factory.ProviderFactoryHolder;
import org.dromara.sms4j.qiniu.config.QiNiuFactory;
import org.dromara.sms4j.starter.adaptor.ConfigCombineMapAdaptor;
import org.dromara.sms4j.submail.config.SubMailFactory;
import org.dromara.sms4j.tencent.config.TencentFactory;
import org.dromara.sms4j.unisms.config.UniFactory;
import org.dromara.sms4j.yixintong.config.YiXintongFactory;
import org.dromara.sms4j.yunpian.config.YunPianFactory;
import org.dromara.sms4j.zhutong.config.ZhutongFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class SmsBlendsInitializer {
    private static final Logger log = LoggerFactory.getLogger(SmsBlendsInitializer.class);
    private final List<BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>> factoryList;
    private final SmsConfig smsConfig;
    private final Map<String, Map<String, Object>> blends;
    private final ObjectProvider<SmsReadConfig> extendsSmsConfigs;

    public SmsBlendsInitializer(List<BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>> factoryList, SmsConfig smsConfig, Map<String, Map<String, Object>> blends, ObjectProvider<SmsReadConfig> extendsSmsConfigs) {
        this.factoryList = factoryList;
        this.smsConfig = smsConfig;
        this.blends = blends;
        this.extendsSmsConfigs = extendsSmsConfigs;
        this.onApplicationEvent();
    }

    public void onApplicationEvent() {
        this.registerDefaultFactory();
        ProviderFactoryHolder.registerFactory(this.factoryList);
        ServiceLoader<PhoneVerify> loader = ServiceLoader.load(PhoneVerify.class);
        if (loader.iterator().hasNext()) {
            loader.forEach(f -> SmsProxyFactory.addPreProcessor((SmsProcessor)new CoreMethodParamValidateProcessor(f)));
        } else {
            SmsProxyFactory.addPreProcessor((SmsProcessor)new CoreMethodParamValidateProcessor(null));
        }
        if (this.smsConfig.getRestricted().booleanValue()) {
            SmsProxyFactory.addPreProcessor((SmsProcessor)new RestrictedProcessor());
            SmsProxyFactory.addPreProcessor((SmsProcessor)new BlackListProcessor());
            SmsProxyFactory.addPreProcessor((SmsProcessor)new BlackListRecordingProcessor());
        }
        if (ConfigType.YAML.equals((Object)this.smsConfig.getConfigType())) {
            ConfigCombineMapAdaptor blendsInclude = new ConfigCombineMapAdaptor();
            blendsInclude.putAll(this.blends);
            int num = 0;
            for (SmsReadConfig smsReadConfig : this.extendsSmsConfigs) {
                String key = SmsReadConfig.class.getSimpleName() + num;
                HashMap<String, SmsReadConfig> insideMap = new HashMap<String, SmsReadConfig>();
                insideMap.put(key, smsReadConfig);
                blendsInclude.put(key, insideMap);
                ++num;
            }
            EnvirmentHolder.frozenEnvirmet((SmsConfig)this.smsConfig, blendsInclude);
            for (String configId : this.blends.keySet()) {
                Map<String, Object> configMap = this.blends.get(configId);
                Object supplierObj = configMap.get("supplier");
                String supplier = supplierObj == null ? "" : String.valueOf(supplierObj);
                BaseProviderFactory providerFactory = ProviderFactoryHolder.requireForSupplier((String)(supplier = StrUtil.isEmpty((CharSequence)supplier) ? configId : supplier));
                if (providerFactory == null) {
                    log.warn("\u521b\u5efa\"{}\"\u7684\u77ed\u4fe1\u670d\u52a1\u5931\u8d25\uff0c\u672a\u627e\u5230\u4f9b\u5e94\u5546\u4e3a\"{}\"\u7684\u670d\u52a1", (Object)configId, (Object)supplier);
                    continue;
                }
                configMap.put("config-id", configId);
                SmsUtils.replaceKeysSeparator(configMap, (String)"-", (String)"_");
                JSONObject configJson = new JSONObject(configMap);
                SupplierConfig supplierConfig = (SupplierConfig)JSONUtil.toBean((JSONObject)configJson, (Class)providerFactory.getConfigClass());
                SmsFactory.createSmsBlend((SupplierConfig)supplierConfig);
            }
        }
    }

    private void registerDefaultFactory() {
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)AlibabaFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)CloopenFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)CtyunFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)EmayFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)HuaweiFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)NeteaseFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)TencentFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)UniFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)YunPianFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)ZhutongFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)LianLuFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)DingZhongFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)QiNiuFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)ChuangLanFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)JgFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)BudingV2Factory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)MasFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)BaiduFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)LuoSiMaoFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)SubMailFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)DanMiFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)YiXintongFactory.instance());
        if (SmsUtils.isClassExists((String)"com.jdcloud.sdk.auth.CredentialsProvider")) {
            if (SmsUtils.isClassExists((String)"com.jdcloud.sdk.auth.CredentialsProvider")) {
                ProviderFactoryHolder.registerFactory((BaseProviderFactory)JdCloudFactory.instance());
            }
            log.debug("\u52a0\u8f7d\u5185\u7f6e\u8fd0\u8425\u5546\u5b8c\u6210\uff01");
        }
    }
}

