/*
 * Decompiled with CFR 0.152.
 */
package org.drools.android;

import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.drools.android.DroolsAndroidContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverwriteDexClassLoader
extends DexClassLoader {
    private static final Logger log = LoggerFactory.getLogger(OverwriteDexClassLoader.class);
    final DexOptions dex_options = new DexOptions();
    final CfOptions cf_options = new CfOptions();
    private DexFile dexFile;
    private List<ClassDefItem> items = new LinkedList<ClassDefItem>();
    private File file;
    private static Field pathListField;
    private static Class dexPathListClazz;
    private static Constructor dexPathListConstructor;

    public OverwriteDexClassLoader(String name, ClassLoader parent) {
        super(new File(DroolsAndroidContext.getDexDir(), name + ".dex").getAbsolutePath(), DroolsAndroidContext.getOptimizedDir().getAbsolutePath(), DroolsAndroidContext.getContext().getApplicationInfo().nativeLibraryDir, parent != null ? parent : DroolsAndroidContext.getContext().getClassLoader());
        this.file = new File(DroolsAndroidContext.getDexDir(), name + ".dex");
        this.dex_options.targetApiLevel = 13;
        this.cf_options.optimize = true;
    }

    protected void setName(String name) {
        this.file = new File(DroolsAndroidContext.getDexDir(), name + ".dex");
    }

    public Class defineClass(String name, byte[] bytes) {
        log.trace(this.file.getName() + " classloader - Defining class " + name);
        DirectClassFile cf = new DirectClassFile(bytes, name.replace('.', '/') + ".class", this.cf_options.strictNameCheck);
        cf.setAttributeFactory((AttributeFactory)StdAttributeFactory.THE_ONE);
        cf.getMagic();
        this.dexFile = new DexFile(this.dex_options);
        this.items.add(CfTranslator.translate((DirectClassFile)cf, (byte[])bytes, (CfOptions)this.cf_options, (DexOptions)this.dex_options, (DexFile)this.dexFile));
        for (Object item : this.items) {
            this.dexFile.add(item);
        }
        FileOutputStream fos = null;
        try {
            Object item;
            if (this.file.exists()) {
                this.file.delete();
            }
            fos = new FileOutputStream(this.file);
            this.dexFile.writeTo((OutputStream)fos, null, false);
            pathListField.set((Object)this, dexPathListConstructor.newInstance(new Object[]{this, this.file.getAbsolutePath(), DroolsAndroidContext.getContext().getApplicationInfo().nativeLibraryDir, DroolsAndroidContext.getOptimizedDir()}));
            item = this.findClass(name);
            return item;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        try {
            dexPathListClazz = Class.forName("dalvik.system.DexPathList");
            dexPathListConstructor = dexPathListClazz.getConstructor(ClassLoader.class, String.class, String.class, File.class);
            pathListField = BaseDexClassLoader.class.getDeclaredField("pathList");
            pathListField.setAccessible(true);
        }
        catch (Exception e) {
            log.error("Reflection error", (Throwable)e);
        }
    }
}

