/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes.integration;

import junit.framework.TestCase;
import org.drools.beliefs.bayes.BayesBeliefSystem;
import org.drools.beliefs.bayes.BayesInstance;
import org.drools.beliefs.bayes.BayesModeFactory;
import org.drools.beliefs.bayes.BayesModeFactoryImpl;
import org.drools.beliefs.bayes.PropertyReference;
import org.drools.beliefs.bayes.integration.AssemblerTest;
import org.drools.beliefs.bayes.integration.Garden;
import org.drools.beliefs.bayes.runtime.BayesRuntime;
import org.drools.core.BeliefSystemType;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.rule.EntryPointId;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class BayesBeliefSystemTest {
    @Test
    public void testBayes() {
        String drl = "package org.drools.defeasible; import " + Garden.class.getCanonicalName() + "; \nimport " + PropertyReference.class.getCanonicalName() + "; \nglobal " + BayesModeFactory.class.getCanonicalName() + " bsFactory; \ndialect 'mvel'; \n rule rule1 when         String( this == 'rule1') \n    g : Garden()then     System.out.println(\"rule 1\"); \n    insertLogical( new PropertyReference(g, 'cloudy'), bsFactory.create( new double[] {1.0,0.0} ) ); \n end rule rule2 when         String( this == 'rule2') \n    g : Garden()then     System.out.println(\"rule2\"); \n    insertLogical( new PropertyReference(g, 'sprinkler'), bsFactory.create( new double[] {1.0,0.0} ) ); \n end rule rule3 when         String( this == 'rule3') \n    g : Garden()then     System.out.println(\"rule3\"); \n    insertLogical( new PropertyReference(g, 'sprinkler'), bsFactory.create( new double[] {1.0,0.0} ) ); \n end rule rule4 when         String( this == 'rule4') \n    g : Garden()then     System.out.println(\"rule4\"); \n    insertLogical( new PropertyReference(g, 'sprinkler'), bsFactory.create( new double[] {0.0,1.0} ) ); \n end \n";
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.getSessionFromString(drl);
        NamedEntryPoint ep = (NamedEntryPoint)ksession.getEntryPoint(EntryPointId.DEFAULT.getEntryPointId());
        BayesBeliefSystem bayesBeliefSystem = new BayesBeliefSystem(ep, ep.getTruthMaintenanceSystem());
        BayesModeFactoryImpl bayesModeFactory = new BayesModeFactoryImpl(bayesBeliefSystem);
        ksession.setGlobal("bsFactory", (Object)bayesModeFactory);
        BayesRuntime bayesRuntime = (BayesRuntime)ksession.getKieRuntime(BayesRuntime.class);
        BayesInstance instance = bayesRuntime.createInstance(Garden.class);
        Assert.assertNotNull((Object)instance);
        Assert.assertTrue((boolean)instance.isDecided());
        instance.globalUpdate();
        Garden garden = (Garden)instance.marginalize();
        Assert.assertTrue((boolean)garden.isWetGrass());
        FactHandle fh = ksession.insert((Object)garden);
        FactHandle fh1 = ksession.insert((Object)"rule1");
        ksession.fireAllRules();
        Assert.assertTrue((boolean)instance.isDecided());
        instance.globalUpdate();
        garden = (Garden)instance.marginalize();
        Assert.assertTrue((boolean)garden.isWetGrass());
        FactHandle fh2 = ksession.insert((Object)"rule2");
        ksession.fireAllRules();
        Assert.assertTrue((boolean)instance.isDecided());
        instance.globalUpdate();
        garden = (Garden)instance.marginalize();
        TestCase.assertFalse((boolean)garden.isWetGrass());
        FactHandle fh3 = ksession.insert((Object)"rule3");
        ksession.fireAllRules();
        Assert.assertTrue((boolean)instance.isDecided());
        instance.globalUpdate();
        garden = (Garden)instance.marginalize();
        TestCase.assertFalse((boolean)garden.isWetGrass());
        FactHandle fh4 = ksession.insert((Object)"rule4");
        ksession.fireAllRules();
        TestCase.assertFalse((boolean)instance.isDecided());
        try {
            instance.globalUpdate();
            Assert.fail((String)"The BayesFact is undecided, it should throw an exception, as it cannot be updated.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ksession.delete(fh4);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)instance.isDecided());
        instance.globalUpdate();
        garden = (Garden)instance.marginalize();
        TestCase.assertFalse((boolean)garden.isWetGrass());
        ksession.delete(fh2);
        ksession.fireAllRules();
        instance.globalUpdate();
        garden = (Garden)instance.marginalize();
        TestCase.assertFalse((boolean)garden.isWetGrass());
        ksession.delete(fh3);
        ksession.fireAllRules();
        instance.globalUpdate();
        garden = (Garden)instance.marginalize();
        Assert.assertTrue((boolean)garden.isWetGrass());
    }

    protected StatefulKnowledgeSession getSessionFromString(String drlString) {
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add(ResourceFactory.newByteArrayResource((byte[])drlString.getBytes()), ResourceType.DRL);
        kBuilder.add(ResourceFactory.newClassPathResource((String)"Garden.xmlbif", AssemblerTest.class), ResourceType.BAYES);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
            Assert.fail();
        }
        KnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        kBase.addKnowledgePackages(kBuilder.getKnowledgePackages());
        KieSessionConfiguration ksConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ((SessionConfiguration)ksConf).setBeliefSystemType(BeliefSystemType.DEFEASIBLE);
        StatefulKnowledgeSession kSession = kBase.newStatefulKnowledgeSession(ksConf, null);
        return kSession;
    }

    protected StatefulKnowledgeSession getSession(String ruleFile) {
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add(ResourceFactory.newClassPathResource((String)ruleFile), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
            Assert.fail();
        }
        KnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        kBase.addKnowledgePackages(kBuilder.getKnowledgePackages());
        KieSessionConfiguration ksConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ((SessionConfiguration)ksConf).setBeliefSystemType(BeliefSystemType.DEFEASIBLE);
        StatefulKnowledgeSession kSession = kBase.newStatefulKnowledgeSession(ksConf, null);
        return kSession;
    }
}

