/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.Arrays;
import org.drools.beliefs.bayes.BayesAbsorption;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.GraphTest;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.JunctionTreeTest;
import org.drools.beliefs.bayes.PotentialMultiplier;
import org.drools.beliefs.bayes.SeparatorState;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.junit.Test;

public class BayesAbsorbtionTest {
    @Test
    public void testDivide1() {
        double[] newD = new double[]{10.0, 8.0, 4.0};
        double[] oldD = new double[]{2.0, 4.0, 1.0};
        double[] r = BayesAbsorption.dividePotentials((double[])newD, (double[])oldD);
        JunctionTreeTest.assertArray(new double[]{5.0, 2.0, 4.0}, JunctionTreeTest.scaleDouble(3, r));
    }

    @Test
    public void testDivide2() {
        double[] newD = new double[]{0.5, 1.0, 1.5, 2.0};
        double[] oldD = new double[]{0.1, 0.2, 0.3, 0.4};
        double[] r = BayesAbsorption.dividePotentials((double[])newD, (double[])oldD);
        JunctionTreeTest.assertArray(new double[]{5.0, 5.0, 5.0, 5.0}, JunctionTreeTest.scaleDouble(3, r));
    }

    @Test
    public void testAbsorption1() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, (double[][])null);
        BayesVariable b = new BayesVariable("B", 1, (Object[])new String[]{"B1", "B2"}, (double[][])null);
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        x0.setContent((Object)a);
        x1.setContent((Object)b);
        JunctionTreeClique node1 = new JunctionTreeClique(0, (Graph)graph, GraphTest.bitSet("0011"));
        JunctionTreeClique node2 = new JunctionTreeClique(1, (Graph)graph, GraphTest.bitSet("0011"));
        SeparatorState sep = new JunctionTreeSeparator(0, node1, node2, GraphTest.bitSet("0011"), (Graph)graph).createState();
        BayesVariable[] vars = new BayesVariable[]{a, b};
        BayesVariable[] sepVars = new BayesVariable[]{a, b};
        int[] sepVarPos = PotentialMultiplier.createSubsetVarPos((BayesVariable[])vars, (BayesVariable[])sepVars);
        int sepVarNumberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])sepVars);
        int[] sepVarMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])sepVars, (int)sepVarNumberOfStates);
        double v = 0.44;
        for (int i = 0; i < node1.getPotentials().length; ++i) {
            node1.getPotentials()[i] = v;
            v += 0.4;
        }
        double[] oldSepPotentials = new double[sep.getPotentials().length];
        Arrays.fill(oldSepPotentials, 0.2);
        v = 0.5;
        for (int i = 0; i < sep.getPotentials().length; ++i) {
            sep.getPotentials()[i] = v;
            v += 0.5;
        }
        BayesAbsorption p = new BayesAbsorption(sepVarPos, oldSepPotentials, sep.getPotentials(), sepVarMultipliers, vars, node1.getPotentials());
        p.absorb();
        JunctionTreeTest.assertArray(new double[]{0.035, 0.135, 0.3, 0.529}, JunctionTreeTest.scaleDouble(3, node1.getPotentials()));
    }

    @Test
    public void testAbsorption2() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, (double[][])null);
        BayesVariable b = new BayesVariable("B", 1, (Object[])new String[]{"B1", "B2"}, (double[][])null);
        BayesVariable c = new BayesVariable("C", 2, (Object[])new String[]{"C1", "C2"}, (double[][])null);
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        x0.setContent((Object)a);
        x1.setContent((Object)b);
        x2.setContent((Object)c);
        JunctionTreeClique node1 = new JunctionTreeClique(0, (Graph)graph, GraphTest.bitSet("0111"));
        JunctionTreeClique node2 = new JunctionTreeClique(1, (Graph)graph, GraphTest.bitSet("0011"));
        SeparatorState sep = new JunctionTreeSeparator(0, node1, node2, GraphTest.bitSet("0011"), (Graph)graph).createState();
        BayesVariable[] vars = new BayesVariable[]{a, b, c};
        BayesVariable[] sepVars = new BayesVariable[]{a, b};
        int[] sepVarPos = PotentialMultiplier.createSubsetVarPos((BayesVariable[])vars, (BayesVariable[])sepVars);
        int sepVarNumberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])sepVars);
        int[] sepVarMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])sepVars, (int)sepVarNumberOfStates);
        double v = 0.44;
        for (int i = 0; i < node1.getPotentials().length; ++i) {
            node1.getPotentials()[i] = v;
            v += 0.4;
        }
        double[] oldSepPotentials = new double[sep.getPotentials().length];
        Arrays.fill(oldSepPotentials, 0.2);
        v = 0.5;
        for (int i = 0; i < sep.getPotentials().length; ++i) {
            sep.getPotentials()[i] = v;
            v += 0.5;
        }
        BayesAbsorption p = new BayesAbsorption(sepVarPos, oldSepPotentials, sep.getPotentials(), sepVarMultipliers, vars, node1.getPotentials());
        p.absorb();
        JunctionTreeTest.assertArray(new double[]{0.01, 0.019, 0.055, 0.073, 0.137, 0.163, 0.254, 0.289}, JunctionTreeTest.scaleDouble(3, node1.getPotentials()));
    }

    @Test
    public void testAbsorption3() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, (double[][])null);
        BayesVariable b = new BayesVariable("B", 1, (Object[])new String[]{"B1", "B2"}, (double[][])null);
        BayesVariable c = new BayesVariable("C", 2, (Object[])new String[]{"C1", "C2"}, (double[][])null);
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        x0.setContent((Object)a);
        x1.setContent((Object)b);
        x2.setContent((Object)c);
        JunctionTreeClique node1 = new JunctionTreeClique(0, (Graph)graph, GraphTest.bitSet("0111"));
        JunctionTreeClique node2 = new JunctionTreeClique(1, (Graph)graph, GraphTest.bitSet("0101"));
        SeparatorState sep = new JunctionTreeSeparator(0, node1, node2, GraphTest.bitSet("0101"), (Graph)graph).createState();
        BayesVariable[] vars = new BayesVariable[]{a, b, c};
        BayesVariable[] sepVars = new BayesVariable[]{a, c};
        int[] sepVarPos = PotentialMultiplier.createSubsetVarPos((BayesVariable[])vars, (BayesVariable[])sepVars);
        int sepVarNumberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])sepVars);
        int[] sepVarMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])sepVars, (int)sepVarNumberOfStates);
        double v = 0.44;
        for (int i = 0; i < node1.getPotentials().length; ++i) {
            node1.getPotentials()[i] = v;
            v += 0.4;
        }
        double[] oldSepPotentials = new double[sep.getPotentials().length];
        Arrays.fill(oldSepPotentials, 0.2);
        v = 0.5;
        for (int i = 0; i < sep.getPotentials().length; ++i) {
            sep.getPotentials()[i] = v;
            v += 0.5;
        }
        BayesAbsorption p = new BayesAbsorption(sepVarPos, oldSepPotentials, sep.getPotentials(), sepVarMultipliers, vars, node1.getPotentials());
        p.absorb();
        JunctionTreeTest.assertArray(new double[]{0.01, 0.038, 0.028, 0.075, 0.139, 0.222, 0.194, 0.295}, JunctionTreeTest.scaleDouble(3, node1.getPotentials()));
    }
}

