/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes.integration;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.model.Bif;
import org.drools.beliefs.bayes.model.Definition;
import org.drools.beliefs.bayes.model.Network;
import org.drools.beliefs.bayes.model.Variable;
import org.drools.beliefs.bayes.model.XmlBifParser;
import org.drools.beliefs.graph.GraphNode;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    @Test
    public void testSprinklerLoadBif() {
        Bif bif = XmlBifParser.loadBif((URL)ParserTest.class.getResource("Garden.xmlbif"));
        Network network = bif.getNetwork();
        junit.framework.Assert.assertEquals((String)"Garden", (String)network.getName());
        junit.framework.Assert.assertEquals((String)"package = org.drools.beliefs.bayes.integration", (String)((String)network.getProperties().get(0)));
        Map<String, Variable> varMap = this.varToMap(network.getVariables());
        junit.framework.Assert.assertEquals((int)4, (int)varMap.size());
        Variable var = varMap.get("WetGrass");
        junit.framework.Assert.assertEquals((String)"WetGrass", (String)var.getName());
        junit.framework.Assert.assertEquals((int)2, (int)var.getOutComes().size());
        junit.framework.Assert.assertEquals((Object)var.getOutComes(), Arrays.asList("false", "true"));
        junit.framework.Assert.assertEquals((String)"position = (0,10)", (String)((String)var.getProperties().get(0)));
        var = varMap.get("Cloudy");
        junit.framework.Assert.assertEquals((String)"Cloudy", (String)var.getName());
        junit.framework.Assert.assertEquals((int)2, (int)var.getOutComes().size());
        junit.framework.Assert.assertEquals((Object)var.getOutComes(), Arrays.asList("false", "true"));
        junit.framework.Assert.assertEquals((String)"position = (0,-10)", (String)((String)var.getProperties().get(0)));
        var = varMap.get("Sprinkler");
        junit.framework.Assert.assertEquals((String)"Sprinkler", (String)var.getName());
        junit.framework.Assert.assertEquals((int)2, (int)var.getOutComes().size());
        junit.framework.Assert.assertEquals((Object)var.getOutComes(), Arrays.asList("false", "true"));
        junit.framework.Assert.assertEquals((String)"position = (13,0)", (String)((String)var.getProperties().get(0)));
        var = varMap.get("Rain");
        junit.framework.Assert.assertEquals((String)"Rain", (String)var.getName());
        junit.framework.Assert.assertEquals((int)2, (int)var.getOutComes().size());
        junit.framework.Assert.assertEquals((Object)var.getOutComes(), Arrays.asList("false", "true"));
        junit.framework.Assert.assertEquals((String)"position = (-12,0)", (String)((String)var.getProperties().get(0)));
        Map<String, Definition> defMap = this.defToMap(network.getDefinitions());
        junit.framework.Assert.assertEquals((int)4, (int)defMap.size());
        Definition def = defMap.get("WetGrass");
        junit.framework.Assert.assertEquals((String)"WetGrass", (String)def.getName());
        junit.framework.Assert.assertEquals((int)2, (int)def.getGiven().size());
        junit.framework.Assert.assertEquals((Object)def.getGiven(), Arrays.asList("Sprinkler", "Rain"));
        junit.framework.Assert.assertEquals((String)"1.0 0.0 0.1 0.9 0.1 0.9 0.01 0.99", (String)def.getProbabilities());
        def = defMap.get("Cloudy");
        junit.framework.Assert.assertEquals((String)"Cloudy", (String)def.getName());
        Assert.assertNull((Object)def.getGiven());
        junit.framework.Assert.assertEquals((String)"0.5 0.5", (String)def.getProbabilities().trim());
        def = defMap.get("Sprinkler");
        junit.framework.Assert.assertEquals((String)"Sprinkler", (String)def.getName());
        junit.framework.Assert.assertEquals((int)1, (int)def.getGiven().size());
        junit.framework.Assert.assertEquals((String)"Cloudy", (String)((String)def.getGiven().get(0)));
        junit.framework.Assert.assertEquals((String)"0.5 0.5 0.9 0.1", (String)def.getProbabilities().trim());
        def = defMap.get("Rain");
        junit.framework.Assert.assertEquals((String)"Rain", (String)def.getName());
        Assert.assertNull((Object)def.getGiven());
        junit.framework.Assert.assertEquals((String)"0.5 0.5", (String)def.getProbabilities().trim());
    }

    @Test
    public void testSprinklerBuildBayesNework() {
        Bif bif = XmlBifParser.loadBif((URL)ParserTest.class.getResource("Garden.xmlbif"));
        BayesNetwork network = XmlBifParser.buildBayesNetwork((Bif)bif);
        Map<String, GraphNode<BayesVariable>> map = this.nodeToMap(network);
        GraphNode<BayesVariable> node = map.get("WetGrass");
        BayesVariable wetGrass = (BayesVariable)node.getContent();
        junit.framework.Assert.assertEquals(Arrays.asList("false", "true"), Arrays.asList(wetGrass.getOutcomes()));
        junit.framework.Assert.assertEquals((int)2, (int)wetGrass.getGiven().length);
        junit.framework.Assert.assertEquals(Arrays.asList(wetGrass.getGiven()), Arrays.asList("Sprinkler", "Rain"));
        junit.framework.Assert.assertTrue((boolean)Arrays.deepEquals((Object[])new double[][]{{1.0, 0.0}, {0.1, 0.9}, {0.1, 0.9}, {0.01, 0.99}}, (Object[])wetGrass.getProbabilityTable()));
        node = map.get("Sprinkler");
        BayesVariable sprinkler = (BayesVariable)node.getContent();
        junit.framework.Assert.assertEquals(Arrays.asList("false", "true"), Arrays.asList(sprinkler.getOutcomes()));
        junit.framework.Assert.assertEquals((int)1, (int)sprinkler.getGiven().length);
        junit.framework.Assert.assertEquals((String)"Cloudy", (String)sprinkler.getGiven()[0]);
        junit.framework.Assert.assertTrue((boolean)Arrays.deepEquals((Object[])new double[][]{{0.5, 0.5}, {0.9, 0.1}}, (Object[])sprinkler.getProbabilityTable()));
        node = map.get("Cloudy");
        BayesVariable cloudy = (BayesVariable)node.getContent();
        junit.framework.Assert.assertEquals(Arrays.asList("false", "true"), Arrays.asList(cloudy.getOutcomes()));
        junit.framework.Assert.assertEquals((int)0, (int)cloudy.getGiven().length);
        junit.framework.Assert.assertTrue((boolean)Arrays.deepEquals((Object[])new double[][]{{0.5, 0.5}}, (Object[])cloudy.getProbabilityTable()));
        node = map.get("Rain");
        BayesVariable rain = (BayesVariable)node.getContent();
        junit.framework.Assert.assertEquals(Arrays.asList("false", "true"), Arrays.asList(rain.getOutcomes()));
        junit.framework.Assert.assertEquals((int)0, (int)rain.getGiven().length);
        junit.framework.Assert.assertTrue((boolean)Arrays.deepEquals((Object[])new double[][]{{0.5, 0.5}}, (Object[])rain.getProbabilityTable()));
    }

    Map<String, GraphNode<BayesVariable>> nodeToMap(BayesNetwork network) {
        HashMap<String, GraphNode<BayesVariable>> map = new HashMap<String, GraphNode<BayesVariable>>();
        for (GraphNode node : network) {
            map.put(((BayesVariable)node.getContent()).getName(), (GraphNode<BayesVariable>)node);
        }
        return map;
    }

    public Map<String, Variable> varToMap(List<Variable> list) {
        HashMap<String, Variable> map = new HashMap<String, Variable>();
        for (Variable var : list) {
            map.put(var.getName(), var);
        }
        return map;
    }

    public Map<String, Definition> defToMap(List<Definition> list) {
        HashMap<String, Definition> map = new HashMap<String, Definition>();
        for (Definition def : list) {
            map.put(def.getName(), def);
        }
        return map;
    }
}

