/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.EliminationCandidate;
import org.drools.beliefs.bayes.GraphTest;
import org.drools.beliefs.bayes.JunctionTreeBuilder;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.SeparatorSet;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.drools.core.util.bitmask.OpenBitSet;
import org.junit.Assert;
import org.junit.Test;

public class JunctionTreeBuilderTest {
    @Test
    public void testOpenBitSet() {
        OpenBitSet b1 = GraphTest.bitSet("00000111");
        OpenBitSet b2 = GraphTest.bitSet("00000111");
        OpenBitSet b3 = GraphTest.bitSet("00000110");
        OpenBitSet b4 = GraphTest.bitSet("00001110");
        Assert.assertEquals((long)0L, (long)OpenBitSet.andNotCount((OpenBitSet)b1, (OpenBitSet)b2));
        Assert.assertEquals((long)1L, (long)OpenBitSet.andNotCount((OpenBitSet)b2, (OpenBitSet)b3));
        Assert.assertEquals((long)0L, (long)OpenBitSet.andNotCount((OpenBitSet)b3, (OpenBitSet)b2));
        Assert.assertEquals((long)1L, (long)OpenBitSet.andNotCount((OpenBitSet)b2, (OpenBitSet)b4));
        Assert.assertEquals((long)1L, (long)OpenBitSet.andNotCount((OpenBitSet)b4, (OpenBitSet)b2));
    }

    @Test
    public void testMoralize1() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x2, x1);
        GraphTest.connectParentToChildren(x3, x1);
        GraphTest.connectParentToChildren(x4, x1);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        GraphTest.assertLinkedNode(jtBuilder, 1, 2, 3, 4);
        GraphTest.assertLinkedNode(jtBuilder, 2, 1);
        GraphTest.assertLinkedNode(jtBuilder, 3, 1);
        GraphTest.assertLinkedNode(jtBuilder, 4, 1);
        jtBuilder.moralize();
        GraphTest.assertLinkedNode(jtBuilder, 1, 2, 3, 4);
        GraphTest.assertLinkedNode(jtBuilder, 2, 1, 3, 4);
        GraphTest.assertLinkedNode(jtBuilder, 3, 1, 2, 4);
        GraphTest.assertLinkedNode(jtBuilder, 4, 1, 2, 3);
    }

    @Test
    public void testMoralize2() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2, x3);
        GraphTest.connectParentToChildren(x2, x4);
        GraphTest.connectParentToChildren(x4, x5);
        GraphTest.connectParentToChildren(x3, x5);
        GraphTest.connectParentToChildren(x6, x5);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        jtBuilder.moralize();
        GraphTest.assertLinkedNode(jtBuilder, x1.getId(), 2, 3);
        GraphTest.assertLinkedNode(jtBuilder, x2.getId(), 1, 4);
        GraphTest.assertLinkedNode(jtBuilder, x3.getId(), 1, 4, 5, 6);
        GraphTest.assertLinkedNode(jtBuilder, x4.getId(), 2, 3, 5, 6);
        GraphTest.assertLinkedNode(jtBuilder, x5.getId(), 3, 4, 6);
        GraphTest.assertLinkedNode(jtBuilder, x6.getId(), 3, 4, 5);
    }

    @Test
    public void testEliminationCandidate1() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2, x3, x4);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        jtBuilder.moralize();
        EliminationCandidate vt1 = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x1);
        Assert.assertEquals((long)3L, (long)vt1.getNewEdgesRequired());
        Assert.assertEquals((Object)GraphTest.bitSet("11110"), (Object)vt1.getCliqueBitSit());
    }

    @Test
    public void testEliminationCandidate2() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2, x3, x4);
        GraphTest.connectParentToChildren(x3, x4);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        jtBuilder.moralize();
        EliminationCandidate vt1 = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x1);
        Assert.assertEquals((long)2L, (long)vt1.getNewEdgesRequired());
        Assert.assertEquals((Object)GraphTest.bitSet("11110"), (Object)vt1.getCliqueBitSit());
    }

    @Test
    public void testCreateClique() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> dX0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> dX1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> dX2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> dX3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> dX4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> dX5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(dX1, dX2, dX3, dX4);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        HashSet vertices = new HashSet();
        boolean[] adjList = new boolean[]{false, false, true, true, true, false};
        boolean[][] clonedAdjMatrix = JunctionTreeBuilder.cloneAdjacencyMarix((boolean[][])jtBuilder.getAdjacencyMatrix());
        jtBuilder.createClique(dX1.getId(), clonedAdjMatrix, vertices, adjList);
        Assert.assertEquals((long)3L, (long)vertices.size());
        Assert.assertTrue((boolean)vertices.containsAll(Arrays.asList(2, 3, 4)));
        GraphTest.assertLinkedNode(jtBuilder, 1, 2, 3, 4);
        GraphTest.assertLinkedNode(jtBuilder, 2, 1, 3, 4);
        GraphTest.assertLinkedNode(jtBuilder, 3, 1, 2, 4);
        GraphTest.assertLinkedNode(jtBuilder, 4, 1, 2, 3);
    }

    @Test
    public void testCliqueSuperSet() {
        BayesNetwork graph = new BayesNetwork();
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        ArrayList cliques = new ArrayList();
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00011110");
        JunctionTreeBuilder.updateCliques(cliques, (OpenBitSet)OpenBitSet1);
        Assert.assertEquals((long)1L, (long)cliques.size());
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00000110");
        JunctionTreeBuilder.updateCliques(cliques, (OpenBitSet)OpenBitSet2);
        Assert.assertEquals((long)1L, (long)cliques.size());
        Assert.assertEquals((Object)OpenBitSet1, cliques.get(0));
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("01000110");
        JunctionTreeBuilder.updateCliques(cliques, (OpenBitSet)OpenBitSet3);
        Assert.assertEquals((long)2L, (long)cliques.size());
        Assert.assertEquals((Object)OpenBitSet1, cliques.get(0));
        Assert.assertEquals((Object)OpenBitSet3, cliques.get(1));
    }

    @Test
    public void testPriorityQueueWithMinimalNewEdges() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x8 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x9 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x10 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x11 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x12 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x2, x1);
        GraphTest.connectParentToChildren(x3, x1);
        GraphTest.connectParentToChildren(x4, x1);
        GraphTest.connectParentToChildren(x6, x5);
        GraphTest.connectParentToChildren(x7, x5);
        x5.setContent((Object)new BayesVariable("x5", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        x6.setContent((Object)new BayesVariable("x6", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        x7.setContent((Object)new BayesVariable("x7", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        GraphTest.connectParentToChildren(x9, x8);
        GraphTest.connectParentToChildren(x10, x8);
        GraphTest.connectParentToChildren(x11, x8);
        GraphTest.connectParentToChildren(x12, x8);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        PriorityQueue<EliminationCandidate> p = new PriorityQueue<EliminationCandidate>(graph.size());
        EliminationCandidate elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x1);
        p.add(elmCandVert);
        elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x5);
        p.add(elmCandVert);
        elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x8);
        p.add(elmCandVert);
        EliminationCandidate v = (EliminationCandidate)p.remove();
        int id = v.getV().getId();
        Assert.assertEquals((long)5L, (long)id);
        Assert.assertEquals((long)1L, (long)v.getNewEdgesRequired());
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assert.assertEquals((long)1L, (long)id);
        Assert.assertEquals((long)3L, (long)v.getNewEdgesRequired());
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assert.assertEquals((long)8L, (long)id);
        Assert.assertEquals((long)6L, (long)v.getNewEdgesRequired());
        Assert.assertEquals((long)0L, (long)p.size());
    }

    @Test
    public void testPriorityQueueWithMaximalCliqueWeight() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x8 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x9 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x10 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x11 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x12 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x2, x1);
        GraphTest.connectParentToChildren(x3, x1);
        GraphTest.connectParentToChildren(x4, x1);
        x1.setContent((Object)new BayesVariable("x1", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x2.setContent((Object)new BayesVariable("x2", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x3.setContent((Object)new BayesVariable("x3", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x4.setContent((Object)new BayesVariable("x4", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        GraphTest.connectParentToChildren(x6, x5);
        GraphTest.connectParentToChildren(x7, x5);
        GraphTest.connectParentToChildren(x8, x5);
        x5.setContent((Object)new BayesVariable("x5", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        x6.setContent((Object)new BayesVariable("x6", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        x7.setContent((Object)new BayesVariable("x7", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        x8.setContent((Object)new BayesVariable("x8", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        GraphTest.connectParentToChildren(x10, x9);
        GraphTest.connectParentToChildren(x11, x9);
        GraphTest.connectParentToChildren(x12, x9);
        x9.setContent((Object)new BayesVariable("x9", x0.getId(), (Object[])new String[]{"a"}, (double[][])new double[][]{{0.1}}));
        x10.setContent((Object)new BayesVariable("x10", x0.getId(), (Object[])new String[]{"a"}, (double[][])new double[][]{{0.1}}));
        x11.setContent((Object)new BayesVariable("x11", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x12.setContent((Object)new BayesVariable("x12", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        PriorityQueue<EliminationCandidate> p = new PriorityQueue<EliminationCandidate>(graph.size());
        EliminationCandidate elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x1);
        p.add(elmCandVert);
        elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x5);
        p.add(elmCandVert);
        elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x9);
        p.add(elmCandVert);
        EliminationCandidate v = (EliminationCandidate)p.remove();
        int id = v.getV().getId();
        Assert.assertEquals((long)9L, (long)id);
        Assert.assertEquals((long)4L, (long)v.getWeightRequired());
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assert.assertEquals((long)1L, (long)id);
        Assert.assertEquals((long)16L, (long)v.getWeightRequired());
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assert.assertEquals((long)5L, (long)id);
        Assert.assertEquals((long)81L, (long)v.getWeightRequired());
        Assert.assertEquals((long)0L, (long)p.size());
    }

    @Test
    public void testIterativeEliminationUsingEdgeAndWeight() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2);
        GraphTest.connectParentToChildren(x1, x3);
        GraphTest.connectParentToChildren(x1, x6);
        GraphTest.connectParentToChildren(x2, x4);
        GraphTest.connectParentToChildren(x3, x5);
        GraphTest.connectParentToChildren(x4, x6);
        GraphTest.connectParentToChildren(x5, x6);
        x1.setContent((Object)new BayesVariable("x1", x0.getId(), (Object[])new String[]{"a", "b", "c", "d", "e", "f"}, (double[][])new double[][]{{0.1, 0.1, 0.1, 0.1, 0.1, 0.1}}));
        x2.setContent((Object)new BayesVariable("x2", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x3.setContent((Object)new BayesVariable("x3", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x4.setContent((Object)new BayesVariable("x4", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x5.setContent((Object)new BayesVariable("x5", x0.getId(), (Object[])new String[]{"a"}, (double[][])new double[][]{{0.1}}));
        x6.setContent((Object)new BayesVariable("x6", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        boolean[][] clonedAdjMatrix = JunctionTreeBuilder.cloneAdjacencyMarix((boolean[][])jtBuilder.getAdjacencyMatrix());
        PriorityQueue<EliminationCandidate> p = new PriorityQueue<EliminationCandidate>(graph.size());
        HashMap<Integer, EliminationCandidate> elmVertMap = new HashMap<Integer, EliminationCandidate>();
        for (GraphNode v : graph) {
            if (v.getId() == 0) continue;
            EliminationCandidate elmCandVert = new EliminationCandidate((Graph)graph, clonedAdjMatrix, v);
            p.add(elmCandVert);
            elmVertMap.put(v.getId(), elmCandVert);
        }
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 1, 2, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 2, 1, 4);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 3, 1, 5);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 4, 2, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 5, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 6, 1, 4, 5);
        Assert.assertEquals((long)3L, (long)((EliminationCandidate)elmVertMap.get(1)).getNewEdgesRequired());
        Assert.assertEquals((long)1L, (long)((EliminationCandidate)elmVertMap.get(2)).getNewEdgesRequired());
        Assert.assertEquals((long)1L, (long)((EliminationCandidate)elmVertMap.get(3)).getNewEdgesRequired());
        Assert.assertEquals((long)1L, (long)((EliminationCandidate)elmVertMap.get(4)).getNewEdgesRequired());
        Assert.assertEquals((long)1L, (long)((EliminationCandidate)elmVertMap.get(5)).getNewEdgesRequired());
        Assert.assertEquals((long)3L, (long)((EliminationCandidate)elmVertMap.get(6)).getNewEdgesRequired());
        EliminationCandidate v = (EliminationCandidate)p.remove();
        int id = v.getV().getId();
        Assert.assertEquals((long)5L, (long)id);
        HashSet verticesToUpdate = new HashSet();
        boolean[] adjList = clonedAdjMatrix[id];
        jtBuilder.createClique(5, clonedAdjMatrix, verticesToUpdate, adjList);
        Assert.assertEquals((long)4L, (long)verticesToUpdate.size());
        Assert.assertTrue((boolean)verticesToUpdate.containsAll(Arrays.asList(1, 3, 6)));
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 1, 2, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 2, 1, 4);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 3, 1, 5, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 4, 2, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 5, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 6, 1, 3, 4, 5);
        Assert.assertEquals((long)2L, (long)((EliminationCandidate)elmVertMap.get(1)).getNewEdgesRequired());
        Assert.assertEquals((long)1L, (long)((EliminationCandidate)elmVertMap.get(2)).getNewEdgesRequired());
        Assert.assertEquals((long)0L, (long)((EliminationCandidate)elmVertMap.get(3)).getNewEdgesRequired());
        Assert.assertEquals((long)2L, (long)((EliminationCandidate)elmVertMap.get(6)).getNewEdgesRequired());
        Assert.assertEquals((long)1L, (long)((EliminationCandidate)elmVertMap.get(4)).getNewEdgesRequired());
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assert.assertEquals((long)3L, (long)id);
        verticesToUpdate = new HashSet();
        jtBuilder.createClique(3, clonedAdjMatrix, verticesToUpdate, adjList);
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assert.assertEquals((long)4L, (long)id);
        verticesToUpdate = new HashSet();
        adjList = clonedAdjMatrix[id];
        jtBuilder.createClique(4, clonedAdjMatrix, verticesToUpdate, adjList);
        Assert.assertEquals((long)3L, (long)verticesToUpdate.size());
        Assert.assertTrue((boolean)verticesToUpdate.containsAll(Arrays.asList(1, 2, 6)));
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 1, 2, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 2, 1, 4, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 3, 1, 5, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 4, 2, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 5, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 6, 1, 2, 3, 4, 5);
        Assert.assertEquals((long)0L, (long)((EliminationCandidate)elmVertMap.get(1)).getNewEdgesRequired());
        Assert.assertEquals((long)0L, (long)((EliminationCandidate)elmVertMap.get(2)).getNewEdgesRequired());
        Assert.assertEquals((long)0L, (long)((EliminationCandidate)elmVertMap.get(6)).getNewEdgesRequired());
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assert.assertEquals((long)1L, (long)id);
        verticesToUpdate = new HashSet();
        jtBuilder.createClique(1, clonedAdjMatrix, verticesToUpdate, adjList);
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assert.assertEquals((long)2L, (long)id);
        verticesToUpdate = new HashSet();
        jtBuilder.createClique(2, clonedAdjMatrix, verticesToUpdate, adjList);
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assert.assertEquals((long)6L, (long)id);
        verticesToUpdate = new HashSet();
        jtBuilder.createClique(6, clonedAdjMatrix, verticesToUpdate, adjList);
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        Assert.assertEquals((long)0L, (long)p.size());
    }

    @Test
    public void testTriangulate1() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2);
        GraphTest.connectParentToChildren(x1, x3);
        GraphTest.connectParentToChildren(x1, x6);
        GraphTest.connectParentToChildren(x2, x4);
        GraphTest.connectParentToChildren(x3, x5);
        GraphTest.connectParentToChildren(x4, x6);
        GraphTest.connectParentToChildren(x5, x6);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        jtBuilder.moralize();
        jtBuilder.triangulate();
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 1, 2, 3, 4, 5, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 2, 1, 4);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 3, 1, 5);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 4, 1, 2, 5, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 5, 1, 3, 4, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 6, 1, 4, 5);
    }

    @Test
    public void testTriangulate2() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2);
        GraphTest.connectParentToChildren(x1, x3);
        GraphTest.connectParentToChildren(x2, x4);
        GraphTest.connectParentToChildren(x2, x6);
        GraphTest.connectParentToChildren(x3, x5);
        GraphTest.connectParentToChildren(x5, x6);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        jtBuilder.moralize();
        List cliques = jtBuilder.triangulate();
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 1, 2, 3);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 2, 1, 3, 4, 5, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 3, 1, 2, 5);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 4, 2);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 5, 2, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 6, 2, 5);
        Assert.assertEquals((long)5L, (long)cliques.size());
        Assert.assertTrue((boolean)cliques.contains(GraphTest.bitSet("1110")));
        Assert.assertTrue((boolean)cliques.contains(GraphTest.bitSet("10100")));
        Assert.assertTrue((boolean)cliques.contains(GraphTest.bitSet("1100100")));
        Assert.assertTrue((boolean)cliques.contains(GraphTest.bitSet("101100")));
    }

    @Test
    public void testSepSetCompareWithDifferentMass() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        OpenBitSet OpenBitSet1_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet1_2 = GraphTest.bitSet("01101100");
        SeparatorSet s1 = new SeparatorSet(OpenBitSet1_1, 0, OpenBitSet1_2, 0, (Graph)graph);
        OpenBitSet OpenBitSet2_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet2_2 = GraphTest.bitSet("00100100");
        SeparatorSet s2 = new SeparatorSet(OpenBitSet2_1, 0, OpenBitSet2_2, 0, (Graph)graph);
        ArrayList<SeparatorSet> list = new ArrayList<SeparatorSet>();
        list.add(s1);
        list.add(s2);
        Collections.sort(list);
        Assert.assertEquals((Object)s1, list.get(0));
    }

    @Test
    public void testSepSetCompareWithDifferentCost() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        x1.setContent((Object)new BayesVariable("x1", x0.getId(), (Object[])new String[]{"a"}, (double[][])new double[][]{{0.1}}));
        x2.setContent((Object)new BayesVariable("x2", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x3.setContent((Object)new BayesVariable("x3", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        OpenBitSet OpenBitSet1_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet1_2 = GraphTest.bitSet("01101100");
        SeparatorSet s1 = new SeparatorSet(OpenBitSet1_1, 0, OpenBitSet1_2, 0, (Graph)graph);
        OpenBitSet OpenBitSet2_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet2_2 = GraphTest.bitSet("00100110");
        SeparatorSet s2 = new SeparatorSet(OpenBitSet2_1, 0, OpenBitSet2_2, 0, (Graph)graph);
        ArrayList<SeparatorSet> list = new ArrayList<SeparatorSet>();
        list.add(s1);
        list.add(s2);
        Collections.sort(list);
        Assert.assertEquals((Object)s1, list.get(0));
        x1.setContent((Object)new BayesVariable("x3", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x2.setContent((Object)new BayesVariable("x2", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x3.setContent((Object)new BayesVariable("x1", x0.getId(), (Object[])new String[]{"a"}, (double[][])new double[][]{{0.1}}));
        s1 = new SeparatorSet(OpenBitSet1_1, 0, OpenBitSet1_2, 0, (Graph)graph);
        s2 = new SeparatorSet(OpenBitSet2_1, 0, OpenBitSet2_2, 0, (Graph)graph);
        list = new ArrayList();
        list.add(s1);
        list.add(s2);
        Collections.sort(list);
        Assert.assertEquals((Object)s2, list.get(0));
    }

    @Test
    public void testSepSetCompareWithSameIntersect() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        OpenBitSet OpenBitSet1_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet1_2 = GraphTest.bitSet("01000010");
        SeparatorSet s1 = new SeparatorSet(OpenBitSet1_1, 0, OpenBitSet1_2, 0, (Graph)graph);
        OpenBitSet OpenBitSet2_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet2_2 = GraphTest.bitSet("01000100");
        SeparatorSet s2 = new SeparatorSet(OpenBitSet2_1, 0, OpenBitSet2_2, 0, (Graph)graph);
        ArrayList<SeparatorSet> list = new ArrayList<SeparatorSet>();
        list.add(s1);
        list.add(s2);
        Collections.sort(list);
        Assert.assertEquals((Object)s1, list.get(0));
        OpenBitSet1_2 = GraphTest.bitSet("01000100");
        s1 = new SeparatorSet(OpenBitSet1_1, 0, OpenBitSet1_2, 0, (Graph)graph);
        OpenBitSet2_2 = GraphTest.bitSet("01000010");
        s2 = new SeparatorSet(OpenBitSet2_1, 0, OpenBitSet2_2, 0, (Graph)graph);
        list = new ArrayList();
        list.add(s1);
        list.add(s2);
        Collections.sort(list);
        Assert.assertEquals((Object)s2, list.get(0));
    }

    @Test
    public void testJunctionTree() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00011100");
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("00110000");
        OpenBitSet OpenBitSet4 = GraphTest.bitSet("01110000");
        ArrayList<OpenBitSet> cliques = new ArrayList<OpenBitSet>();
        cliques.add(OpenBitSet1);
        cliques.add(OpenBitSet2);
        cliques.add(OpenBitSet3);
        cliques.add(OpenBitSet4);
        ArrayList separatorSets = new ArrayList();
        for (int i = 0; i < cliques.size(); ++i) {
            OpenBitSet ci = (OpenBitSet)cliques.get(i);
            for (int j = i + 1; j < cliques.size(); ++j) {
                OpenBitSet cj = (OpenBitSet)cliques.get(j);
                if (!ci.intersects(cj)) continue;
                SeparatorSet separatorSet = new SeparatorSet(ci, 0, cj, 0, (Graph)graph);
            }
        }
        Collections.sort(separatorSets);
    }

    @Test
    public void testJunctionTreeNoPruning() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        ArrayList<OpenBitSet> list = new ArrayList<OpenBitSet>();
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00001111");
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00111100");
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("11100000");
        OpenBitSet intersect1And2 = OpenBitSet2.clone();
        intersect1And2.and(OpenBitSet1);
        OpenBitSet intersect2And3 = OpenBitSet2.clone();
        intersect2And3.and(OpenBitSet3);
        list.add(OpenBitSet1);
        list.add(OpenBitSet2);
        list.add(OpenBitSet3);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique jtNode = jtBuilder.junctionTree(list, false).getRoot();
        Assert.assertEquals((Object)OpenBitSet1, (Object)jtNode.getBitSet());
        Assert.assertEquals((long)1L, (long)jtNode.getChildren().size());
        JunctionTreeSeparator sep = (JunctionTreeSeparator)jtNode.getChildren().get(0);
        Assert.assertEquals((Object)OpenBitSet1, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)OpenBitSet2, (Object)sep.getChild().getBitSet());
        Assert.assertEquals((Object)intersect1And2, (Object)sep.getBitSet());
        jtNode = sep.getChild();
        Assert.assertEquals((Object)OpenBitSet2, (Object)jtNode.getBitSet());
        Assert.assertEquals((long)1L, (long)jtNode.getChildren().size());
        sep = (JunctionTreeSeparator)jtNode.getChildren().get(0);
        Assert.assertEquals((Object)OpenBitSet2, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)OpenBitSet3, (Object)sep.getChild().getBitSet());
        Assert.assertEquals((Object)intersect2And3, (Object)sep.getBitSet());
    }

    @Test
    public void testJunctionWithPruning1() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        ArrayList<OpenBitSet> list = new ArrayList<OpenBitSet>();
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00001111");
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00111100");
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("11100001");
        OpenBitSet intersect1And2 = OpenBitSet2.clone();
        intersect1And2.and(OpenBitSet1);
        OpenBitSet intersect2And3 = OpenBitSet2.clone();
        intersect2And3.and(OpenBitSet3);
        list.add(OpenBitSet1);
        list.add(OpenBitSet2);
        list.add(OpenBitSet3);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique jtNode = jtBuilder.junctionTree(list, false).getRoot();
        Assert.assertEquals((Object)OpenBitSet1, (Object)jtNode.getBitSet());
        Assert.assertEquals((long)2L, (long)jtNode.getChildren().size());
        JunctionTreeSeparator sep = (JunctionTreeSeparator)jtNode.getChildren().get(0);
        Assert.assertEquals((Object)OpenBitSet1, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)OpenBitSet2, (Object)sep.getChild().getBitSet());
        Assert.assertEquals((long)0L, (long)sep.getChild().getChildren().size());
        sep = (JunctionTreeSeparator)jtNode.getChildren().get(1);
        Assert.assertEquals((Object)OpenBitSet1, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)OpenBitSet3, (Object)sep.getChild().getBitSet());
        Assert.assertEquals((long)0L, (long)sep.getChild().getChildren().size());
    }

    @Test
    public void testJunctionWithPruning2() {
        JunctionTreeClique jtNode;
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        ArrayList<OpenBitSet> list = new ArrayList<OpenBitSet>();
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00001111");
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00111100");
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("11100000");
        OpenBitSet OpenBitSet4 = GraphTest.bitSet("00100001");
        OpenBitSet intersect1And2 = OpenBitSet2.clone();
        intersect1And2.and(OpenBitSet1);
        OpenBitSet intersect2And3 = OpenBitSet2.clone();
        intersect2And3.and(OpenBitSet3);
        OpenBitSet intersect1And4 = OpenBitSet1.clone();
        intersect1And4.and(OpenBitSet4);
        list.add(OpenBitSet1);
        list.add(OpenBitSet2);
        list.add(OpenBitSet3);
        list.add(OpenBitSet4);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique root = jtNode = jtBuilder.junctionTree(list, false).getRoot();
        Assert.assertEquals((Object)OpenBitSet1, (Object)root.getBitSet());
        Assert.assertEquals((long)2L, (long)root.getChildren().size());
        JunctionTreeSeparator sep = (JunctionTreeSeparator)root.getChildren().get(0);
        Assert.assertEquals((Object)OpenBitSet1, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)OpenBitSet2, (Object)sep.getChild().getBitSet());
        Assert.assertEquals((long)1L, (long)sep.getChild().getChildren().size());
        jtNode = sep.getChild();
        Assert.assertEquals((Object)OpenBitSet2, (Object)jtNode.getBitSet());
        Assert.assertEquals((long)1L, (long)jtNode.getChildren().size());
        sep = (JunctionTreeSeparator)jtNode.getChildren().get(0);
        Assert.assertEquals((Object)OpenBitSet2, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)OpenBitSet3, (Object)sep.getChild().getBitSet());
        Assert.assertEquals((Object)intersect2And3, (Object)sep.getBitSet());
        Assert.assertEquals((long)0L, (long)sep.getChild().getChildren().size());
        sep = (JunctionTreeSeparator)root.getChildren().get(1);
        Assert.assertEquals((Object)OpenBitSet1, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)OpenBitSet4, (Object)sep.getChild().getBitSet());
        Assert.assertEquals((Object)intersect1And4, (Object)sep.getBitSet());
        Assert.assertEquals((long)0L, (long)sep.getChild().getChildren().size());
    }

    @Test
    public void testJunctionWithPruning3() {
        JunctionTreeClique jtNode;
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        ArrayList<OpenBitSet> list = new ArrayList<OpenBitSet>();
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00001111");
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00011110");
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("11100000");
        OpenBitSet OpenBitSet4 = GraphTest.bitSet("01100001");
        OpenBitSet intersect1And2 = OpenBitSet2.clone();
        intersect1And2.and(OpenBitSet1);
        OpenBitSet intersect2And3 = OpenBitSet2.clone();
        intersect2And3.and(OpenBitSet3);
        OpenBitSet intersect1And4 = OpenBitSet1.clone();
        intersect1And4.and(OpenBitSet4);
        OpenBitSet intersect3And4 = OpenBitSet3.clone();
        intersect3And4.and(OpenBitSet4);
        list.add(OpenBitSet1);
        list.add(OpenBitSet2);
        list.add(OpenBitSet3);
        list.add(OpenBitSet4);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique root = jtNode = jtBuilder.junctionTree(list, false).getRoot();
        Assert.assertEquals((Object)OpenBitSet1, (Object)root.getBitSet());
        Assert.assertEquals((long)2L, (long)root.getChildren().size());
        JunctionTreeSeparator sep = (JunctionTreeSeparator)root.getChildren().get(0);
        Assert.assertEquals((Object)OpenBitSet1, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)OpenBitSet2, (Object)sep.getChild().getBitSet());
        Assert.assertEquals((long)0L, (long)sep.getChild().getChildren().size());
        sep = (JunctionTreeSeparator)root.getChildren().get(1);
        Assert.assertEquals((Object)OpenBitSet1, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)OpenBitSet4, (Object)sep.getChild().getBitSet());
        Assert.assertEquals((Object)intersect1And4, (Object)sep.getBitSet());
        Assert.assertEquals((long)1L, (long)sep.getChild().getChildren().size());
        jtNode = sep.getChild();
        Assert.assertEquals((Object)OpenBitSet4, (Object)jtNode.getBitSet());
        Assert.assertEquals((long)1L, (long)jtNode.getChildren().size());
        sep = (JunctionTreeSeparator)jtNode.getChildren().get(0);
        Assert.assertEquals((Object)OpenBitSet4, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)OpenBitSet3, (Object)sep.getChild().getBitSet());
        Assert.assertEquals((Object)intersect3And4, (Object)sep.getBitSet());
        Assert.assertEquals((long)0L, (long)sep.getChild().getChildren().size());
    }

    @Test
    public void testMapNodeToCliques() {
        BayesNetwork graph = new BayesNetwork();
        JunctionTreeBuilder tbuilder = new JunctionTreeBuilder((Graph)graph);
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        OpenBitSet clique0 = GraphTest.bitSet("01010101");
        OpenBitSet clique1 = GraphTest.bitSet("10010001");
        OpenBitSet clique2 = GraphTest.bitSet("10111010");
        OpenBitSet[] nodeToCliques = new OpenBitSet[8];
        tbuilder.mapVarNodeToCliques(nodeToCliques, 0, clique0);
        tbuilder.mapVarNodeToCliques(nodeToCliques, 1, clique1);
        tbuilder.mapVarNodeToCliques(nodeToCliques, 2, clique2);
        Assert.assertEquals((Object)GraphTest.bitSet("011"), (Object)nodeToCliques[0]);
        Assert.assertEquals((Object)GraphTest.bitSet("100"), (Object)nodeToCliques[1]);
        Assert.assertEquals((Object)GraphTest.bitSet("001"), (Object)nodeToCliques[2]);
        Assert.assertEquals((Object)GraphTest.bitSet("100"), (Object)nodeToCliques[3]);
        Assert.assertEquals((Object)GraphTest.bitSet("111"), (Object)nodeToCliques[4]);
        Assert.assertEquals((Object)GraphTest.bitSet("100"), (Object)nodeToCliques[5]);
        Assert.assertEquals((Object)GraphTest.bitSet("001"), (Object)nodeToCliques[6]);
        Assert.assertEquals((Object)GraphTest.bitSet("110"), (Object)nodeToCliques[7]);
    }

    @Test
    public void testMapNodeToClique() {
        BayesNetwork graph = new BayesNetwork();
        JunctionTreeBuilder tbuilder = new JunctionTreeBuilder((Graph)graph);
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectChildToParents(x1, x2, x3);
        GraphTest.connectChildToParents(x3, x6, x7);
        OpenBitSet clique0 = GraphTest.bitSet("01001110");
        OpenBitSet clique1 = GraphTest.bitSet("11001110");
        OpenBitSet clique2 = GraphTest.bitSet("11101000");
        OpenBitSet clique3 = GraphTest.bitSet("00010011");
        JunctionTreeClique jtNode0 = new JunctionTreeClique(0, (Graph)graph, clique0);
        JunctionTreeClique jtNode1 = new JunctionTreeClique(1, (Graph)graph, clique1);
        JunctionTreeClique jtNode2 = new JunctionTreeClique(2, (Graph)graph, clique2);
        JunctionTreeClique jtNode3 = new JunctionTreeClique(3, (Graph)graph, clique3);
        JunctionTreeClique[] jtNodes = new JunctionTreeClique[]{jtNode0, jtNode1, jtNode2, jtNode3};
        OpenBitSet[] nodeToCliques = new OpenBitSet[8];
        tbuilder.mapVarNodeToCliques(nodeToCliques, 0, clique0);
        tbuilder.mapVarNodeToCliques(nodeToCliques, 1, clique1);
        tbuilder.mapVarNodeToCliques(nodeToCliques, 2, clique2);
        tbuilder.mapVarNodeToCliques(nodeToCliques, 3, clique3);
        tbuilder.mapNodeToCliqueFamily(nodeToCliques, jtNodes);
        Assert.assertEquals((long)3L, (long)((BayesVariable)x0.getContent()).getFamily());
        Assert.assertEquals((long)0L, (long)((BayesVariable)x1.getContent()).getFamily());
        Assert.assertEquals((long)0L, (long)((BayesVariable)x2.getContent()).getFamily());
        Assert.assertEquals((long)2L, (long)((BayesVariable)x3.getContent()).getFamily());
        Assert.assertEquals((long)3L, (long)((BayesVariable)x4.getContent()).getFamily());
        Assert.assertEquals((long)2L, (long)((BayesVariable)x5.getContent()).getFamily());
        Assert.assertEquals((long)0L, (long)((BayesVariable)x6.getContent()).getFamily());
        Assert.assertEquals((long)2L, (long)((BayesVariable)x7.getContent()).getFamily());
    }

    @Test
    public void testFullExample1() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> xa = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xb = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xc = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xd = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xe = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xf = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xg = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xh = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(xa, xb, xc);
        GraphTest.connectParentToChildren(xb, xd);
        GraphTest.connectParentToChildren(xc, xe, xg);
        GraphTest.connectParentToChildren(xd, xf);
        GraphTest.connectParentToChildren(xe, xf, xh);
        GraphTest.connectParentToChildren(xg, xh);
        OpenBitSet clique1 = GraphTest.bitSet("00111000");
        OpenBitSet clique2 = GraphTest.bitSet("00011100");
        OpenBitSet clique3 = GraphTest.bitSet("01010100");
        OpenBitSet clique4 = GraphTest.bitSet("11010000");
        OpenBitSet clique5 = GraphTest.bitSet("00001110");
        OpenBitSet clique6 = GraphTest.bitSet("00000111");
        OpenBitSet clique1And2 = GraphTest.bitSet("00011000");
        OpenBitSet clique2And3 = GraphTest.bitSet("00010100");
        OpenBitSet clique2And5 = GraphTest.bitSet("00001100");
        OpenBitSet clique3And4 = GraphTest.bitSet("01010000");
        OpenBitSet clique5And6 = GraphTest.bitSet("00000110");
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique root = jtBuilder.build(false).getRoot();
        Assert.assertEquals((Object)clique1, (Object)root.getBitSet());
        Assert.assertEquals((long)1L, (long)root.getChildren().size());
        JunctionTreeSeparator sep = (JunctionTreeSeparator)root.getChildren().get(0);
        Assert.assertEquals((Object)clique1And2, (Object)sep.getBitSet());
        JunctionTreeClique jtNode2 = sep.getChild();
        Assert.assertEquals((Object)clique1, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)clique2, (Object)jtNode2.getBitSet());
        Assert.assertEquals((long)2L, (long)jtNode2.getChildren().size());
        sep = (JunctionTreeSeparator)jtNode2.getChildren().get(0);
        Assert.assertEquals((Object)clique2And3, (Object)sep.getBitSet());
        JunctionTreeClique jtNode3 = sep.getChild();
        Assert.assertEquals((Object)clique2, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)clique3, (Object)jtNode3.getBitSet());
        Assert.assertEquals((long)1L, (long)jtNode3.getChildren().size());
        sep = (JunctionTreeSeparator)jtNode3.getChildren().get(0);
        Assert.assertEquals((Object)clique3And4, (Object)sep.getBitSet());
        JunctionTreeClique jtNode4 = sep.getChild();
        Assert.assertEquals((Object)clique3, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)clique4, (Object)jtNode4.getBitSet());
        Assert.assertEquals((long)0L, (long)jtNode4.getChildren().size());
        sep = (JunctionTreeSeparator)jtNode2.getChildren().get(1);
        Assert.assertEquals((Object)clique2And5, (Object)sep.getBitSet());
        JunctionTreeClique jtNode5 = sep.getChild();
        Assert.assertEquals((Object)clique2, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)clique5, (Object)jtNode5.getBitSet());
        Assert.assertEquals((long)1L, (long)jtNode5.getChildren().size());
        sep = (JunctionTreeSeparator)jtNode5.getChildren().get(0);
        Assert.assertEquals((Object)clique5And6, (Object)sep.getBitSet());
        JunctionTreeClique jtNode6 = sep.getChild();
        Assert.assertEquals((Object)clique5, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)clique6, (Object)jtNode6.getBitSet());
        Assert.assertEquals((long)0L, (long)jtNode6.getChildren().size());
    }

    @Test
    public void testFullExample2() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> xElectricity = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xTelecom = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xRail = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xAirTravel = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xTransportation = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xUtilities = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xUSBanks = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xUSStocks = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(xElectricity, xRail, xAirTravel, xUtilities, xTelecom);
        GraphTest.connectParentToChildren(xTelecom, xUtilities, xUSBanks);
        GraphTest.connectParentToChildren(xRail, xTransportation);
        GraphTest.connectParentToChildren(xAirTravel, xTransportation);
        GraphTest.connectParentToChildren(xUtilities, xUSStocks);
        GraphTest.connectParentToChildren(xUSBanks, xUSStocks);
        GraphTest.connectParentToChildren(xTransportation, xUSStocks);
        OpenBitSet clique1 = GraphTest.bitSet("11110000");
        OpenBitSet clique2 = GraphTest.bitSet("01110001");
        OpenBitSet clique3 = GraphTest.bitSet("01100011");
        OpenBitSet clique4 = GraphTest.bitSet("00011101");
        OpenBitSet clique1And2 = GraphTest.bitSet("01110000");
        OpenBitSet clique2And3 = GraphTest.bitSet("01100001");
        OpenBitSet clique2And4 = GraphTest.bitSet("00010001");
        xElectricity.setContent((Object)new BayesVariable("Electricity", xElectricity.getId(), (Object[])new String[]{"Working", "Reduced", "NotWorking"}, (double[][])new double[][]{{0.6, 0.3, 0.099}}));
        xTelecom.setContent((Object)new BayesVariable("Telecom", xTelecom.getId(), (Object[])new String[]{"Working", "Reduced", "NotWorking"}, (double[][])new double[][]{{0.544, 0.304, 0.151}}));
        xRail.setContent((Object)new BayesVariable("Rail", xRail.getId(), (Object[])new String[]{"Working", "Reduced", "NotWorking"}, (double[][])new double[][]{{0.579, 0.23, 0.19}}));
        xAirTravel.setContent((Object)new BayesVariable("AirTravel", xAirTravel.getId(), (Object[])new String[]{"Working", "Reduced", "NotWorking"}, (double[][])new double[][]{{0.449, 0.33, 0.219}}));
        xTransportation.setContent((Object)new BayesVariable("Transportation", xTransportation.getId(), (Object[])new String[]{"Working", "Moderate", "Severe", "Failure"}, (double[][])new double[][]{{0.658, 0.167, 0.097, 0.077}}));
        xUtilities.setContent((Object)new BayesVariable("Utilities", xUtilities.getId(), (Object[])new String[]{"Working", "Moderate", "Severe", "Failure"}, (double[][])new double[][]{{0.541, 0.272, 0.097, 0.088}}));
        xUSBanks.setContent((Object)new BayesVariable("USBanks", xUSBanks.getId(), (Object[])new String[]{"Working", "Reduced", "NotWorking"}, (double[][])new double[][]{{0.488, 0.37, 0.141}}));
        xUSStocks.setContent((Object)new BayesVariable("USStocks", xUSStocks.getId(), (Object[])new String[]{"Up", "Down", "Crash"}, (double[][])new double[][]{{0.433, 0.386, 0.179}}));
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique root = jtBuilder.build(false).getRoot();
        Assert.assertEquals((Object)clique1, (Object)root.getBitSet());
        Assert.assertEquals((long)1L, (long)root.getChildren().size());
        JunctionTreeSeparator sep = (JunctionTreeSeparator)root.getChildren().get(0);
        Assert.assertEquals((Object)clique1And2, (Object)sep.getBitSet());
        JunctionTreeClique jtNode2 = sep.getChild();
        Assert.assertEquals((Object)clique1, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)clique2, (Object)jtNode2.getBitSet());
        Assert.assertEquals((long)2L, (long)jtNode2.getChildren().size());
        Assert.assertSame((Object)sep, (Object)jtNode2.getParentSeparator());
        sep = (JunctionTreeSeparator)jtNode2.getChildren().get(0);
        Assert.assertEquals((Object)clique2And3, (Object)sep.getBitSet());
        JunctionTreeClique jtNode3 = sep.getChild();
        Assert.assertEquals((Object)clique2, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)clique3, (Object)jtNode3.getBitSet());
        Assert.assertEquals((long)0L, (long)jtNode3.getChildren().size());
        sep = (JunctionTreeSeparator)jtNode2.getChildren().get(1);
        Assert.assertEquals((Object)clique2And4, (Object)sep.getBitSet());
        JunctionTreeClique jtNode4 = sep.getChild();
        Assert.assertEquals((Object)clique2, (Object)sep.getParent().getBitSet());
        Assert.assertEquals((Object)clique4, (Object)jtNode4.getBitSet());
        Assert.assertEquals((long)0L, (long)jtNode4.getChildren().size());
    }
}

