/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.ArrayList;
import java.util.List;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.JunctionTreeBuilder;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.drools.beliefs.graph.impl.EdgeImpl;
import org.drools.core.util.bitmask.OpenBitSet;
import org.junit.Assert;

public class GraphTest {
    public static void connectParentToChildren(GraphNode parent, GraphNode ... children) {
        for (GraphNode child : children) {
            EdgeImpl e = new EdgeImpl();
            e.setOutGraphNode(parent);
            e.setInGraphNode(child);
        }
    }

    public static void connectChildToParents(GraphNode child, GraphNode ... parents) {
        for (GraphNode parent : parents) {
            EdgeImpl e = new EdgeImpl();
            e.setOutGraphNode(parent);
            e.setInGraphNode(child);
        }
    }

    public static boolean assertLinkedNode(JunctionTreeBuilder graph, int ... ints) {
        return GraphTest.assertLinkedVertex(graph.getAdjacencyMatrix(), ints);
    }

    public static boolean assertLinkedVertex(boolean[][] adjMatrix, int ... ints) {
        int id = ints[0];
        List adjVert = JunctionTreeBuilder.getAdjacentVertices((boolean[][])adjMatrix, (int)id);
        Assert.assertEquals((long)(ints.length - 1), (long)adjVert.size());
        for (int i = 1; i < ints.length; ++i) {
            Assert.assertTrue((String)("link was not true " + id + ", " + i), (boolean)adjMatrix[id][ints[i]]);
            Assert.assertTrue((String)("link was not true " + i + ", " + id), (boolean)adjMatrix[ints[i]][id]);
            Assert.assertTrue((String)("does not contain " + ints[i]), (boolean)adjVert.contains(ints[i]));
        }
        return false;
    }

    public static GraphNode<BayesVariable> addNode(Graph<BayesVariable> graph) {
        GraphNode x = graph.addNode();
        x.setContent((Object)new BayesVariable("x" + x.getId(), x.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        return x;
    }

    public static List asList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static OpenBitSet bitSet(String s) {
        OpenBitSet bitSet = new OpenBitSet();
        bitSet.setBits(new long[]{Long.valueOf(s, 2)});
        return bitSet;
    }
}

