/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes.example;

import org.drools.beliefs.bayes.BayesInstance;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.BayesVariableState;
import org.drools.beliefs.bayes.JunctionTree;
import org.drools.beliefs.bayes.JunctionTreeBuilder;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.JunctionTreeTest;
import org.drools.beliefs.bayes.example.SprinkerTest;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.junit.Before;
import org.junit.Test;

public class EarthQuakeTest {
    Graph<BayesVariable> graph = new BayesNetwork();
    GraphNode<BayesVariable> burglaryNode = this.graph.addNode();
    GraphNode<BayesVariable> earthquakeNode = this.graph.addNode();
    GraphNode<BayesVariable> alarmNode = this.graph.addNode();
    GraphNode<BayesVariable> johnCallsNode = this.graph.addNode();
    GraphNode<BayesVariable> maryCallsNode = this.graph.addNode();
    BayesVariable burglary = new BayesVariable("Burglary", this.burglaryNode.getId(), (Object[])new String[]{"false", "true"}, (double[][])new double[][]{{0.001, 0.999}});
    BayesVariable earthquake = new BayesVariable("Earthquake", this.earthquakeNode.getId(), (Object[])new String[]{"false", "true"}, (double[][])new double[][]{{0.002, 0.998}});
    BayesVariable alarm = new BayesVariable("Alarm", this.alarmNode.getId(), (Object[])new String[]{"false", "true"}, (double[][])new double[][]{{0.95, 0.05}, {0.94, 0.06}, {0.29, 0.71}, {0.001, 0.999}});
    BayesVariable johnCalls = new BayesVariable("JohnCalls", this.johnCallsNode.getId(), (Object[])new String[]{"false", "true"}, (double[][])new double[][]{{0.9, 0.1}, {0.05, 0.95}});
    BayesVariable maryCalls = new BayesVariable("MaryCalls", this.maryCallsNode.getId(), (Object[])new String[]{"false", "true"}, (double[][])new double[][]{{0.7, 0.3}, {0.01, 0.99}});
    BayesVariableState burglaryState;
    BayesVariableState earthquakeState;
    BayesVariableState alarmState;
    BayesVariableState johnCallsState;
    BayesVariableState maryCallsState;
    JunctionTreeClique jtNode1;
    JunctionTreeClique jtNode2;
    JunctionTreeClique jtNode3;
    JunctionTree jTree;
    BayesInstance bayesInstance;

    @Before
    public void setUp() {
        SprinkerTest.connectParentToChildren(this.burglaryNode, this.alarmNode);
        SprinkerTest.connectParentToChildren(this.earthquakeNode, this.alarmNode);
        SprinkerTest.connectParentToChildren(this.alarmNode, this.johnCallsNode, this.maryCallsNode);
        this.burglaryNode.setContent((Object)this.burglary);
        this.earthquakeNode.setContent((Object)this.earthquake);
        this.alarmNode.setContent((Object)this.alarm);
        this.johnCallsNode.setContent((Object)this.johnCalls);
        this.maryCallsNode.setContent((Object)this.maryCalls);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder(this.graph);
        this.jTree = jtBuilder.build();
        this.jtNode1 = this.jTree.getRoot();
        this.jtNode2 = ((JunctionTreeSeparator)this.jtNode1.getChildren().get(0)).getChild();
        this.jtNode3 = ((JunctionTreeSeparator)this.jtNode1.getChildren().get(1)).getChild();
        this.bayesInstance = new BayesInstance(this.jTree);
        this.burglaryState = this.bayesInstance.getVarStates()[this.burglary.getId()];
        this.earthquakeState = this.bayesInstance.getVarStates()[this.earthquake.getId()];
        this.alarmState = this.bayesInstance.getVarStates()[this.alarm.getId()];
        this.johnCallsState = this.bayesInstance.getVarStates()[this.johnCalls.getId()];
        this.maryCallsState = this.bayesInstance.getVarStates()[this.maryCalls.getId()];
    }

    @Test
    public void testInitialize() {
        JunctionTreeTest.assertArray(new double[]{0.9, 0.1, 0.05, 0.95}, JunctionTreeTest.scaleDouble(3, this.jtNode1.getPotentials()));
        JunctionTreeTest.assertArray(new double[]{0.7, 0.3, 0.01, 0.99}, JunctionTreeTest.scaleDouble(3, this.jtNode2.getPotentials()));
        JunctionTreeTest.assertArray(new double[]{1.9E-6, 1.0E-7, 9.381E-4, 5.99E-5, 5.794E-4, 0.0014186, 9.97E-4, 0.996005}, JunctionTreeTest.scaleDouble(7, this.jtNode3.getPotentials()));
    }

    @Test
    public void testNoEvidence() {
        this.bayesInstance.globalUpdate();
        JunctionTreeTest.assertArray(new double[]{0.052139, 0.947861}, JunctionTreeTest.scaleDouble(6, this.bayesInstance.marginalize("JohnCalls").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.011736, 0.988264}, JunctionTreeTest.scaleDouble(6, this.bayesInstance.marginalize("MaryCalls").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.001, 0.999}, JunctionTreeTest.scaleDouble(3, this.bayesInstance.marginalize("Burglary").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.002, 0.998}, JunctionTreeTest.scaleDouble(3, this.bayesInstance.marginalize("Earthquake").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.002516, 0.997484}, JunctionTreeTest.scaleDouble(6, this.bayesInstance.marginalize("Alarm").getDistribution()));
    }

    @Test
    public void testAlarmEvidence() {
        BayesInstance bayesInstance = new BayesInstance(this.jTree);
        bayesInstance.setLikelyhood("Alarm", new double[]{1.0, 0.0});
        bayesInstance.globalUpdate();
        JunctionTreeTest.assertArray(new double[]{0.9, 0.1}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("JohnCalls").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.7, 0.3}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("MaryCalls").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.374, 0.626}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Burglary").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.231, 0.769}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Earthquake").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{1.0, 0.0}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Alarm").getDistribution()));
    }

    @Test
    public void testEathQuakeEvidence() {
        BayesInstance bayesInstance = new BayesInstance(this.jTree);
        bayesInstance.setLikelyhood("Earthquake", new double[]{1.0, 0.0});
        bayesInstance.globalUpdate();
        JunctionTreeTest.assertArray(new double[]{0.297, 0.703}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("JohnCalls").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.211, 0.789}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("MaryCalls").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.001, 0.999}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Burglary").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{1.0, 0.0}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Earthquake").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.291, 0.709}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Alarm").getDistribution()));
    }

    @Test
    public void testJoinCallsEvidence() {
        BayesInstance bayesInstance = new BayesInstance(this.jTree);
        bayesInstance.setLikelyhood("JohnCalls", new double[]{1.0, 0.0});
        bayesInstance.globalUpdate();
        JunctionTreeTest.assertArray(new double[]{1.0, 0.0}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("JohnCalls").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.04, 0.96}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("MaryCalls").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.016, 0.984}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Burglary").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.011, 0.989}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Earthquake").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.043, 0.957}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Alarm").getDistribution()));
    }

    @Test
    public void testEarthquakeAndJohnCallsEvidence() {
        BayesInstance bayesInstance = new BayesInstance(this.jTree);
        bayesInstance.setLikelyhood("JohnCalls", new double[]{1.0, 0.0});
        bayesInstance.setLikelyhood("Earthquake", new double[]{1.0, 0.0});
        bayesInstance.globalUpdate();
        JunctionTreeTest.assertArray(new double[]{1.0, 0.0}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("JohnCalls").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.618, 0.382}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("MaryCalls").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.003, 0.997}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Burglary").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{1.0, 0.0}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Earthquake").getDistribution()));
        JunctionTreeTest.assertArray(new double[]{0.881, 0.119}, JunctionTreeTest.scaleDouble(3, bayesInstance.marginalize("Alarm").getDistribution()));
    }
}

