/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import org.drools.beliefs.bayes.BayesInstance;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.GraphTest;
import org.drools.beliefs.bayes.JunctionTree;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.JunctionTreeTest;
import org.drools.beliefs.bayes.SeparatorState;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.junit.Test;

public class PassMessageTest {
    @Test
    public void testPassMessage1() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, null);
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        x0.setContent((Object)a);
        JunctionTreeClique node1 = new JunctionTreeClique(0, (Graph)graph, GraphTest.bitSet("0001"));
        JunctionTreeClique node2 = new JunctionTreeClique(1, (Graph)graph, GraphTest.bitSet("0001"));
        JunctionTreeSeparator sep = new JunctionTreeSeparator(0, node1, node2, GraphTest.bitSet("0001"), (Graph)graph);
        node1.getPotentials()[0] = 0.2;
        node1.getPotentials()[1] = 0.3;
        node2.getPotentials()[0] = 0.6;
        node2.getPotentials()[1] = 0.7;
        JunctionTree jtree = new JunctionTree((Graph)graph, node1, new JunctionTreeClique[]{node1, node2}, new JunctionTreeSeparator[]{sep});
        BayesInstance bayesInstance = new BayesInstance(jtree);
        SeparatorState sepState = bayesInstance.getSeparatorStates()[0];
        sepState.getPotentials()[0] = 0.4;
        sepState.getPotentials()[1] = 0.5;
        bayesInstance.passMessage(node1, sep, node2);
        JunctionTreeTest.assertArray(new double[]{0.2, 0.3}, JunctionTreeTest.scaleDouble(3, bayesInstance.getCliqueStates()[node1.getId()].getPotentials()));
        JunctionTreeTest.assertArray(new double[]{0.4, 0.6}, JunctionTreeTest.scaleDouble(3, sepState.getPotentials()));
        JunctionTreeTest.assertArray(new double[]{0.417, 0.583}, JunctionTreeTest.scaleDouble(3, bayesInstance.getCliqueStates()[node2.getId()].getPotentials()));
    }
}

