/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes.integration;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.model.Bif;
import org.drools.beliefs.bayes.model.Definition;
import org.drools.beliefs.bayes.model.Network;
import org.drools.beliefs.bayes.model.Variable;
import org.drools.beliefs.bayes.model.XmlBifParser;
import org.drools.beliefs.graph.GraphNode;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    @Test
    public void testSprinklerLoadBif() {
        Bif bif = XmlBifParser.loadBif((URL)ParserTest.class.getResource("Garden.xmlbif"));
        Network network = bif.getNetwork();
        Assert.assertEquals((Object)"Garden", (Object)network.getName());
        Assert.assertEquals((Object)"package = org.drools.beliefs.bayes.integration", network.getProperties().get(0));
        Map<String, Variable> varMap = this.varToMap(network.getVariables());
        Assert.assertEquals((long)4L, (long)varMap.size());
        Variable var = varMap.get("WetGrass");
        Assert.assertEquals((Object)"WetGrass", (Object)var.getName());
        Assert.assertEquals((long)2L, (long)var.getOutComes().size());
        Assert.assertEquals((Object)var.getOutComes(), Arrays.asList("false", "true"));
        Assert.assertEquals((Object)"position = (0,10)", var.getProperties().get(0));
        var = varMap.get("Cloudy");
        Assert.assertEquals((Object)"Cloudy", (Object)var.getName());
        Assert.assertEquals((long)2L, (long)var.getOutComes().size());
        Assert.assertEquals((Object)var.getOutComes(), Arrays.asList("false", "true"));
        Assert.assertEquals((Object)"position = (0,-10)", var.getProperties().get(0));
        var = varMap.get("Sprinkler");
        Assert.assertEquals((Object)"Sprinkler", (Object)var.getName());
        Assert.assertEquals((long)2L, (long)var.getOutComes().size());
        Assert.assertEquals((Object)var.getOutComes(), Arrays.asList("false", "true"));
        Assert.assertEquals((Object)"position = (13,0)", var.getProperties().get(0));
        var = varMap.get("Rain");
        Assert.assertEquals((Object)"Rain", (Object)var.getName());
        Assert.assertEquals((long)2L, (long)var.getOutComes().size());
        Assert.assertEquals((Object)var.getOutComes(), Arrays.asList("false", "true"));
        Assert.assertEquals((Object)"position = (-12,0)", var.getProperties().get(0));
        Map<String, Definition> defMap = this.defToMap(network.getDefinitions());
        Assert.assertEquals((long)4L, (long)defMap.size());
        Definition def = defMap.get("WetGrass");
        Assert.assertEquals((Object)"WetGrass", (Object)def.getName());
        Assert.assertEquals((long)2L, (long)def.getGiven().size());
        Assert.assertEquals((Object)def.getGiven(), Arrays.asList("Sprinkler", "Rain"));
        Assert.assertEquals((Object)"1.0 0.0 0.1 0.9 0.1 0.9 0.01 0.99", (Object)def.getProbabilities());
        def = defMap.get("Cloudy");
        Assert.assertEquals((Object)"Cloudy", (Object)def.getName());
        Assert.assertNull((Object)def.getGiven());
        Assert.assertEquals((Object)"0.5 0.5", (Object)def.getProbabilities().trim());
        def = defMap.get("Sprinkler");
        Assert.assertEquals((Object)"Sprinkler", (Object)def.getName());
        Assert.assertEquals((long)1L, (long)def.getGiven().size());
        Assert.assertEquals((Object)"Cloudy", def.getGiven().get(0));
        Assert.assertEquals((Object)"0.5 0.5 0.9 0.1", (Object)def.getProbabilities().trim());
        def = defMap.get("Rain");
        Assert.assertEquals((Object)"Rain", (Object)def.getName());
        Assert.assertNull((Object)def.getGiven());
        Assert.assertEquals((Object)"0.5 0.5", (Object)def.getProbabilities().trim());
    }

    @Test
    public void testSprinklerBuildBayesNework() {
        Bif bif = XmlBifParser.loadBif((URL)ParserTest.class.getResource("Garden.xmlbif"));
        BayesNetwork network = XmlBifParser.buildBayesNetwork((Bif)bif);
        Map<String, GraphNode<BayesVariable>> map = this.nodeToMap(network);
        GraphNode<BayesVariable> node = map.get("WetGrass");
        BayesVariable wetGrass = (BayesVariable)node.getContent();
        Assert.assertEquals(Arrays.asList("false", "true"), Arrays.asList(wetGrass.getOutcomes()));
        Assert.assertEquals((long)2L, (long)wetGrass.getGiven().length);
        Assert.assertEquals(Arrays.asList(wetGrass.getGiven()), Arrays.asList("Sprinkler", "Rain"));
        Assert.assertTrue((boolean)Arrays.deepEquals((Object[])new double[][]{{1.0, 0.0}, {0.1, 0.9}, {0.1, 0.9}, {0.01, 0.99}}, (Object[])wetGrass.getProbabilityTable()));
        node = map.get("Sprinkler");
        BayesVariable sprinkler = (BayesVariable)node.getContent();
        Assert.assertEquals(Arrays.asList("false", "true"), Arrays.asList(sprinkler.getOutcomes()));
        Assert.assertEquals((long)1L, (long)sprinkler.getGiven().length);
        Assert.assertEquals((Object)"Cloudy", (Object)sprinkler.getGiven()[0]);
        Assert.assertTrue((boolean)Arrays.deepEquals((Object[])new double[][]{{0.5, 0.5}, {0.9, 0.1}}, (Object[])sprinkler.getProbabilityTable()));
        node = map.get("Cloudy");
        BayesVariable cloudy = (BayesVariable)node.getContent();
        Assert.assertEquals(Arrays.asList("false", "true"), Arrays.asList(cloudy.getOutcomes()));
        Assert.assertEquals((long)0L, (long)cloudy.getGiven().length);
        Assert.assertTrue((boolean)Arrays.deepEquals((Object[])new double[][]{{0.5, 0.5}}, (Object[])cloudy.getProbabilityTable()));
        node = map.get("Rain");
        BayesVariable rain = (BayesVariable)node.getContent();
        Assert.assertEquals(Arrays.asList("false", "true"), Arrays.asList(rain.getOutcomes()));
        Assert.assertEquals((long)0L, (long)rain.getGiven().length);
        Assert.assertTrue((boolean)Arrays.deepEquals((Object[])new double[][]{{0.5, 0.5}}, (Object[])rain.getProbabilityTable()));
    }

    Map<String, GraphNode<BayesVariable>> nodeToMap(BayesNetwork network) {
        HashMap<String, GraphNode<BayesVariable>> map = new HashMap<String, GraphNode<BayesVariable>>();
        for (GraphNode node : network) {
            map.put(((BayesVariable)node.getContent()).getName(), (GraphNode<BayesVariable>)node);
        }
        return map;
    }

    public Map<String, Variable> varToMap(List<Variable> list) {
        HashMap<String, Variable> map = new HashMap<String, Variable>();
        for (Variable var : list) {
            map.put(var.getName(), var);
        }
        return map;
    }

    public Map<String, Definition> defToMap(List<Definition> list) {
        HashMap<String, Definition> map = new HashMap<String, Definition>();
        for (Definition def : list) {
            map.put(def.getName(), def);
        }
        return map;
    }
}

