/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes.model;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.assembler.BayesNetworkAssemblerError;
import org.drools.beliefs.bayes.model.Bif;
import org.drools.beliefs.bayes.model.Definition;
import org.drools.beliefs.bayes.model.Network;
import org.drools.beliefs.bayes.model.Probability;
import org.drools.beliefs.bayes.model.Variable;
import org.drools.beliefs.graph.GraphNode;
import org.drools.beliefs.graph.impl.EdgeImpl;
import org.drools.drl.parser.ParserError;
import org.drools.util.io.InternalResource;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.utll.xml.XStreamUtils;

public class XmlBifParser {
    public static Bif loadBif(Resource resource, ArrayList<KnowledgeBuilderError> errors) {
        InputStream is = null;
        try {
            is = resource.getInputStream();
        }
        catch (IOException e) {
            errors.add((KnowledgeBuilderError)new ParserError(resource, "Exception opening Stream:\n" + e.toString(), 0, 0));
            return null;
        }
        try {
            String encoding = resource instanceof InternalResource ? ((InternalResource)resource).getEncoding() : null;
            XStream xstream = encoding != null ? XStreamUtils.createNonTrustingXStream((HierarchicalStreamDriver)new DomDriver(encoding)) : XStreamUtils.createNonTrustingXStream();
            XmlBifParser.initXStream(xstream);
            Bif bif = (Bif)xstream.fromXML(is);
            return bif;
        }
        catch (Exception e) {
            errors.add((KnowledgeBuilderError)new BayesNetworkAssemblerError(resource, "Unable to parse opening Stream:\n" + e.toString()));
            return null;
        }
    }

    public static Bif loadBif(URL url) {
        XStream xstream = XStreamUtils.createNonTrustingXStream();
        XmlBifParser.initXStream(xstream);
        Bif bif = (Bif)xstream.fromXML(url);
        return bif;
    }

    private static void initXStream(XStream xstream) {
        xstream.processAnnotations(Bif.class);
        xstream.processAnnotations(Network.class);
        xstream.processAnnotations(Probability.class);
        xstream.processAnnotations(Definition.class);
    }

    public static BayesNetwork buildBayesNetwork(Bif bif) {
        BayesVariable var;
        GraphNode node;
        String name = bif.getNetwork().getName();
        String packageName = "default";
        List<String> props = bif.getNetwork().getProperties();
        if (props != null) {
            for (String prop : props) {
                if (!(prop = prop.trim()).startsWith("package")) continue;
                packageName = prop.substring(prop.indexOf(61) + 1).trim();
            }
        }
        BayesNetwork graph = new BayesNetwork(name, packageName);
        HashMap<String, GraphNode> map = new HashMap<String, GraphNode>();
        for (Definition definition : bif.getNetwork().getDefinitions()) {
            node = graph.addNode();
            var = XmlBifParser.buildVariable(definition, bif.getNetwork(), node.getId());
            node.setContent(var);
            map.put(var.getName(), node);
        }
        for (Map.Entry entry : map.entrySet()) {
            node = (GraphNode)entry.getValue();
            var = (BayesVariable)node.getContent();
            if (var.getGiven() == null || var.getGiven().length <= 0) continue;
            for (String given : var.getGiven()) {
                GraphNode givenNode = (GraphNode)map.get(given);
                EdgeImpl e = new EdgeImpl();
                e.setOutGraphNode(givenNode);
                e.setInGraphNode(node);
            }
        }
        return graph;
    }

    private static BayesVariable buildVariable(Definition def, Network network, int id) {
        ArrayList<String> outcomes = new ArrayList<String>();
        XmlBifParser.getOutcomesByVariable(network, def.getName(), outcomes);
        List<Object> given = def.getGiven() == null ? Collections.emptyList() : def.getGiven();
        return new BayesVariable<String>(def.getName(), id, outcomes.toArray(new String[outcomes.size()]), XmlBifParser.getProbabilities(def.getProbabilities(), outcomes), given.toArray(new String[given.size()]));
    }

    private static void getOutcomesByVariable(Network network, String nameDefinition, List<String> outcomes) {
        for (Variable var : network.getVariables()) {
            if (!var.getName().equals(nameDefinition)) continue;
            for (String outcome : var.getOutComes()) {
                outcomes.add(outcome);
            }
        }
    }

    private static double[][] getProbabilities(String table, List<String> outcomes) {
        table = table.trim();
        String[] values = table.split(" ");
        double[][] probabilities = new double[values.length / 2][outcomes.size()];
        int k = 0;
        int length = values.length / 2;
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < outcomes.size(); ++j) {
                probabilities[i][j] = Double.valueOf(values[k++]);
            }
        }
        return probabilities;
    }

    private static double[][] getPosition(String stringPosition, double[][] position) {
        if (stringPosition != null) {
            stringPosition = XmlBifParser.clearStringPostion(stringPosition);
            int i = 0;
            int j = 0;
            for (String pos : stringPosition.split(",")) {
                position[i][j] = Double.parseDouble(pos);
                if (i < j) {
                    ++i;
                }
                ++j;
            }
        }
        return null;
    }

    private static String clearStringPostion(String stringPosition) {
        stringPosition = stringPosition.replace("position", "");
        stringPosition = stringPosition.replace("=", "");
        stringPosition = stringPosition.replace("(", "");
        stringPosition = stringPosition.replace(")", "");
        stringPosition = stringPosition.trim();
        return stringPosition;
    }
}

