/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesProjection;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.GraphTest;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.JunctionTreeTest;
import org.drools.beliefs.bayes.PotentialMultiplier;
import org.drools.beliefs.bayes.SeparatorState;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.junit.Test;

public class BayesProjectionTest {
    @Test
    public void testProjection1() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, null);
        BayesVariable b = new BayesVariable("B", 1, (Object[])new String[]{"B1", "B2"}, null);
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        x0.setContent((Object)a);
        x1.setContent((Object)b);
        JunctionTreeClique node1 = new JunctionTreeClique(0, (Graph)graph, GraphTest.bitSet("0011"));
        JunctionTreeClique node2 = new JunctionTreeClique(1, (Graph)graph, GraphTest.bitSet("0011"));
        SeparatorState sep = new JunctionTreeSeparator(0, node1, node2, GraphTest.bitSet("0011"), (Graph)graph).createState();
        double v = 0.1;
        for (int i = 0; i < node1.getPotentials().length; ++i) {
            node1.getPotentials()[i] = v;
            v += 0.1;
        }
        BayesVariable[] vars = new BayesVariable[]{a, b};
        BayesVariable[] sepVars = new BayesVariable[]{a, b};
        int[] sepVarPos = PotentialMultiplier.createSubsetVarPos((BayesVariable[])vars, (BayesVariable[])sepVars);
        int sepVarNumberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])sepVars);
        int[] sepVarMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])sepVars, (int)sepVarNumberOfStates);
        double[] projectedSepPotentials = new double[sep.getPotentials().length];
        BayesProjection p = new BayesProjection(vars, node1.getPotentials(), sepVarPos, sepVarMultipliers, projectedSepPotentials);
        p.project();
        JunctionTreeTest.assertArray(new double[]{0.1, 0.2, 0.3, 0.4}, JunctionTreeTest.scaleDouble(3, projectedSepPotentials));
    }

    @Test
    public void testProjection2() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesVariable b = new BayesVariable("B", 1, (Object[])new String[]{"B1", "B2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesVariable c = new BayesVariable("C", 2, (Object[])new String[]{"C1", "C2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        x0.setContent((Object)a);
        x1.setContent((Object)b);
        x2.setContent((Object)c);
        JunctionTreeClique node1 = new JunctionTreeClique(0, (Graph)graph, GraphTest.bitSet("0111"));
        JunctionTreeClique node2 = new JunctionTreeClique(1, (Graph)graph, GraphTest.bitSet("0011"));
        SeparatorState sep = new JunctionTreeSeparator(0, node1, node2, GraphTest.bitSet("0011"), (Graph)graph).createState();
        double v = 0.1;
        for (int i = 0; i < node1.getPotentials().length; ++i) {
            node1.getPotentials()[i] = v;
            v = JunctionTreeTest.scaleDouble(3, v + 0.1);
        }
        BayesVariable[] vars = new BayesVariable[]{a, b, c};
        BayesVariable[] sepVars = new BayesVariable[]{a, b};
        int[] sepVarPos = PotentialMultiplier.createSubsetVarPos((BayesVariable[])vars, (BayesVariable[])sepVars);
        int sepVarNumberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])sepVars);
        int[] sepVarMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])sepVars, (int)sepVarNumberOfStates);
        double[] projectedSepPotentials = new double[sep.getPotentials().length];
        BayesProjection p = new BayesProjection(vars, node1.getPotentials(), sepVarPos, sepVarMultipliers, projectedSepPotentials);
        p.project();
        JunctionTreeTest.assertArray(new double[]{0.083, 0.194, 0.306, 0.417}, JunctionTreeTest.scaleDouble(3, projectedSepPotentials));
    }

    @Test
    public void testProjection3() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesVariable b = new BayesVariable("B", 1, (Object[])new String[]{"B1", "B2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesVariable c = new BayesVariable("C", 2, (Object[])new String[]{"C1", "C2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        x0.setContent((Object)a);
        x1.setContent((Object)b);
        x2.setContent((Object)c);
        JunctionTreeClique node1 = new JunctionTreeClique(0, (Graph)graph, GraphTest.bitSet("0111"));
        JunctionTreeClique node2 = new JunctionTreeClique(1, (Graph)graph, GraphTest.bitSet("0101"));
        SeparatorState sep = new JunctionTreeSeparator(0, node1, node2, GraphTest.bitSet("0101"), (Graph)graph).createState();
        double v = 0.1;
        for (int i = 0; i < node1.getPotentials().length; ++i) {
            node1.getPotentials()[i] = v;
            v = JunctionTreeTest.scaleDouble(3, v + 0.1);
        }
        BayesVariable[] vars = new BayesVariable[]{a, b, c};
        BayesVariable[] sepVars = new BayesVariable[]{a, c};
        int[] sepVarPos = PotentialMultiplier.createSubsetVarPos((BayesVariable[])vars, (BayesVariable[])sepVars);
        int sepVarNumberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])sepVars);
        int[] sepVarMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])sepVars, (int)sepVarNumberOfStates);
        double[] projectedSepPotentials = new double[sep.getPotentials().length];
        BayesProjection p = new BayesProjection(vars, node1.getPotentials(), sepVarPos, sepVarMultipliers, projectedSepPotentials);
        p.project();
        JunctionTreeTest.assertArray(new double[]{0.111, 0.167, 0.333, 0.389}, JunctionTreeTest.scaleDouble(3, projectedSepPotentials));
    }

    @Test
    public void testProjection4() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesVariable b = new BayesVariable("B", 1, (Object[])new String[]{"B1", "B2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesVariable c = new BayesVariable("C", 2, (Object[])new String[]{"C1", "C2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        x0.setContent((Object)a);
        x1.setContent((Object)b);
        x2.setContent((Object)c);
        JunctionTreeClique node1 = new JunctionTreeClique(0, (Graph)graph, GraphTest.bitSet("0111"));
        JunctionTreeClique node2 = new JunctionTreeClique(1, (Graph)graph, GraphTest.bitSet("0110"));
        SeparatorState sep = new JunctionTreeSeparator(0, node1, node2, GraphTest.bitSet("0101"), (Graph)graph).createState();
        double v = 0.1;
        for (int i = 0; i < node1.getPotentials().length; ++i) {
            node1.getPotentials()[i] = v;
            v = JunctionTreeTest.scaleDouble(3, v + 0.1);
        }
        BayesVariable[] vars = new BayesVariable[]{a, b, c};
        BayesVariable[] sepVars = new BayesVariable[]{b, c};
        int[] sepVarPos = PotentialMultiplier.createSubsetVarPos((BayesVariable[])vars, (BayesVariable[])sepVars);
        int sepVarNumberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])sepVars);
        int[] sepVarMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])sepVars, (int)sepVarNumberOfStates);
        double[] projectedSepPotentials = new double[sep.getPotentials().length];
        BayesProjection p = new BayesProjection(vars, node1.getPotentials(), sepVarPos, sepVarMultipliers, projectedSepPotentials);
        p.project();
        JunctionTreeTest.assertArray(new double[]{0.167, 0.222, 0.278, 0.333}, JunctionTreeTest.scaleDouble(3, projectedSepPotentials));
    }
}

