/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.assertj.core.api.Assertions;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.EliminationCandidate;
import org.drools.beliefs.bayes.GraphTest;
import org.drools.beliefs.bayes.JunctionTreeBuilder;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.SeparatorSet;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.drools.core.util.bitmask.OpenBitSet;
import org.junit.Test;

public class JunctionTreeBuilderTest {
    @Test
    public void testOpenBitSet() {
        OpenBitSet b1 = GraphTest.bitSet("00000111");
        OpenBitSet b2 = GraphTest.bitSet("00000111");
        OpenBitSet b3 = GraphTest.bitSet("00000110");
        OpenBitSet b4 = GraphTest.bitSet("00001110");
        Assertions.assertThat((long)OpenBitSet.andNotCount((OpenBitSet)b1, (OpenBitSet)b2)).isEqualTo(0L);
        Assertions.assertThat((long)OpenBitSet.andNotCount((OpenBitSet)b2, (OpenBitSet)b3)).isEqualTo(1L);
        Assertions.assertThat((long)OpenBitSet.andNotCount((OpenBitSet)b3, (OpenBitSet)b2)).isEqualTo(0L);
        Assertions.assertThat((long)OpenBitSet.andNotCount((OpenBitSet)b2, (OpenBitSet)b4)).isEqualTo(1L);
        Assertions.assertThat((long)OpenBitSet.andNotCount((OpenBitSet)b4, (OpenBitSet)b2)).isEqualTo(1L);
    }

    @Test
    public void testMoralize1() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x2, x1);
        GraphTest.connectParentToChildren(x3, x1);
        GraphTest.connectParentToChildren(x4, x1);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        GraphTest.assertLinkedNode(jtBuilder, 1, 2, 3, 4);
        GraphTest.assertLinkedNode(jtBuilder, 2, 1);
        GraphTest.assertLinkedNode(jtBuilder, 3, 1);
        GraphTest.assertLinkedNode(jtBuilder, 4, 1);
        jtBuilder.moralize();
        GraphTest.assertLinkedNode(jtBuilder, 1, 2, 3, 4);
        GraphTest.assertLinkedNode(jtBuilder, 2, 1, 3, 4);
        GraphTest.assertLinkedNode(jtBuilder, 3, 1, 2, 4);
        GraphTest.assertLinkedNode(jtBuilder, 4, 1, 2, 3);
    }

    @Test
    public void testMoralize2() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2, x3);
        GraphTest.connectParentToChildren(x2, x4);
        GraphTest.connectParentToChildren(x4, x5);
        GraphTest.connectParentToChildren(x3, x5);
        GraphTest.connectParentToChildren(x6, x5);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        jtBuilder.moralize();
        GraphTest.assertLinkedNode(jtBuilder, x1.getId(), 2, 3);
        GraphTest.assertLinkedNode(jtBuilder, x2.getId(), 1, 4);
        GraphTest.assertLinkedNode(jtBuilder, x3.getId(), 1, 4, 5, 6);
        GraphTest.assertLinkedNode(jtBuilder, x4.getId(), 2, 3, 5, 6);
        GraphTest.assertLinkedNode(jtBuilder, x5.getId(), 3, 4, 6);
        GraphTest.assertLinkedNode(jtBuilder, x6.getId(), 3, 4, 5);
    }

    @Test
    public void testEliminationCandidate1() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2, x3, x4);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        jtBuilder.moralize();
        EliminationCandidate vt1 = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x1);
        Assertions.assertThat((int)vt1.getNewEdgesRequired()).isEqualTo(3);
        Assertions.assertThat((Object)vt1.getCliqueBitSit()).isEqualTo((Object)GraphTest.bitSet("11110"));
    }

    @Test
    public void testEliminationCandidate2() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2, x3, x4);
        GraphTest.connectParentToChildren(x3, x4);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        jtBuilder.moralize();
        EliminationCandidate vt1 = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x1);
        Assertions.assertThat((int)vt1.getNewEdgesRequired()).isEqualTo(2);
        Assertions.assertThat((Object)vt1.getCliqueBitSit()).isEqualTo((Object)GraphTest.bitSet("11110"));
    }

    @Test
    public void testCreateClique() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> dX0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> dX1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> dX2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> dX3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> dX4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> dX5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(dX1, dX2, dX3, dX4);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        HashSet vertices = new HashSet();
        boolean[] adjList = new boolean[]{false, false, true, true, true, false};
        boolean[][] clonedAdjMatrix = JunctionTreeBuilder.cloneAdjacencyMarix((boolean[][])jtBuilder.getAdjacencyMatrix());
        jtBuilder.createClique(dX1.getId(), clonedAdjMatrix, vertices, adjList);
        Assertions.assertThat((int)vertices.size()).isEqualTo(3);
        Assertions.assertThat((boolean)vertices.containsAll(Arrays.asList(2, 3, 4))).isTrue();
        GraphTest.assertLinkedNode(jtBuilder, 1, 2, 3, 4);
        GraphTest.assertLinkedNode(jtBuilder, 2, 1, 3, 4);
        GraphTest.assertLinkedNode(jtBuilder, 3, 1, 2, 4);
        GraphTest.assertLinkedNode(jtBuilder, 4, 1, 2, 3);
    }

    @Test
    public void testCliqueSuperSet() {
        BayesNetwork graph = new BayesNetwork();
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        ArrayList cliques = new ArrayList();
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00011110");
        JunctionTreeBuilder.updateCliques(cliques, (OpenBitSet)OpenBitSet1);
        Assertions.assertThat((int)cliques.size()).isEqualTo(1);
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00000110");
        JunctionTreeBuilder.updateCliques(cliques, (OpenBitSet)OpenBitSet2);
        Assertions.assertThat((int)cliques.size()).isEqualTo(1);
        Assertions.assertThat((Object)((OpenBitSet)cliques.get(0))).isEqualTo((Object)OpenBitSet1);
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("01000110");
        JunctionTreeBuilder.updateCliques(cliques, (OpenBitSet)OpenBitSet3);
        Assertions.assertThat((int)cliques.size()).isEqualTo(2);
        Assertions.assertThat((Object)((OpenBitSet)cliques.get(0))).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((Object)((OpenBitSet)cliques.get(1))).isEqualTo((Object)OpenBitSet3);
    }

    @Test
    public void testPriorityQueueWithMinimalNewEdges() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x8 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x9 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x10 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x11 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x12 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x2, x1);
        GraphTest.connectParentToChildren(x3, x1);
        GraphTest.connectParentToChildren(x4, x1);
        GraphTest.connectParentToChildren(x6, x5);
        GraphTest.connectParentToChildren(x7, x5);
        x5.setContent((Object)new BayesVariable("x5", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        x6.setContent((Object)new BayesVariable("x6", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        x7.setContent((Object)new BayesVariable("x7", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        GraphTest.connectParentToChildren(x9, x8);
        GraphTest.connectParentToChildren(x10, x8);
        GraphTest.connectParentToChildren(x11, x8);
        GraphTest.connectParentToChildren(x12, x8);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        PriorityQueue<EliminationCandidate> p = new PriorityQueue<EliminationCandidate>(graph.size());
        EliminationCandidate elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x1);
        p.add(elmCandVert);
        elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x5);
        p.add(elmCandVert);
        elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x8);
        p.add(elmCandVert);
        EliminationCandidate v = (EliminationCandidate)p.remove();
        int id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(5);
        Assertions.assertThat((int)v.getNewEdgesRequired()).isEqualTo(1);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(1);
        Assertions.assertThat((int)v.getNewEdgesRequired()).isEqualTo(3);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(8);
        Assertions.assertThat((int)v.getNewEdgesRequired()).isEqualTo(6);
        Assertions.assertThat((int)p.size()).isEqualTo(0);
    }

    @Test
    public void testPriorityQueueWithMaximalCliqueWeight() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x8 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x9 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x10 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x11 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x12 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x2, x1);
        GraphTest.connectParentToChildren(x3, x1);
        GraphTest.connectParentToChildren(x4, x1);
        x1.setContent((Object)new BayesVariable("x1", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x2.setContent((Object)new BayesVariable("x2", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x3.setContent((Object)new BayesVariable("x3", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x4.setContent((Object)new BayesVariable("x4", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        GraphTest.connectParentToChildren(x6, x5);
        GraphTest.connectParentToChildren(x7, x5);
        GraphTest.connectParentToChildren(x8, x5);
        x5.setContent((Object)new BayesVariable("x5", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        x6.setContent((Object)new BayesVariable("x6", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        x7.setContent((Object)new BayesVariable("x7", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        x8.setContent((Object)new BayesVariable("x8", x0.getId(), (Object[])new String[]{"a", "b", "c"}, (double[][])new double[][]{{0.1, 0.1, 0.1}}));
        GraphTest.connectParentToChildren(x10, x9);
        GraphTest.connectParentToChildren(x11, x9);
        GraphTest.connectParentToChildren(x12, x9);
        x9.setContent((Object)new BayesVariable("x9", x0.getId(), (Object[])new String[]{"a"}, (double[][])new double[][]{{0.1}}));
        x10.setContent((Object)new BayesVariable("x10", x0.getId(), (Object[])new String[]{"a"}, (double[][])new double[][]{{0.1}}));
        x11.setContent((Object)new BayesVariable("x11", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x12.setContent((Object)new BayesVariable("x12", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        PriorityQueue<EliminationCandidate> p = new PriorityQueue<EliminationCandidate>(graph.size());
        EliminationCandidate elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x1);
        p.add(elmCandVert);
        elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x5);
        p.add(elmCandVert);
        elmCandVert = new EliminationCandidate((Graph)graph, jtBuilder.getAdjacencyMatrix(), x9);
        p.add(elmCandVert);
        EliminationCandidate v = (EliminationCandidate)p.remove();
        int id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(9);
        Assertions.assertThat((int)v.getWeightRequired()).isEqualTo(4);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(1);
        Assertions.assertThat((int)v.getWeightRequired()).isEqualTo(16);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(5);
        Assertions.assertThat((int)v.getWeightRequired()).isEqualTo(81);
        Assertions.assertThat((int)p.size()).isEqualTo(0);
    }

    @Test
    public void testIterativeEliminationUsingEdgeAndWeight() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2);
        GraphTest.connectParentToChildren(x1, x3);
        GraphTest.connectParentToChildren(x1, x6);
        GraphTest.connectParentToChildren(x2, x4);
        GraphTest.connectParentToChildren(x3, x5);
        GraphTest.connectParentToChildren(x4, x6);
        GraphTest.connectParentToChildren(x5, x6);
        x1.setContent((Object)new BayesVariable("x1", x0.getId(), (Object[])new String[]{"a", "b", "c", "d", "e", "f"}, (double[][])new double[][]{{0.1, 0.1, 0.1, 0.1, 0.1, 0.1}}));
        x2.setContent((Object)new BayesVariable("x2", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x3.setContent((Object)new BayesVariable("x3", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x4.setContent((Object)new BayesVariable("x4", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x5.setContent((Object)new BayesVariable("x5", x0.getId(), (Object[])new String[]{"a"}, (double[][])new double[][]{{0.1}}));
        x6.setContent((Object)new BayesVariable("x6", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        boolean[][] clonedAdjMatrix = JunctionTreeBuilder.cloneAdjacencyMarix((boolean[][])jtBuilder.getAdjacencyMatrix());
        PriorityQueue<EliminationCandidate> p = new PriorityQueue<EliminationCandidate>(graph.size());
        HashMap<Integer, EliminationCandidate> elmVertMap = new HashMap<Integer, EliminationCandidate>();
        for (GraphNode v : graph) {
            if (v.getId() == 0) continue;
            EliminationCandidate elmCandVert = new EliminationCandidate((Graph)graph, clonedAdjMatrix, v);
            p.add(elmCandVert);
            elmVertMap.put(v.getId(), elmCandVert);
        }
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 1, 2, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 2, 1, 4);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 3, 1, 5);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 4, 2, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 5, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 6, 1, 4, 5);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(1)).getNewEdgesRequired()).isEqualTo(3);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(2)).getNewEdgesRequired()).isEqualTo(1);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(3)).getNewEdgesRequired()).isEqualTo(1);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(4)).getNewEdgesRequired()).isEqualTo(1);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(5)).getNewEdgesRequired()).isEqualTo(1);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(6)).getNewEdgesRequired()).isEqualTo(3);
        EliminationCandidate v = (EliminationCandidate)p.remove();
        int id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(5);
        HashSet verticesToUpdate = new HashSet();
        boolean[] adjList = clonedAdjMatrix[id];
        jtBuilder.createClique(5, clonedAdjMatrix, verticesToUpdate, adjList);
        Assertions.assertThat((int)verticesToUpdate.size()).isEqualTo(4);
        Assertions.assertThat((boolean)verticesToUpdate.containsAll(Arrays.asList(1, 3, 6))).isTrue();
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 1, 2, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 2, 1, 4);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 3, 1, 5, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 4, 2, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 5, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 6, 1, 3, 4, 5);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(1)).getNewEdgesRequired()).isEqualTo(2);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(2)).getNewEdgesRequired()).isEqualTo(1);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(3)).getNewEdgesRequired()).isEqualTo(0);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(6)).getNewEdgesRequired()).isEqualTo(2);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(4)).getNewEdgesRequired()).isEqualTo(1);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(3);
        verticesToUpdate = new HashSet();
        jtBuilder.createClique(3, clonedAdjMatrix, verticesToUpdate, adjList);
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(4);
        verticesToUpdate = new HashSet();
        adjList = clonedAdjMatrix[id];
        jtBuilder.createClique(4, clonedAdjMatrix, verticesToUpdate, adjList);
        Assertions.assertThat((int)verticesToUpdate.size()).isEqualTo(3);
        Assertions.assertThat((boolean)verticesToUpdate.containsAll(Arrays.asList(1, 2, 6))).isTrue();
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 1, 2, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 2, 1, 4, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 3, 1, 5, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 4, 2, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 5, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 6, 1, 2, 3, 4, 5);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(1)).getNewEdgesRequired()).isEqualTo(0);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(2)).getNewEdgesRequired()).isEqualTo(0);
        Assertions.assertThat((int)((EliminationCandidate)elmVertMap.get(6)).getNewEdgesRequired()).isEqualTo(0);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(1);
        verticesToUpdate = new HashSet();
        jtBuilder.createClique(1, clonedAdjMatrix, verticesToUpdate, adjList);
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(2);
        verticesToUpdate = new HashSet();
        jtBuilder.createClique(2, clonedAdjMatrix, verticesToUpdate, adjList);
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        v = (EliminationCandidate)p.remove();
        id = v.getV().getId();
        Assertions.assertThat((int)id).isEqualTo(6);
        verticesToUpdate = new HashSet();
        jtBuilder.createClique(6, clonedAdjMatrix, verticesToUpdate, adjList);
        jtBuilder.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, v);
        Assertions.assertThat((int)p.size()).isEqualTo(0);
    }

    @Test
    public void testTriangulate1() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2);
        GraphTest.connectParentToChildren(x1, x3);
        GraphTest.connectParentToChildren(x1, x6);
        GraphTest.connectParentToChildren(x2, x4);
        GraphTest.connectParentToChildren(x3, x5);
        GraphTest.connectParentToChildren(x4, x6);
        GraphTest.connectParentToChildren(x5, x6);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        jtBuilder.moralize();
        jtBuilder.triangulate();
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 1, 2, 3, 4, 5, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 2, 1, 4);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 3, 1, 5);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 4, 1, 2, 5, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 5, 1, 3, 4, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 6, 1, 4, 5);
    }

    @Test
    public void testTriangulate2() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x1, x2);
        GraphTest.connectParentToChildren(x1, x3);
        GraphTest.connectParentToChildren(x2, x4);
        GraphTest.connectParentToChildren(x2, x6);
        GraphTest.connectParentToChildren(x3, x5);
        GraphTest.connectParentToChildren(x5, x6);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        jtBuilder.moralize();
        List cliques = jtBuilder.triangulate();
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 1, 2, 3);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 2, 1, 3, 4, 5, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 3, 1, 2, 5);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 4, 2);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 5, 2, 3, 6);
        GraphTest.assertLinkedVertex(jtBuilder.getAdjacencyMatrix(), 6, 2, 5);
        Assertions.assertThat((int)cliques.size()).isEqualTo(5);
        Assertions.assertThat((boolean)cliques.contains(GraphTest.bitSet("1110"))).isTrue();
        Assertions.assertThat((boolean)cliques.contains(GraphTest.bitSet("10100"))).isTrue();
        Assertions.assertThat((boolean)cliques.contains(GraphTest.bitSet("1100100"))).isTrue();
        Assertions.assertThat((boolean)cliques.contains(GraphTest.bitSet("101100"))).isTrue();
    }

    @Test
    public void testSepSetCompareWithDifferentMass() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        OpenBitSet OpenBitSet1_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet1_2 = GraphTest.bitSet("01101100");
        SeparatorSet s1 = new SeparatorSet(OpenBitSet1_1, 0, OpenBitSet1_2, 0, (Graph)graph);
        OpenBitSet OpenBitSet2_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet2_2 = GraphTest.bitSet("00100100");
        SeparatorSet s2 = new SeparatorSet(OpenBitSet2_1, 0, OpenBitSet2_2, 0, (Graph)graph);
        ArrayList<SeparatorSet> list = new ArrayList<SeparatorSet>();
        list.add(s1);
        list.add(s2);
        Collections.sort(list);
        Assertions.assertThat((Comparable)((SeparatorSet)list.get(0))).isEqualTo((Object)s1);
    }

    @Test
    public void testSepSetCompareWithDifferentCost() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        x1.setContent((Object)new BayesVariable("x1", x0.getId(), (Object[])new String[]{"a"}, (double[][])new double[][]{{0.1}}));
        x2.setContent((Object)new BayesVariable("x2", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x3.setContent((Object)new BayesVariable("x3", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        OpenBitSet OpenBitSet1_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet1_2 = GraphTest.bitSet("01101100");
        SeparatorSet s1 = new SeparatorSet(OpenBitSet1_1, 0, OpenBitSet1_2, 0, (Graph)graph);
        OpenBitSet OpenBitSet2_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet2_2 = GraphTest.bitSet("00100110");
        SeparatorSet s2 = new SeparatorSet(OpenBitSet2_1, 0, OpenBitSet2_2, 0, (Graph)graph);
        ArrayList<SeparatorSet> list = new ArrayList<SeparatorSet>();
        list.add(s1);
        list.add(s2);
        Collections.sort(list);
        Assertions.assertThat((Comparable)((SeparatorSet)list.get(0))).isEqualTo((Object)s1);
        x1.setContent((Object)new BayesVariable("x3", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x2.setContent((Object)new BayesVariable("x2", x0.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        x3.setContent((Object)new BayesVariable("x1", x0.getId(), (Object[])new String[]{"a"}, (double[][])new double[][]{{0.1}}));
        s1 = new SeparatorSet(OpenBitSet1_1, 0, OpenBitSet1_2, 0, (Graph)graph);
        s2 = new SeparatorSet(OpenBitSet2_1, 0, OpenBitSet2_2, 0, (Graph)graph);
        list = new ArrayList();
        list.add(s1);
        list.add(s2);
        Collections.sort(list);
        Assertions.assertThat((Comparable)((SeparatorSet)list.get(0))).isEqualTo((Object)s2);
    }

    @Test
    public void testSepSetCompareWithSameIntersect() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        OpenBitSet OpenBitSet1_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet1_2 = GraphTest.bitSet("01000010");
        SeparatorSet s1 = new SeparatorSet(OpenBitSet1_1, 0, OpenBitSet1_2, 0, (Graph)graph);
        OpenBitSet OpenBitSet2_1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet2_2 = GraphTest.bitSet("01000100");
        SeparatorSet s2 = new SeparatorSet(OpenBitSet2_1, 0, OpenBitSet2_2, 0, (Graph)graph);
        ArrayList<SeparatorSet> list = new ArrayList<SeparatorSet>();
        list.add(s1);
        list.add(s2);
        Collections.sort(list);
        Assertions.assertThat((Comparable)((SeparatorSet)list.get(0))).isEqualTo((Object)s1);
        OpenBitSet1_2 = GraphTest.bitSet("01000100");
        s1 = new SeparatorSet(OpenBitSet1_1, 0, OpenBitSet1_2, 0, (Graph)graph);
        OpenBitSet2_2 = GraphTest.bitSet("01000010");
        s2 = new SeparatorSet(OpenBitSet2_1, 0, OpenBitSet2_2, 0, (Graph)graph);
        list = new ArrayList();
        list.add(s1);
        list.add(s2);
        Collections.sort(list);
        Assertions.assertThat((Comparable)((SeparatorSet)list.get(0))).isEqualTo((Object)s2);
    }

    @Test
    public void testJunctionTree() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00001110");
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00011100");
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("00110000");
        OpenBitSet OpenBitSet4 = GraphTest.bitSet("01110000");
        ArrayList<OpenBitSet> cliques = new ArrayList<OpenBitSet>();
        cliques.add(OpenBitSet1);
        cliques.add(OpenBitSet2);
        cliques.add(OpenBitSet3);
        cliques.add(OpenBitSet4);
        ArrayList separatorSets = new ArrayList();
        for (int i = 0; i < cliques.size(); ++i) {
            OpenBitSet ci = (OpenBitSet)cliques.get(i);
            for (int j = i + 1; j < cliques.size(); ++j) {
                OpenBitSet cj = (OpenBitSet)cliques.get(j);
                if (!ci.intersects(cj)) continue;
                SeparatorSet separatorSet = new SeparatorSet(ci, 0, cj, 0, (Graph)graph);
            }
        }
        Collections.sort(separatorSets);
    }

    @Test
    public void testJunctionTreeNoPruning() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        ArrayList<OpenBitSet> list = new ArrayList<OpenBitSet>();
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00001111");
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00111100");
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("11100000");
        OpenBitSet intersect1And2 = OpenBitSet2.clone();
        intersect1And2.and(OpenBitSet1);
        OpenBitSet intersect2And3 = OpenBitSet2.clone();
        intersect2And3.and(OpenBitSet3);
        list.add(OpenBitSet1);
        list.add(OpenBitSet2);
        list.add(OpenBitSet3);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique jtNode = jtBuilder.junctionTree(list, false).getRoot();
        Assertions.assertThat((Object)jtNode.getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((int)jtNode.getChildren().size()).isEqualTo(1);
        JunctionTreeSeparator sep = (JunctionTreeSeparator)jtNode.getChildren().get(0);
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((Object)sep.getChild().getBitSet()).isEqualTo((Object)OpenBitSet2);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)intersect1And2);
        jtNode = sep.getChild();
        Assertions.assertThat((Object)jtNode.getBitSet()).isEqualTo((Object)OpenBitSet2);
        Assertions.assertThat((int)jtNode.getChildren().size()).isEqualTo(1);
        sep = (JunctionTreeSeparator)jtNode.getChildren().get(0);
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)OpenBitSet2);
        Assertions.assertThat((Object)sep.getChild().getBitSet()).isEqualTo((Object)OpenBitSet3);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)intersect2And3);
    }

    @Test
    public void testJunctionWithPruning1() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        ArrayList<OpenBitSet> list = new ArrayList<OpenBitSet>();
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00001111");
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00111100");
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("11100001");
        OpenBitSet intersect1And2 = OpenBitSet2.clone();
        intersect1And2.and(OpenBitSet1);
        OpenBitSet intersect2And3 = OpenBitSet2.clone();
        intersect2And3.and(OpenBitSet3);
        list.add(OpenBitSet1);
        list.add(OpenBitSet2);
        list.add(OpenBitSet3);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique jtNode = jtBuilder.junctionTree(list, false).getRoot();
        Assertions.assertThat((Object)jtNode.getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((int)jtNode.getChildren().size()).isEqualTo(2);
        JunctionTreeSeparator sep = (JunctionTreeSeparator)jtNode.getChildren().get(0);
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((Object)sep.getChild().getBitSet()).isEqualTo((Object)OpenBitSet2);
        Assertions.assertThat((int)sep.getChild().getChildren().size()).isEqualTo(0);
        sep = (JunctionTreeSeparator)jtNode.getChildren().get(1);
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((Object)sep.getChild().getBitSet()).isEqualTo((Object)OpenBitSet3);
        Assertions.assertThat((int)sep.getChild().getChildren().size()).isEqualTo(0);
    }

    @Test
    public void testJunctionWithPruning2() {
        JunctionTreeClique jtNode;
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        ArrayList<OpenBitSet> list = new ArrayList<OpenBitSet>();
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00001111");
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00111100");
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("11100000");
        OpenBitSet OpenBitSet4 = GraphTest.bitSet("00100001");
        OpenBitSet intersect1And2 = OpenBitSet2.clone();
        intersect1And2.and(OpenBitSet1);
        OpenBitSet intersect2And3 = OpenBitSet2.clone();
        intersect2And3.and(OpenBitSet3);
        OpenBitSet intersect1And4 = OpenBitSet1.clone();
        intersect1And4.and(OpenBitSet4);
        list.add(OpenBitSet1);
        list.add(OpenBitSet2);
        list.add(OpenBitSet3);
        list.add(OpenBitSet4);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique root = jtNode = jtBuilder.junctionTree(list, false).getRoot();
        Assertions.assertThat((Object)root.getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((int)root.getChildren().size()).isEqualTo(2);
        JunctionTreeSeparator sep = (JunctionTreeSeparator)root.getChildren().get(0);
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((Object)sep.getChild().getBitSet()).isEqualTo((Object)OpenBitSet2);
        Assertions.assertThat((int)sep.getChild().getChildren().size()).isEqualTo(1);
        jtNode = sep.getChild();
        Assertions.assertThat((Object)jtNode.getBitSet()).isEqualTo((Object)OpenBitSet2);
        Assertions.assertThat((int)jtNode.getChildren().size()).isEqualTo(1);
        sep = (JunctionTreeSeparator)jtNode.getChildren().get(0);
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)OpenBitSet2);
        Assertions.assertThat((Object)sep.getChild().getBitSet()).isEqualTo((Object)OpenBitSet3);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)intersect2And3);
        Assertions.assertThat((int)sep.getChild().getChildren().size()).isEqualTo(0);
        sep = (JunctionTreeSeparator)root.getChildren().get(1);
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((Object)sep.getChild().getBitSet()).isEqualTo((Object)OpenBitSet4);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)intersect1And4);
        Assertions.assertThat((int)sep.getChild().getChildren().size()).isEqualTo(0);
    }

    @Test
    public void testJunctionWithPruning3() {
        JunctionTreeClique jtNode;
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        ArrayList<OpenBitSet> list = new ArrayList<OpenBitSet>();
        OpenBitSet OpenBitSet1 = GraphTest.bitSet("00001111");
        OpenBitSet OpenBitSet2 = GraphTest.bitSet("00011110");
        OpenBitSet OpenBitSet3 = GraphTest.bitSet("11100000");
        OpenBitSet OpenBitSet4 = GraphTest.bitSet("01100001");
        OpenBitSet intersect1And2 = OpenBitSet2.clone();
        intersect1And2.and(OpenBitSet1);
        OpenBitSet intersect2And3 = OpenBitSet2.clone();
        intersect2And3.and(OpenBitSet3);
        OpenBitSet intersect1And4 = OpenBitSet1.clone();
        intersect1And4.and(OpenBitSet4);
        OpenBitSet intersect3And4 = OpenBitSet3.clone();
        intersect3And4.and(OpenBitSet4);
        list.add(OpenBitSet1);
        list.add(OpenBitSet2);
        list.add(OpenBitSet3);
        list.add(OpenBitSet4);
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique root = jtNode = jtBuilder.junctionTree(list, false).getRoot();
        Assertions.assertThat((Object)root.getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((int)root.getChildren().size()).isEqualTo(2);
        JunctionTreeSeparator sep = (JunctionTreeSeparator)root.getChildren().get(0);
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((Object)sep.getChild().getBitSet()).isEqualTo((Object)OpenBitSet2);
        Assertions.assertThat((int)sep.getChild().getChildren().size()).isEqualTo(0);
        sep = (JunctionTreeSeparator)root.getChildren().get(1);
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)OpenBitSet1);
        Assertions.assertThat((Object)sep.getChild().getBitSet()).isEqualTo((Object)OpenBitSet4);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)intersect1And4);
        Assertions.assertThat((int)sep.getChild().getChildren().size()).isEqualTo(1);
        jtNode = sep.getChild();
        Assertions.assertThat((Object)jtNode.getBitSet()).isEqualTo((Object)OpenBitSet4);
        Assertions.assertThat((int)jtNode.getChildren().size()).isEqualTo(1);
        sep = (JunctionTreeSeparator)jtNode.getChildren().get(0);
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)OpenBitSet4);
        Assertions.assertThat((Object)sep.getChild().getBitSet()).isEqualTo((Object)OpenBitSet3);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)intersect3And4);
        Assertions.assertThat((int)sep.getChild().getChildren().size()).isEqualTo(0);
    }

    @Test
    public void testMapNodeToCliques() {
        BayesNetwork graph = new BayesNetwork();
        JunctionTreeBuilder tbuilder = new JunctionTreeBuilder((Graph)graph);
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        OpenBitSet clique0 = GraphTest.bitSet("01010101");
        OpenBitSet clique1 = GraphTest.bitSet("10010001");
        OpenBitSet clique2 = GraphTest.bitSet("10111010");
        OpenBitSet[] nodeToCliques = new OpenBitSet[8];
        tbuilder.mapVarNodeToCliques(nodeToCliques, 0, clique0);
        tbuilder.mapVarNodeToCliques(nodeToCliques, 1, clique1);
        tbuilder.mapVarNodeToCliques(nodeToCliques, 2, clique2);
        Assertions.assertThat((Object)nodeToCliques[0]).isEqualTo((Object)GraphTest.bitSet("011"));
        Assertions.assertThat((Object)nodeToCliques[1]).isEqualTo((Object)GraphTest.bitSet("100"));
        Assertions.assertThat((Object)nodeToCliques[2]).isEqualTo((Object)GraphTest.bitSet("001"));
        Assertions.assertThat((Object)nodeToCliques[3]).isEqualTo((Object)GraphTest.bitSet("100"));
        Assertions.assertThat((Object)nodeToCliques[4]).isEqualTo((Object)GraphTest.bitSet("111"));
        Assertions.assertThat((Object)nodeToCliques[5]).isEqualTo((Object)GraphTest.bitSet("100"));
        Assertions.assertThat((Object)nodeToCliques[6]).isEqualTo((Object)GraphTest.bitSet("001"));
        Assertions.assertThat((Object)nodeToCliques[7]).isEqualTo((Object)GraphTest.bitSet("110"));
    }

    @Test
    public void testMapNodeToClique() {
        BayesNetwork graph = new BayesNetwork();
        JunctionTreeBuilder tbuilder = new JunctionTreeBuilder((Graph)graph);
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x4 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x5 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x6 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x7 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectChildToParents(x1, x2, x3);
        GraphTest.connectChildToParents(x3, x6, x7);
        OpenBitSet clique0 = GraphTest.bitSet("01001110");
        OpenBitSet clique1 = GraphTest.bitSet("11001110");
        OpenBitSet clique2 = GraphTest.bitSet("11101000");
        OpenBitSet clique3 = GraphTest.bitSet("00010011");
        JunctionTreeClique jtNode0 = new JunctionTreeClique(0, (Graph)graph, clique0);
        JunctionTreeClique jtNode1 = new JunctionTreeClique(1, (Graph)graph, clique1);
        JunctionTreeClique jtNode2 = new JunctionTreeClique(2, (Graph)graph, clique2);
        JunctionTreeClique jtNode3 = new JunctionTreeClique(3, (Graph)graph, clique3);
        JunctionTreeClique[] jtNodes = new JunctionTreeClique[]{jtNode0, jtNode1, jtNode2, jtNode3};
        OpenBitSet[] nodeToCliques = new OpenBitSet[8];
        tbuilder.mapVarNodeToCliques(nodeToCliques, 0, clique0);
        tbuilder.mapVarNodeToCliques(nodeToCliques, 1, clique1);
        tbuilder.mapVarNodeToCliques(nodeToCliques, 2, clique2);
        tbuilder.mapVarNodeToCliques(nodeToCliques, 3, clique3);
        tbuilder.mapNodeToCliqueFamily(nodeToCliques, jtNodes);
        Assertions.assertThat((int)((BayesVariable)x0.getContent()).getFamily()).isEqualTo(3);
        Assertions.assertThat((int)((BayesVariable)x1.getContent()).getFamily()).isEqualTo(0);
        Assertions.assertThat((int)((BayesVariable)x2.getContent()).getFamily()).isEqualTo(0);
        Assertions.assertThat((int)((BayesVariable)x3.getContent()).getFamily()).isEqualTo(2);
        Assertions.assertThat((int)((BayesVariable)x4.getContent()).getFamily()).isEqualTo(3);
        Assertions.assertThat((int)((BayesVariable)x5.getContent()).getFamily()).isEqualTo(2);
        Assertions.assertThat((int)((BayesVariable)x6.getContent()).getFamily()).isEqualTo(0);
        Assertions.assertThat((int)((BayesVariable)x7.getContent()).getFamily()).isEqualTo(2);
    }

    @Test
    public void testFullExample1() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> xa = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xb = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xc = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xd = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xe = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xf = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xg = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xh = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(xa, xb, xc);
        GraphTest.connectParentToChildren(xb, xd);
        GraphTest.connectParentToChildren(xc, xe, xg);
        GraphTest.connectParentToChildren(xd, xf);
        GraphTest.connectParentToChildren(xe, xf, xh);
        GraphTest.connectParentToChildren(xg, xh);
        OpenBitSet clique1 = GraphTest.bitSet("00111000");
        OpenBitSet clique2 = GraphTest.bitSet("00011100");
        OpenBitSet clique3 = GraphTest.bitSet("01010100");
        OpenBitSet clique4 = GraphTest.bitSet("11010000");
        OpenBitSet clique5 = GraphTest.bitSet("00001110");
        OpenBitSet clique6 = GraphTest.bitSet("00000111");
        OpenBitSet clique1And2 = GraphTest.bitSet("00011000");
        OpenBitSet clique2And3 = GraphTest.bitSet("00010100");
        OpenBitSet clique2And5 = GraphTest.bitSet("00001100");
        OpenBitSet clique3And4 = GraphTest.bitSet("01010000");
        OpenBitSet clique5And6 = GraphTest.bitSet("00000110");
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique root = jtBuilder.build(false).getRoot();
        Assertions.assertThat((Object)root.getBitSet()).isEqualTo((Object)clique1);
        Assertions.assertThat((int)root.getChildren().size()).isEqualTo(1);
        JunctionTreeSeparator sep = (JunctionTreeSeparator)root.getChildren().get(0);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)clique1And2);
        JunctionTreeClique jtNode2 = sep.getChild();
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)clique1);
        Assertions.assertThat((Object)jtNode2.getBitSet()).isEqualTo((Object)clique2);
        Assertions.assertThat((int)jtNode2.getChildren().size()).isEqualTo(2);
        sep = (JunctionTreeSeparator)jtNode2.getChildren().get(0);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)clique2And3);
        JunctionTreeClique jtNode3 = sep.getChild();
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)clique2);
        Assertions.assertThat((Object)jtNode3.getBitSet()).isEqualTo((Object)clique3);
        Assertions.assertThat((int)jtNode3.getChildren().size()).isEqualTo(1);
        sep = (JunctionTreeSeparator)jtNode3.getChildren().get(0);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)clique3And4);
        JunctionTreeClique jtNode4 = sep.getChild();
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)clique3);
        Assertions.assertThat((Object)jtNode4.getBitSet()).isEqualTo((Object)clique4);
        Assertions.assertThat((int)jtNode4.getChildren().size()).isEqualTo(0);
        sep = (JunctionTreeSeparator)jtNode2.getChildren().get(1);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)clique2And5);
        JunctionTreeClique jtNode5 = sep.getChild();
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)clique2);
        Assertions.assertThat((Object)jtNode5.getBitSet()).isEqualTo((Object)clique5);
        Assertions.assertThat((int)jtNode5.getChildren().size()).isEqualTo(1);
        sep = (JunctionTreeSeparator)jtNode5.getChildren().get(0);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)clique5And6);
        JunctionTreeClique jtNode6 = sep.getChild();
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)clique5);
        Assertions.assertThat((Object)jtNode6.getBitSet()).isEqualTo((Object)clique6);
        Assertions.assertThat((int)jtNode6.getChildren().size()).isEqualTo(0);
    }

    @Test
    public void testFullExample2() {
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> xElectricity = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xTelecom = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xRail = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xAirTravel = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xTransportation = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xUtilities = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xUSBanks = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> xUSStocks = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(xElectricity, xRail, xAirTravel, xUtilities, xTelecom);
        GraphTest.connectParentToChildren(xTelecom, xUtilities, xUSBanks);
        GraphTest.connectParentToChildren(xRail, xTransportation);
        GraphTest.connectParentToChildren(xAirTravel, xTransportation);
        GraphTest.connectParentToChildren(xUtilities, xUSStocks);
        GraphTest.connectParentToChildren(xUSBanks, xUSStocks);
        GraphTest.connectParentToChildren(xTransportation, xUSStocks);
        OpenBitSet clique1 = GraphTest.bitSet("11110000");
        OpenBitSet clique2 = GraphTest.bitSet("01110001");
        OpenBitSet clique3 = GraphTest.bitSet("01100011");
        OpenBitSet clique4 = GraphTest.bitSet("00011101");
        OpenBitSet clique1And2 = GraphTest.bitSet("01110000");
        OpenBitSet clique2And3 = GraphTest.bitSet("01100001");
        OpenBitSet clique2And4 = GraphTest.bitSet("00010001");
        xElectricity.setContent((Object)new BayesVariable("Electricity", xElectricity.getId(), (Object[])new String[]{"Working", "Reduced", "NotWorking"}, (double[][])new double[][]{{0.6, 0.3, 0.099}}));
        xTelecom.setContent((Object)new BayesVariable("Telecom", xTelecom.getId(), (Object[])new String[]{"Working", "Reduced", "NotWorking"}, (double[][])new double[][]{{0.544, 0.304, 0.151}}));
        xRail.setContent((Object)new BayesVariable("Rail", xRail.getId(), (Object[])new String[]{"Working", "Reduced", "NotWorking"}, (double[][])new double[][]{{0.579, 0.23, 0.19}}));
        xAirTravel.setContent((Object)new BayesVariable("AirTravel", xAirTravel.getId(), (Object[])new String[]{"Working", "Reduced", "NotWorking"}, (double[][])new double[][]{{0.449, 0.33, 0.219}}));
        xTransportation.setContent((Object)new BayesVariable("Transportation", xTransportation.getId(), (Object[])new String[]{"Working", "Moderate", "Severe", "Failure"}, (double[][])new double[][]{{0.658, 0.167, 0.097, 0.077}}));
        xUtilities.setContent((Object)new BayesVariable("Utilities", xUtilities.getId(), (Object[])new String[]{"Working", "Moderate", "Severe", "Failure"}, (double[][])new double[][]{{0.541, 0.272, 0.097, 0.088}}));
        xUSBanks.setContent((Object)new BayesVariable("USBanks", xUSBanks.getId(), (Object[])new String[]{"Working", "Reduced", "NotWorking"}, (double[][])new double[][]{{0.488, 0.37, 0.141}}));
        xUSStocks.setContent((Object)new BayesVariable("USStocks", xUSStocks.getId(), (Object[])new String[]{"Up", "Down", "Crash"}, (double[][])new double[][]{{0.433, 0.386, 0.179}}));
        JunctionTreeBuilder jtBuilder = new JunctionTreeBuilder((Graph)graph);
        JunctionTreeClique root = jtBuilder.build(false).getRoot();
        Assertions.assertThat((Object)root.getBitSet()).isEqualTo((Object)clique1);
        Assertions.assertThat((int)root.getChildren().size()).isEqualTo(1);
        JunctionTreeSeparator sep = (JunctionTreeSeparator)root.getChildren().get(0);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)clique1And2);
        JunctionTreeClique jtNode2 = sep.getChild();
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)clique1);
        Assertions.assertThat((Object)jtNode2.getBitSet()).isEqualTo((Object)clique2);
        Assertions.assertThat((int)jtNode2.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((Object)jtNode2.getParentSeparator()).isSameAs((Object)sep);
        sep = (JunctionTreeSeparator)jtNode2.getChildren().get(0);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)clique2And3);
        JunctionTreeClique jtNode3 = sep.getChild();
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)clique2);
        Assertions.assertThat((Object)jtNode3.getBitSet()).isEqualTo((Object)clique3);
        Assertions.assertThat((int)jtNode3.getChildren().size()).isEqualTo(0);
        sep = (JunctionTreeSeparator)jtNode2.getChildren().get(1);
        Assertions.assertThat((Object)sep.getBitSet()).isEqualTo((Object)clique2And4);
        JunctionTreeClique jtNode4 = sep.getChild();
        Assertions.assertThat((Object)sep.getParent().getBitSet()).isEqualTo((Object)clique2);
        Assertions.assertThat((Object)jtNode4.getBitSet()).isEqualTo((Object)clique4);
        Assertions.assertThat((int)jtNode4.getChildren().size()).isEqualTo(0);
    }
}

