/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.JunctionTreeBuilder;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.drools.beliefs.graph.impl.EdgeImpl;
import org.drools.core.util.bitmask.OpenBitSet;

public class GraphTest {
    public static void connectParentToChildren(GraphNode parent, GraphNode ... children) {
        for (GraphNode child : children) {
            EdgeImpl e = new EdgeImpl();
            e.setOutGraphNode(parent);
            e.setInGraphNode(child);
        }
    }

    public static void connectChildToParents(GraphNode child, GraphNode ... parents) {
        for (GraphNode parent : parents) {
            EdgeImpl e = new EdgeImpl();
            e.setOutGraphNode(parent);
            e.setInGraphNode(child);
        }
    }

    public static boolean assertLinkedNode(JunctionTreeBuilder graph, int ... ints) {
        return GraphTest.assertLinkedVertex(graph.getAdjacencyMatrix(), ints);
    }

    public static boolean assertLinkedVertex(boolean[][] adjMatrix, int ... ints) {
        int id = ints[0];
        List adjVert = JunctionTreeBuilder.getAdjacentVertices((boolean[][])adjMatrix, (int)id);
        Assertions.assertThat((int)adjVert.size()).isEqualTo(ints.length - 1);
        for (int i = 1; i < ints.length; ++i) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)adjMatrix[id][ints[i]]).as("link was not true " + id + ", " + i, new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)adjMatrix[ints[i]][id]).as("link was not true " + i + ", " + id, new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)adjVert.contains(ints[i])).as("does not contain " + ints[i], new Object[0])).isTrue();
        }
        return false;
    }

    public static GraphNode<BayesVariable> addNode(Graph<BayesVariable> graph) {
        GraphNode x = graph.addNode();
        x.setContent((Object)new BayesVariable("x" + x.getId(), x.getId(), (Object[])new String[]{"a", "b"}, (double[][])new double[][]{{0.1, 0.1}}));
        return x;
    }

    public static List asList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static OpenBitSet bitSet(String s) {
        OpenBitSet bitSet = new OpenBitSet();
        bitSet.setBits(new long[]{Long.valueOf(s, 2)});
        return bitSet;
    }
}

