/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.beliefs.bayes.BayesInstance;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.CliqueState;
import org.drools.beliefs.bayes.GlobalUpdateListener;
import org.drools.beliefs.bayes.GraphTest;
import org.drools.beliefs.bayes.JunctionTree;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.PassMessageListener;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.junit.Before;
import org.junit.Test;

public class GlobalUpdateTest {
    Graph<BayesVariable> graph = new BayesNetwork();
    GraphNode x0 = GraphTest.addNode(this.graph);
    JunctionTreeClique n0 = new JunctionTreeClique(0, this.graph, GraphTest.bitSet("1"));
    JunctionTreeClique n1 = new JunctionTreeClique(1, this.graph, GraphTest.bitSet("1"));
    JunctionTreeClique n2 = new JunctionTreeClique(2, this.graph, GraphTest.bitSet("1"));
    JunctionTreeClique n3 = new JunctionTreeClique(3, this.graph, GraphTest.bitSet("1"));
    JunctionTreeClique n4 = new JunctionTreeClique(4, this.graph, GraphTest.bitSet("1"));
    JunctionTreeClique n5 = new JunctionTreeClique(5, this.graph, GraphTest.bitSet("1"));
    JunctionTreeClique n6 = new JunctionTreeClique(6, this.graph, GraphTest.bitSet("1"));
    JunctionTreeClique n7 = new JunctionTreeClique(7, this.graph, GraphTest.bitSet("1"));
    JunctionTreeClique n8 = new JunctionTreeClique(8, this.graph, GraphTest.bitSet("1"));
    JunctionTree tree;
    BayesInstance bayesInstance;
    final List<String> messageResults = new ArrayList<String>();
    final List<String> globalUpdateResults = new ArrayList<String>();

    @Before
    public void startUp() {
        boolean i = false;
        ArrayList list = new ArrayList();
        this.connectChildren(this.graph, this.n0, list, this.n1);
        this.connectChildren(this.graph, this.n1, list, this.n2, this.n5);
        this.connectChildren(this.graph, this.n2, list, this.n3, this.n4);
        this.connectChildren(this.graph, this.n5, list, this.n6);
        this.connectChildren(this.graph, this.n6, list, this.n7, this.n8);
        this.tree = new JunctionTree(this.graph, this.n0, new JunctionTreeClique[]{this.n0, this.n1, this.n2, this.n3, this.n4, this.n5, this.n6, this.n7, this.n8}, list.toArray(new JunctionTreeSeparator[list.size()]));
        this.bayesInstance = new BayesInstance(this.tree);
        this.bayesInstance.setPassMessageListener(new PassMessageListener(){

            public void beforeProjectAndAbsorb(JunctionTreeClique sourceNode, JunctionTreeSeparator sep, JunctionTreeClique targetNode, double[] oldSeparatorPotentials) {
                GlobalUpdateTest.this.messageResults.add(sourceNode.getId() + ":" + targetNode.getId());
            }

            public void afterProject(JunctionTreeClique sourceNode, JunctionTreeSeparator sep, JunctionTreeClique targetNode, double[] oldSeparatorPotentials) {
            }

            public void afterAbsorb(JunctionTreeClique sourceNode, JunctionTreeSeparator sep, JunctionTreeClique targetNode, double[] oldSeparatorPotentials) {
            }
        });
        this.bayesInstance.setGlobalUpdateListener(new GlobalUpdateListener(){

            public void beforeGlobalUpdate(CliqueState clique) {
                GlobalUpdateTest.this.globalUpdateResults.add("" + clique.getJunctionTreeClique().getId());
            }

            public void afterGlobalUpdate(CliqueState clique) {
            }
        });
    }

    @Test
    public void testCollectFromRootClique() {
        this.bayesInstance.collectEvidence(this.n0);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("3:2", "4:2", "2:1", "7:6", "8:6", "6:5", "5:1", "1:0"));
    }

    @Test
    public void testCollectFromMidTipClique() {
        this.bayesInstance.collectEvidence(this.n4);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("0:1", "7:6", "8:6", "6:5", "5:1", "1:2", "3:2", "2:4"));
    }

    @Test
    public void testCollectFromEndTipClique() {
        this.bayesInstance.collectEvidence(this.n7);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("0:1", "3:2", "4:2", "2:1", "1:5", "5:6", "8:6", "6:7"));
    }

    @Test
    public void testCollectFromMidClique() {
        this.bayesInstance.collectEvidence(this.n5);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("0:1", "3:2", "4:2", "2:1", "1:5", "7:6", "8:6", "6:5"));
    }

    @Test
    public void testDistributeFromRootClique() {
        this.bayesInstance.distributeEvidence(this.n0);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("0:1", "1:2", "2:3", "2:4", "1:5", "5:6", "6:7", "6:8"));
    }

    @Test
    public void testDistributeFromMidTipClique() {
        this.bayesInstance.distributeEvidence(this.n4);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("4:2", "2:1", "1:0", "1:5", "5:6", "6:7", "6:8", "2:3"));
    }

    @Test
    public void testDistributeFromEndTipClique() {
        this.bayesInstance.distributeEvidence(this.n7);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("7:6", "6:5", "5:1", "1:0", "1:2", "2:3", "2:4", "6:8"));
    }

    @Test
    public void testDistributeFromMidClique() {
        this.bayesInstance.distributeEvidence(this.n5);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("5:1", "1:0", "1:2", "2:3", "2:4", "5:6", "6:7", "6:8"));
    }

    @Test
    public void testGlobalUpdateFromRootClique() {
        this.bayesInstance.globalUpdate(this.n0);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("3:2", "4:2", "2:1", "7:6", "8:6", "6:5", "5:1", "1:0", "0:1", "1:2", "2:3", "2:4", "1:5", "5:6", "6:7", "6:8"));
        Assertions.assertThat(this.globalUpdateResults).isEqualTo((Object)this.asList("0"));
    }

    @Test
    public void testGlobalUpdateFromMidTipClique() {
        this.bayesInstance.globalUpdate(this.n4);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("0:1", "7:6", "8:6", "6:5", "5:1", "1:2", "3:2", "2:4", "4:2", "2:1", "1:0", "1:5", "5:6", "6:7", "6:8", "2:3"));
        Assertions.assertThat(this.globalUpdateResults).isEqualTo((Object)this.asList("4"));
    }

    @Test
    public void testGlobalUpdateFromEndTipClique() {
        this.bayesInstance.globalUpdate(this.n7);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("0:1", "3:2", "4:2", "2:1", "1:5", "5:6", "8:6", "6:7", "7:6", "6:5", "5:1", "1:0", "1:2", "2:3", "2:4", "6:8"));
        Assertions.assertThat(this.globalUpdateResults).isEqualTo((Object)this.asList("7"));
    }

    @Test
    public void testGlobalUpdateFromMidClique() {
        this.bayesInstance.globalUpdate(this.n5);
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("0:1", "3:2", "4:2", "2:1", "1:5", "7:6", "8:6", "6:5", "5:1", "1:0", "1:2", "2:3", "2:4", "5:6", "6:7", "6:8"));
        Assertions.assertThat(this.globalUpdateResults).isEqualTo((Object)this.asList("5"));
    }

    @Test
    public void testDistributeFromGlobalUpdate() {
        this.bayesInstance.globalUpdate();
        Assertions.assertThat(this.messageResults).isEqualTo((Object)this.asList("3:2", "4:2", "2:1", "7:6", "8:6", "6:5", "5:1", "1:0", "0:1", "1:2", "2:3", "2:4", "1:5", "5:6", "6:7", "6:8"));
        Assertions.assertThat(this.globalUpdateResults).isEqualTo((Object)this.asList("0"));
    }

    public void testGlobalUpdate() {
        this.bayesInstance.globalUpdate();
    }

    public List asList(String ... items) {
        return Arrays.asList(items);
    }

    public void connectChildren(Graph<BayesVariable> graph, JunctionTreeClique parent, List list, JunctionTreeClique ... children) {
        for (JunctionTreeClique child : children) {
            list.add(new JunctionTreeSeparator(list.size(), parent, child, GraphTest.bitSet("0"), graph));
        }
    }
}

