/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.math.BigDecimal;
import java.util.Arrays;
import junit.framework.AssertionFailedError;
import org.assertj.core.api.Assertions;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.GraphTest;
import org.drools.beliefs.bayes.JunctionTree;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.PotentialMultiplier;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.drools.util.bitmask.OpenBitSet;
import org.junit.Test;

public class JunctionTreeTest {
    @Test
    public void testIndextoKeyMapping1() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, null);
        BayesVariable b = new BayesVariable("B", 0, (Object[])new String[]{"B1", "B2"}, null);
        BayesVariable[] vars = new BayesVariable[]{a, b};
        int numberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])vars);
        int[] indexMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])vars, (int)numberOfStates);
        Assertions.assertThat((int)numberOfStates).isEqualTo(4);
        JunctionTreeTest.assertIndexToKeyMapping(numberOfStates, indexMultipliers);
    }

    @Test
    public void testIndextoKeyMapping2() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2", "A3"}, null);
        BayesVariable b = new BayesVariable("B", 0, (Object[])new String[]{"B1", "B2", "B3"}, null);
        BayesVariable[] vars = new BayesVariable[]{a, b};
        int numberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])vars);
        int[] indexMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])vars, (int)numberOfStates);
        Assertions.assertThat((int)numberOfStates).isEqualTo(9);
        JunctionTreeTest.assertIndexToKeyMapping(numberOfStates, indexMultipliers);
    }

    @Test
    public void testIndextoKeyMapping3() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2", "A3"}, null);
        BayesVariable b = new BayesVariable("B", 0, (Object[])new String[]{"B1", "B2", "B3"}, null);
        BayesVariable c = new BayesVariable("C", 0, (Object[])new String[]{"C1", "C2", "C3", "C4"}, null);
        BayesVariable d = new BayesVariable("D", 0, (Object[])new String[]{"D1", "D2", "D3"}, null);
        BayesVariable[] vars = new BayesVariable[]{a, b, c, d};
        int numberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])vars);
        int[] indexMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])vars, (int)numberOfStates);
        Assertions.assertThat((int)numberOfStates).isEqualTo(108);
        JunctionTreeTest.assertIndexToKeyMapping(numberOfStates, indexMultipliers);
    }

    @Test
    public void testPotentialMultiplication1() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, null);
        BayesVariable b = new BayesVariable("B", 0, (Object[])new String[]{"B1", "B2"}, (double[][])new double[][]{{0.1, 0.2}, {0.3, 0.4}});
        BayesVariable[] vars = new BayesVariable[]{a, b};
        int numberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])vars);
        int[] multipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])vars, (int)numberOfStates);
        Assertions.assertThat((int)numberOfStates).isEqualTo(4);
        JunctionTreeTest.assertIndexToKeyMapping(numberOfStates, multipliers);
        double[] potentials = new double[numberOfStates];
        Arrays.fill(potentials, 1.0);
        BayesVariable[] parents = new BayesVariable[]{a};
        int[] parentVarPos = PotentialMultiplier.createSubsetVarPos((BayesVariable[])vars, (BayesVariable[])parents);
        int parentsNumberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])parents);
        int[] parentIndexMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])parents, (int)parentsNumberOfStates);
        PotentialMultiplier m = new PotentialMultiplier(b.getProbabilityTable(), 1, parentVarPos, parentIndexMultipliers, vars, multipliers, potentials);
        m.multiple();
        JunctionTreeTest.assertArray(new double[]{0.1, 0.2, 0.3, 0.4}, potentials);
        m.multiple();
        JunctionTreeTest.assertArray(new double[]{0.01, 0.04, 0.09, 0.16}, JunctionTreeTest.scaleDouble(3, potentials));
    }

    @Test
    public void testPotentialMultiplication2() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, null);
        BayesVariable b = new BayesVariable("B", 0, (Object[])new String[]{"B1", "B2"}, null);
        BayesVariable c = new BayesVariable("C", 0, (Object[])new String[]{"C1", "C2"}, (double[][])new double[][]{{0.1, 0.2}, {0.3, 0.4}, {0.5, 0.6}, {0.7, 0.8}});
        BayesVariable d = new BayesVariable("D", 0, (Object[])new String[]{"D1", "D2"}, null);
        BayesVariable[] vars = new BayesVariable[]{a, b, c, d};
        int numberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])vars);
        int[] multipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])vars, (int)numberOfStates);
        Assertions.assertThat((int)numberOfStates).isEqualTo(16);
        JunctionTreeTest.assertIndexToKeyMapping(numberOfStates, multipliers);
        double[] potentials = new double[numberOfStates];
        Arrays.fill(potentials, 1.0);
        BayesVariable[] parents = new BayesVariable[]{a, b};
        int[] parentVarPos = PotentialMultiplier.createSubsetVarPos((BayesVariable[])vars, (BayesVariable[])parents);
        int parentsNumberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])parents);
        int[] parentIndexMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])parents, (int)parentsNumberOfStates);
        PotentialMultiplier m = new PotentialMultiplier(c.getProbabilityTable(), 2, parentVarPos, parentIndexMultipliers, vars, multipliers, potentials);
        m.multiple();
        JunctionTreeTest.assertArray(new double[]{0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5, 0.5, 0.6, 0.6, 0.7, 0.7, 0.8, 0.8}, JunctionTreeTest.scaleDouble(3, potentials));
        m.multiple();
        JunctionTreeTest.assertArray(new double[]{0.01, 0.01, 0.04, 0.04, 0.09, 0.09, 0.16, 0.16, 0.25, 0.25, 0.36, 0.36, 0.49, 0.49, 0.64, 0.64}, JunctionTreeTest.scaleDouble(3, potentials));
    }

    @Test
    public void testPotentialMultiplication3() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, null);
        BayesVariable b = new BayesVariable("B", 0, (Object[])new String[]{"B1", "B2"}, null);
        BayesVariable c = new BayesVariable("C", 0, (Object[])new String[]{"C1", "C2"}, (double[][])new double[][]{{0.1, 0.2}, {0.3, 0.4}, {0.5, 0.6}, {0.7, 0.8}});
        BayesVariable d = new BayesVariable("D", 0, (Object[])new String[]{"D1", "D2"}, null);
        BayesVariable[] vars = new BayesVariable[]{a, b, c, d};
        int numberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])vars);
        int[] multipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])vars, (int)numberOfStates);
        Assertions.assertThat((int)numberOfStates).isEqualTo(16);
        JunctionTreeTest.assertIndexToKeyMapping(numberOfStates, multipliers);
        double[] potentials = new double[numberOfStates];
        Arrays.fill(potentials, 1.0);
        BayesVariable[] parents = new BayesVariable[]{b, d};
        int[] parentVarPos = PotentialMultiplier.createSubsetVarPos((BayesVariable[])vars, (BayesVariable[])parents);
        int parentsNumberOfStates = PotentialMultiplier.createNumberOfStates((BayesVariable[])parents);
        int[] parentIndexMultipliers = PotentialMultiplier.createIndexMultipliers((BayesVariable[])parents, (int)parentsNumberOfStates);
        PotentialMultiplier m = new PotentialMultiplier(c.getProbabilityTable(), 2, parentVarPos, parentIndexMultipliers, vars, multipliers, potentials);
        m.multiple();
        JunctionTreeTest.assertArray(new double[]{0.1, 0.3, 0.2, 0.4, 0.5, 0.7, 0.6, 0.8, 0.1, 0.3, 0.2, 0.4, 0.5, 0.7, 0.6, 0.8}, potentials);
        m.multiple();
        JunctionTreeTest.assertArray(new double[]{0.01, 0.09, 0.04, 0.16, 0.25, 0.49, 0.36, 0.64, 0.01, 0.09, 0.04, 0.16, 0.25, 0.49, 0.36, 0.64}, JunctionTreeTest.scaleDouble(3, potentials));
    }

    @Test
    public void testJunctionTreeInitialisation() {
        BayesVariable a = new BayesVariable("A", 0, (Object[])new String[]{"A1", "A2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesVariable b = new BayesVariable("B", 1, (Object[])new String[]{"B1", "B2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesVariable c = new BayesVariable("C", 2, (Object[])new String[]{"C1", "C2"}, (double[][])new double[][]{{0.1, 0.2}});
        BayesVariable d = new BayesVariable("D", 3, (Object[])new String[]{"D1", "D2"}, (double[][])new double[][]{{0.1, 0.2}, {0.3, 0.4}});
        BayesNetwork graph = new BayesNetwork();
        GraphNode<BayesVariable> x0 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x1 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x2 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphNode<BayesVariable> x3 = GraphTest.addNode((Graph<BayesVariable>)graph);
        GraphTest.connectParentToChildren(x2, x3);
        x0.setContent((Object)a);
        x1.setContent((Object)b);
        x2.setContent((Object)c);
        x3.setContent((Object)d);
        JunctionTreeClique node1 = new JunctionTreeClique(0, (Graph)graph, GraphTest.bitSet("0011"));
        JunctionTreeClique node2 = new JunctionTreeClique(1, (Graph)graph, GraphTest.bitSet("1100"));
        new JunctionTreeSeparator(0, node1, node2, new OpenBitSet(), (Graph)graph);
        node1.addToFamily(b);
        b.setFamily(node1.getId());
        node2.addToFamily(c);
        c.setFamily(node2.getId());
        node2.addToFamily(d);
        d.setFamily(node2.getId());
        JunctionTree jtree = new JunctionTree((Graph)graph, node1, new JunctionTreeClique[]{node1, node2}, null);
        JunctionTreeTest.assertArray(new double[]{0.1, 0.2, 0.1, 0.2}, JunctionTreeTest.scaleDouble(3, node1.getPotentials()));
        JunctionTreeTest.assertArray(new double[]{0.01, 0.02, 0.06, 0.08}, JunctionTreeTest.scaleDouble(3, node2.getPotentials()));
    }

    public static void assertArray(double[] expected, double[] actual) {
        if (!Arrays.equals(expected, actual)) {
            int i;
            System.err.print("expected ");
            for (i = 0; i < expected.length; ++i) {
                System.err.format("%.7f ", expected[i]);
            }
            System.err.println();
            System.err.print("actual ");
            for (i = 0; i < actual.length; ++i) {
                System.err.format("%.7f ", actual[i]);
            }
            System.err.println();
            throw new AssertionFailedError("Arrays are not Equal");
        }
    }

    public static void assertIndexToKeyMapping(int numberOfStates, int[] indexMultipliers) {
        for (int i = 0; i < numberOfStates; ++i) {
            int[] key = PotentialMultiplier.indexToKey((int)i, (int[])indexMultipliers);
            int index = PotentialMultiplier.keyToIndex((int[])key, (int[])indexMultipliers);
            Assertions.assertThat((int)index).isEqualTo(i);
        }
    }

    public static double scaleDouble(int scale, double d) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }

    public static double[] scaleDouble(int scale, double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = JunctionTreeTest.scaleDouble(scale, array[i]);
        }
        return array;
    }
}

