/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes.integration;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.model.Bif;
import org.drools.beliefs.bayes.model.Definition;
import org.drools.beliefs.bayes.model.Network;
import org.drools.beliefs.bayes.model.Variable;
import org.drools.beliefs.bayes.model.XmlBifParser;
import org.drools.beliefs.graph.GraphNode;
import org.junit.Test;

public class ParserTest {
    @Test
    public void testSprinklerLoadBif() {
        Bif bif = XmlBifParser.loadBif((URL)ParserTest.class.getResource("Garden.xmlbif"));
        Network network = bif.getNetwork();
        Assertions.assertThat((String)network.getName()).isEqualTo("Garden");
        Assertions.assertThat((String)((String)network.getProperties().get(0))).isEqualTo("package = org.drools.beliefs.bayes.integration");
        Map<String, Variable> varMap = this.varToMap(network.getVariables());
        Assertions.assertThat((int)varMap.size()).isEqualTo(4);
        Variable var = varMap.get("WetGrass");
        Assertions.assertThat((String)var.getName()).isEqualTo("WetGrass");
        Assertions.assertThat((int)var.getOutComes().size()).isEqualTo(2);
        Assertions.assertThat(Arrays.asList("false", "true")).isEqualTo((Object)var.getOutComes());
        Assertions.assertThat((String)((String)var.getProperties().get(0))).isEqualTo("position = (0,10)");
        var = varMap.get("Cloudy");
        Assertions.assertThat((String)var.getName()).isEqualTo("Cloudy");
        Assertions.assertThat((int)var.getOutComes().size()).isEqualTo(2);
        Assertions.assertThat(Arrays.asList("false", "true")).isEqualTo((Object)var.getOutComes());
        Assertions.assertThat((String)((String)var.getProperties().get(0))).isEqualTo("position = (0,-10)");
        var = varMap.get("Sprinkler");
        Assertions.assertThat((String)var.getName()).isEqualTo("Sprinkler");
        Assertions.assertThat((int)var.getOutComes().size()).isEqualTo(2);
        Assertions.assertThat(Arrays.asList("false", "true")).isEqualTo((Object)var.getOutComes());
        Assertions.assertThat((String)((String)var.getProperties().get(0))).isEqualTo("position = (13,0)");
        var = varMap.get("Rain");
        Assertions.assertThat((String)var.getName()).isEqualTo("Rain");
        Assertions.assertThat((int)var.getOutComes().size()).isEqualTo(2);
        Assertions.assertThat(Arrays.asList("false", "true")).isEqualTo((Object)var.getOutComes());
        Assertions.assertThat((String)((String)var.getProperties().get(0))).isEqualTo("position = (-12,0)");
        Map<String, Definition> defMap = this.defToMap(network.getDefinitions());
        Assertions.assertThat((int)defMap.size()).isEqualTo(4);
        Definition def = defMap.get("WetGrass");
        Assertions.assertThat((String)def.getName()).isEqualTo("WetGrass");
        Assertions.assertThat((int)def.getGiven().size()).isEqualTo(2);
        Assertions.assertThat(Arrays.asList("Sprinkler", "Rain")).isEqualTo((Object)def.getGiven());
        Assertions.assertThat((String)def.getProbabilities()).isEqualTo("1.0 0.0 0.1 0.9 0.1 0.9 0.01 0.99");
        def = defMap.get("Cloudy");
        Assertions.assertThat((String)def.getName()).isEqualTo("Cloudy");
        Assertions.assertThat((List)def.getGiven()).isNull();
        Assertions.assertThat((String)def.getProbabilities().trim()).isEqualTo("0.5 0.5");
        def = defMap.get("Sprinkler");
        Assertions.assertThat((String)def.getName()).isEqualTo("Sprinkler");
        Assertions.assertThat((int)def.getGiven().size()).isEqualTo(1);
        Assertions.assertThat((String)((String)def.getGiven().get(0))).isEqualTo("Cloudy");
        Assertions.assertThat((String)def.getProbabilities().trim()).isEqualTo("0.5 0.5 0.9 0.1");
        def = defMap.get("Rain");
        Assertions.assertThat((String)def.getName()).isEqualTo("Rain");
        Assertions.assertThat((List)def.getGiven()).isNull();
        Assertions.assertThat((String)def.getProbabilities().trim()).isEqualTo("0.5 0.5");
    }

    @Test
    public void testSprinklerBuildBayesNework() {
        Bif bif = XmlBifParser.loadBif((URL)ParserTest.class.getResource("Garden.xmlbif"));
        BayesNetwork network = XmlBifParser.buildBayesNetwork((Bif)bif);
        Map<String, GraphNode<BayesVariable>> map = this.nodeToMap(network);
        GraphNode<BayesVariable> node = map.get("WetGrass");
        BayesVariable wetGrass = (BayesVariable)node.getContent();
        Assertions.assertThat(Arrays.asList(wetGrass.getOutcomes())).isEqualTo(Arrays.asList("false", "true"));
        Assertions.assertThat((int)wetGrass.getGiven().length).isEqualTo(2);
        Assertions.assertThat(Arrays.asList("Sprinkler", "Rain")).isEqualTo(Arrays.asList(wetGrass.getGiven()));
        Assertions.assertThat((boolean)Arrays.deepEquals((Object[])new double[][]{{1.0, 0.0}, {0.1, 0.9}, {0.1, 0.9}, {0.01, 0.99}}, (Object[])wetGrass.getProbabilityTable())).isTrue();
        node = map.get("Sprinkler");
        BayesVariable sprinkler = (BayesVariable)node.getContent();
        Assertions.assertThat(Arrays.asList(sprinkler.getOutcomes())).isEqualTo(Arrays.asList("false", "true"));
        Assertions.assertThat((int)sprinkler.getGiven().length).isEqualTo(1);
        Assertions.assertThat((String)sprinkler.getGiven()[0]).isEqualTo("Cloudy");
        Assertions.assertThat((boolean)Arrays.deepEquals((Object[])new double[][]{{0.5, 0.5}, {0.9, 0.1}}, (Object[])sprinkler.getProbabilityTable())).isTrue();
        node = map.get("Cloudy");
        BayesVariable cloudy = (BayesVariable)node.getContent();
        Assertions.assertThat(Arrays.asList(cloudy.getOutcomes())).isEqualTo(Arrays.asList("false", "true"));
        Assertions.assertThat((int)cloudy.getGiven().length).isEqualTo(0);
        Assertions.assertThat((boolean)Arrays.deepEquals((Object[])new double[][]{{0.5, 0.5}}, (Object[])cloudy.getProbabilityTable())).isTrue();
        node = map.get("Rain");
        BayesVariable rain = (BayesVariable)node.getContent();
        Assertions.assertThat(Arrays.asList(rain.getOutcomes())).isEqualTo(Arrays.asList("false", "true"));
        Assertions.assertThat((int)rain.getGiven().length).isEqualTo(0);
        Assertions.assertThat((boolean)Arrays.deepEquals((Object[])new double[][]{{0.5, 0.5}}, (Object[])rain.getProbabilityTable())).isTrue();
    }

    Map<String, GraphNode<BayesVariable>> nodeToMap(BayesNetwork network) {
        HashMap<String, GraphNode<BayesVariable>> map = new HashMap<String, GraphNode<BayesVariable>>();
        for (GraphNode node : network) {
            map.put(((BayesVariable)node.getContent()).getName(), (GraphNode<BayesVariable>)node);
        }
        return map;
    }

    public Map<String, Variable> varToMap(List<Variable> list) {
        HashMap<String, Variable> map = new HashMap<String, Variable>();
        for (Variable var : list) {
            map.put(var.getName(), var);
        }
        return map;
    }

    public Map<String, Definition> defToMap(List<Definition> list) {
        HashMap<String, Definition> map = new HashMap<String, Definition>();
        for (Definition def : list) {
            map.put(def.getName(), def);
        }
        return map;
    }
}

