/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark;

import org.drools.benchmark.BenchmarkDefinition;

public class BenchmarkResult {
    private final BenchmarkDefinition definition;
    private long duration;
    private long usedMemoryBeforeStart;
    private long usedMemoryAfterEnd;
    private long usedMemoryAfterGC;

    public BenchmarkResult(BenchmarkDefinition definition) {
        this.definition = definition;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getUsedMemoryBeforeStart() {
        return this.usedMemoryBeforeStart;
    }

    public void setUsedMemoryBeforeStart(long usedMemoryBeforeStart) {
        this.usedMemoryBeforeStart = usedMemoryBeforeStart;
    }

    public long getUsedMemoryAfterEnd() {
        return this.usedMemoryAfterEnd;
    }

    public void setUsedMemoryAfterEnd(long usedMemoryAfterEnd) {
        this.usedMemoryAfterEnd = usedMemoryAfterEnd;
    }

    public long getUsedMemoryAfterGC() {
        return this.usedMemoryAfterGC;
    }

    public void setUsedMemoryAfterGC(long usedMemoryAfterGC) {
        this.usedMemoryAfterGC = usedMemoryAfterGC;
    }

    public long memoryUsedByBenchmark() {
        return this.usedMemoryAfterEnd - this.usedMemoryBeforeStart;
    }

    public long unfreedMemory() {
        return Math.max(0L, this.usedMemoryAfterGC - this.usedMemoryBeforeStart);
    }

    public String getDescription() {
        return this.definition.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("*** Execution of " + this.definition + "\n");
        sb.append("Done in " + this.duration + " msecs\n");
        sb.append("Memory used by benchmark " + this.memoryUsedByBenchmark() + " bytes\n");
        sb.append("Memory unfreed after benchmark run " + this.unfreedMemory() + " bytes\n");
        return sb.toString();
    }
}

