/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class InsertAndRetractInTurn
extends AbstractBenchmark {
    private static KieSession ksession;
    private String[] drlFiles;
    private final int objectsNumber;

    public InsertAndRetractInTurn(int objectsNumber) {
        this.objectsNumber = objectsNumber;
    }

    public InsertAndRetractInTurn(int objectsNumber, String drlFile) {
        this(objectsNumber);
        this.drlFiles = drlFile.split(",");
    }

    @Override
    public void init(BenchmarkDefinition definition, boolean isFirst) {
        if (isFirst) {
            KieBase kbase = this.createKnowledgeBase(this.createKnowledgeBuilder(this.drlFiles));
            ksession = kbase.newKieSession();
        }
    }

    @Override
    public void execute(int repNr) {
        for (int i = 0; i < this.objectsNumber; ++i) {
            FactHandle fact = ksession.insert((Object)new Integer(i));
            ksession.fireAllRules();
            ksession.retract(fact);
            ksession.fireAllRules();
        }
    }

    @Override
    public void terminate(boolean isLast) {
        if (isLast) {
            ksession.dispose();
        }
    }

    @Override
    public InsertAndRetractInTurn clone() {
        InsertAndRetractInTurn clone = new InsertAndRetractInTurn(this.objectsNumber);
        clone.drlFiles = this.drlFiles;
        return clone;
    }
}

