/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.spi.Policy;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.builder.JaxbConfiguration;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.camel.component.DroolsCamelTestSupport;
import org.drools.camel.component.DroolsPolicy;
import org.drools.command.Command;
import org.drools.command.runtime.BatchExecutionCommandImpl;
import org.drools.command.runtime.process.StartProcessCommand;
import org.drools.command.runtime.rule.FireAllRulesCommand;
import org.drools.command.runtime.rule.GetObjectCommand;
import org.drools.command.runtime.rule.InsertElementsCommand;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.command.runtime.rule.QueryCommand;
import org.drools.common.DefaultFactHandle;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.io.ResourceFactory;
import org.drools.pipeline.camel.Person;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.runtime.CommandExecutor;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.QueryResultsRow;
import org.drools.runtime.rule.impl.FlatQueryResults;
import org.junit.Test;

public class CamelEndpointWithJaxbTest
extends DroolsCamelTestSupport {
    private String handle;
    private JAXBContext jaxbContext;

    @Test
    public void testSessionInsert() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        cmd.getCommands().add(new InsertObjectCommand((Object)new Person("lucaz", 25), "person1"));
        cmd.getCommands().add(new InsertObjectCommand((Object)new Person("hadrian", 25), "person2"));
        cmd.getCommands().add(new InsertObjectCommand((Object)new Person("baunax", 21), "person3"));
        cmd.getCommands().add(new FireAllRulesCommand());
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        System.out.println(xmlReq.toString());
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbTest.assertNotNull((Object)xmlResp);
        System.out.println(new String(xmlResp));
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbTest.assertEquals((int)3, (int)resp.getIdentifiers().size());
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getValue("person1"));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getValue("person2"));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getValue("person3"));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getFactHandle("person1"));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getFactHandle("person2"));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getFactHandle("person3"));
    }

    @Test
    public void testSessionGetObject() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        cmd.getCommands().add(new GetObjectCommand((FactHandle)new DefaultFactHandle(this.handle), "hadrian"));
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        System.out.println(xmlReq.toString());
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbTest.assertEquals((int)1, (int)resp.getIdentifiers().size());
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getValue("hadrian"));
    }

    @Test
    public void testSessionModify() throws Exception {
        String cmd = "";
        cmd = cmd + "<batch-execution lookup='ksession1'>\n";
        cmd = cmd + "   <modify fact-handle='" + this.handle + "'>\n";
        cmd = cmd + "      <setters>";
        cmd = cmd + "          <item accessor='name' value='\"salaboy\"' />\n";
        cmd = cmd + "      </setters>\n";
        cmd = cmd + "   </modify>\n";
        cmd = cmd + "</batch-execution>\n";
        String outXml = new String((byte[])this.template.requestBody("direct:test-with-session", (Object)cmd));
        String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n";
        expectedXml = expectedXml + "<execution-results xmlns:ns2=\"http://drools.org/model\">\n";
        expectedXml = expectedXml + "    <results/>\n";
        expectedXml = expectedXml + "    <facts/>\n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
        cmd = "<batch-execution lookup='ksession1'>\n";
        cmd = cmd + "   <get-object out-identifier='rider' fact-handle='" + this.handle + "'/>\n";
        cmd = cmd + "</batch-execution>\n";
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)cmd.toString());
        CamelEndpointWithJaxbTest.assertNotNull((Object)xmlResp);
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        Person person = (Person)resp.getValue("rider");
        CamelEndpointWithJaxbTest.assertEquals((String)"salaboy", (String)person.getName());
    }

    @Test
    public void testSessionRetractObject() throws Exception {
        String cmd = "";
        cmd = cmd + "<batch-execution lookup='ksession1'>\n";
        cmd = cmd + "   <retract fact-handle='" + this.handle + "' />\n";
        cmd = cmd + "</batch-execution>";
        String outXml = new String((byte[])this.template.requestBody("direct:test-with-session", (Object)cmd));
        System.out.println(outXml);
        CamelEndpointWithJaxbTest.assertNotNull((Object)outXml);
    }

    @Test
    public void testInsertElements() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        InsertElementsCommand elems = new InsertElementsCommand("elems");
        elems.getObjects().add(new Person("lucaz", 25));
        elems.getObjects().add(new Person("hadrian", 25));
        elems.getObjects().add(new Person("baunax", 21));
        elems.getObjects().add("xxx");
        cmd.getCommands().add(elems);
        cmd.getCommands().add(new FireAllRulesCommand());
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbTest.assertNotNull((Object)xmlResp);
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbTest.assertEquals((int)1, (int)resp.getIdentifiers().size());
        List list = (List)resp.getValue("elems");
        CamelEndpointWithJaxbTest.assertEquals((String)"lucaz", (String)((Person)list.get(0)).getName());
        CamelEndpointWithJaxbTest.assertEquals((String)"hadrian", (String)((Person)list.get(1)).getName());
        CamelEndpointWithJaxbTest.assertEquals((String)"baunax", (String)((Person)list.get(2)).getName());
    }

    @Test
    public void testQuery() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        cmd.getCommands().add(new InsertObjectCommand((Object)new Person("lucaz")));
        cmd.getCommands().add(new InsertObjectCommand((Object)new Person("hadrian")));
        cmd.getCommands().add(new InsertObjectCommand((Object)new Person("baunax", 43)));
        cmd.getCommands().add(new InsertObjectCommand((Object)new Person("baunax", 21)));
        cmd.getCommands().add(new QueryCommand("persons", "persons", null));
        cmd.getCommands().add(new QueryCommand("person", "personWithName", (Object[])new String[]{"baunax"}));
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        System.out.println(xmlReq.toString());
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbTest.assertNotNull((Object)xmlResp);
        System.out.println(new String(xmlResp));
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        FlatQueryResults personQuery = (FlatQueryResults)resp.getValue("person");
        CamelEndpointWithJaxbTest.assertEquals((int)2, (int)personQuery.size());
        FlatQueryResults personsQuery = (FlatQueryResults)resp.getValue("persons");
        CamelEndpointWithJaxbTest.assertEquals((int)5, (int)personsQuery.size());
        Iterator iterator = personQuery.iterator();
        QueryResultsRow row = (QueryResultsRow)iterator.next();
        Person person = (Person)row.get("$p");
        CamelEndpointWithJaxbTest.assertEquals((String)"baunax", (String)person.getName());
    }

    @Test
    public void testProcess() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        StartProcessCommand start = new StartProcessCommand("org.drools.actions", "process-instance-id");
        start.putParameter("person", (Object)new Person("lucaz", 25));
        start.putParameter("person2", (Object)new Person("hadrian", 25));
        start.putParameter("person3", (Object)new Person("baunax", 21));
        cmd.getCommands().add(start);
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        System.out.println(xmlReq.toString());
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbTest.assertNotNull((Object)xmlResp);
        System.out.println(new String(xmlResp));
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getValue("process-instance-id"));
    }

    @Test
    public void testProcessInstanceSignalEvent() throws Exception {
        String processId = "org.drools.event";
        String cmd = "";
        cmd = cmd + "<batch-execution lookup='ksession1'>\n";
        cmd = cmd + "  <start-process processId='" + processId + "'>\n";
        cmd = cmd + "  </start-process>\n";
        cmd = cmd + "</batch-execution>\n";
        System.out.println(cmd);
        String outXml = new String((byte[])this.template.requestBody("direct:test-with-session", (Object)cmd));
        CamelEndpointWithJaxbTest.assertNotNull((Object)outXml);
        int processInstanceId = 1;
        cmd = "";
        cmd = cmd + "<batch-execution lookup='ksession1'>\n";
        cmd = cmd + "   <signal-event process-instance-id= '" + processInstanceId + "' event-type='MyEvent'>";
        cmd = cmd + "      <string>MyValue</string>";
        cmd = cmd + "   </signal-event>";
        cmd = cmd + "</batch-execution>\n";
        outXml = new String((byte[])this.template.requestBody("direct:test-with-session", (Object)cmd));
        System.out.println(outXml);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                JaxbDataFormat def = new JaxbDataFormat();
                def.setPrettyPrint(Boolean.valueOf(true));
                def.setContextPath("org.drools.model:org.drools.pipeline.camel");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-with-session").policy((Policy)new DroolsPolicy()).unmarshal((DataFormatDefinition)def)).to("drools:node/ksession1")).marshal((DataFormatDefinition)def);
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-no-session").policy((Policy)new DroolsPolicy()).unmarshal((DataFormatDefinition)def)).to("drools:node")).marshal((DataFormatDefinition)def);
            }
        };
    }

    public JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            JaxbDataFormat def = new JaxbDataFormat();
            def.setPrettyPrint(Boolean.valueOf(true));
            def.setContextPath("org.drools.model:org.drools.pipeline.camel");
            StatefulKnowledgeSession ksession1 = (StatefulKnowledgeSession)this.node.get("ksession1", CommandExecutor.class);
            KnowledgeBase kbase = ksession1.getKnowledgeBase();
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)((ReteooRuleBase)((KnowledgeBaseImpl)kbase).getRuleBase()).getRootClassLoader());
                def = DroolsPolicy.augmentJaxbDataFormatDefinition((JaxbDataFormat)def);
                org.apache.camel.converter.jaxb.JaxbDataFormat jaxbDataformat = (org.apache.camel.converter.jaxb.JaxbDataFormat)def.getDataFormat(((Route)this.context.getRoutes().get(0)).getRouteContext());
                this.jaxbContext = jaxbDataformat.getContext();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
        return this.jaxbContext;
    }

    protected void configureDroolsContext(Context jndiContext) {
        Person me = new Person();
        me.setName("Hadrian");
        String rule = "";
        rule = rule + "package org.drools.pipeline.camel \n";
        rule = rule + "import org.drools.pipeline.camel.Person \n";
        rule = rule + "global java.util.List list \n";
        rule = rule + "query persons \n";
        rule = rule + "   $p : Person(name != null) \n";
        rule = rule + "end \n";
        rule = rule + "query personWithName(String param)\n";
        rule = rule + "   $p : Person(name == param) \n";
        rule = rule + "end \n";
        rule = rule + "rule rule1 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person() \n";
        rule = rule + " \n";
        rule = rule + "  then \n";
        rule = rule + "    System.out.println(\"executed\"); \n";
        rule = rule + "end\n";
        StatefulKnowledgeSession ksession = this.registerKnowledgeRuntime("ksession1", rule);
        InsertObjectCommand cmd = new InsertObjectCommand((Object)me);
        cmd.setOutIdentifier("camel-rider");
        cmd.setReturnObject(false);
        BatchExecutionCommandImpl script = new BatchExecutionCommandImpl(Arrays.asList(cmd));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)script);
        this.handle = ((FactHandle)results.getFactHandle("camel-rider")).toExternalForm();
    }

    protected StatefulKnowledgeSession registerKnowledgeRuntime(String identifier, String rule) {
        KnowledgeBuilder kbuilder = ((KnowledgeBuilderFactoryService)this.node.get(KnowledgeBuilderFactoryService.class)).newKnowledgeBuilder();
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        JaxbConfiguration jaxbConfiguration = KnowledgeBuilderFactory.newJaxbConfiguration((Options)xjcOpts, (String)"xsd");
        kbuilder.add(ResourceFactory.newClassPathResource((String)"person.xsd", ((Object)((Object)this)).getClass()), ResourceType.XSD, (ResourceConfiguration)jaxbConfiguration);
        if (rule != null && rule.length() > 0) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
            if (kbuilder.hasErrors()) {
                LOG.info("Errors while adding rule. ", (Object)kbuilder.getErrors());
            }
        }
        String process1 = "";
        process1 = process1 + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        process1 = process1 + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        process1 = process1 + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        process1 = process1 + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        process1 = process1 + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        process1 = process1 + "\n";
        process1 = process1 + "  <header>\n";
        process1 = process1 + "    <imports>\n";
        process1 = process1 + "      <import name=\"org.drools.model.Person\" />\n";
        process1 = process1 + "    </imports>\n";
        process1 = process1 + "    <globals>\n";
        process1 = process1 + "      <global identifier=\"list\" type=\"java.util.List\" />\n";
        process1 = process1 + "    </globals>\n";
        process1 = process1 + "    <variables>\n";
        process1 = process1 + "      <variable name=\"person\" >\n";
        process1 = process1 + "        <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"Person\" />\n";
        process1 = process1 + "      </variable>\n";
        process1 = process1 + "    </variables>\n";
        process1 = process1 + "  </header>\n";
        process1 = process1 + "\n";
        process1 = process1 + "  <nodes>\n";
        process1 = process1 + "    <start id=\"1\" name=\"Start\" />\n";
        process1 = process1 + "    <actionNode id=\"2\" name=\"MyActionNode\" >\n";
        process1 = process1 + "      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Triggered\");\n";
        process1 = process1 + "</action>\n";
        process1 = process1 + "    </actionNode>\n";
        process1 = process1 + "    <end id=\"3\" name=\"End\" />\n";
        process1 = process1 + "  </nodes>\n";
        process1 = process1 + "\n";
        process1 = process1 + "  <connections>\n";
        process1 = process1 + "    <connection from=\"1\" to=\"2\" />\n";
        process1 = process1 + "    <connection from=\"2\" to=\"3\" />\n";
        process1 = process1 + "  </connections>\n\n";
        process1 = process1 + "</process>";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])process1.getBytes()), ResourceType.DRF);
        if (kbuilder.hasErrors()) {
            System.out.println("Errors while adding process rule 1. " + kbuilder.getErrors());
        }
        CamelEndpointWithJaxbTest.assertFalse((boolean)kbuilder.hasErrors());
        String process2 = "";
        process2 = process2 + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        process2 = process2 + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        process2 = process2 + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        process2 = process2 + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        process2 = process2 + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.event\" package-name=\"org.drools\" version=\"1\" >\n";
        process2 = process2 + "\n";
        process2 = process2 + "  <header>\n";
        process2 = process2 + "    <variables>\n";
        process2 = process2 + "      <variable name=\"MyVar\" >\n";
        process2 = process2 + "        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        process2 = process2 + "        <value>SomeText</value>\n";
        process2 = process2 + "      </variable>\n";
        process2 = process2 + "    </variables>\n";
        process2 = process2 + "  </header>\n";
        process2 = process2 + "\n";
        process2 = process2 + "  <nodes>\n";
        process2 = process2 + "    <start id=\"1\" name=\"Start\" />\n";
        process2 = process2 + "    <eventNode id=\"2\" name=\"Event\" variableName=\"MyVar\" >\n";
        process2 = process2 + "      <eventFilters>\n";
        process2 = process2 + "        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n";
        process2 = process2 + "      </eventFilters>\n";
        process2 = process2 + "    </eventNode>\n";
        process2 = process2 + "    <join id=\"3\" name=\"Join\" type=\"1\" />\n";
        process2 = process2 + "    <end id=\"4\" name=\"End\" />\n";
        process2 = process2 + "  </nodes>\n";
        process2 = process2 + "\n";
        process2 = process2 + "  <connections>\n";
        process2 = process2 + "    <connection from=\"1\" to=\"3\" />\n";
        process2 = process2 + "    <connection from=\"2\" to=\"3\" />\n";
        process2 = process2 + "    <connection from=\"3\" to=\"4\" />\n";
        process2 = process2 + "  </connections>\n";
        process2 = process2 + "\n";
        process2 = process2 + "</process>";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])process2.getBytes()), ResourceType.DRF);
        if (kbuilder.hasErrors()) {
            LOG.info("Errors while adding process rule 2. ", (Object)kbuilder.getErrors());
        }
        CamelEndpointWithJaxbTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = ((KnowledgeBaseFactoryService)this.node.get(KnowledgeBaseFactoryService.class)).newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        this.node.set(identifier, (Object)session);
        return session;
    }
}

