/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.Condition;
import org.drools.model.Constraint;
import org.drools.model.DataSourceDefinition;
import org.drools.model.Declaration;
import org.drools.model.DeclarationSource;
import org.drools.model.Pattern;
import org.drools.model.Rule;
import org.drools.model.SingleConstraint;
import org.drools.model.Tuple;
import org.drools.model.TupleHandle;
import org.drools.model.Variable;
import org.drools.model.View;
import org.drools.model.consequences.NamedConsequenceImpl;
import org.drools.model.constraints.MultipleConstraints;
import org.drools.model.constraints.OrConstraints;
import org.drools.model.datasources.DataSource;
import org.drools.model.datasources.DataStore;
import org.drools.model.impl.TupleHandleImpl;

public class BruteForceEngine {
    private final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

    public BruteForceEngine bind(String name, DataSource dataSource) {
        this.dataSources.put(name, dataSource);
        return this;
    }

    public void evaluate(Rule ... rules) {
        List firedRules = Arrays.stream(rules).filter(rule -> {
            List<TupleHandle> matches = this.evaluate(rule.getView());
            matches.forEach(match -> {
                try {
                    rule.getDefaultConsequence().getBlock().execute(Arrays.stream(rule.getDefaultConsequence().getDeclarations()).map(arg_0 -> ((TupleHandle)match).get(arg_0)).toArray());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            return !matches.isEmpty();
        }).collect(Collectors.toList());
    }

    public List<TupleHandle> evaluate(View view) {
        return this.evaluateCondition((Condition)view, BruteForceEngine.initialBindings()).toTupleHandles();
    }

    public List<TupleHandle> evaluate(Condition condition) {
        return this.evaluateCondition(condition, BruteForceEngine.initialBindings()).toTupleHandles();
    }

    private DataStore getPatternDataStore(Pattern pattern) {
        DeclarationSource source = ((Declaration)pattern.getPatternVariable()).getSource();
        String sourceName = ((DataSourceDefinition)source).getName();
        DataStore dataStore = (DataStore)this.dataSources.get(sourceName);
        if (dataStore == null) {
            throw new RuntimeException("Unknonw DataSource: " + sourceName);
        }
        return dataStore;
    }

    private Bindings evaluateCondition(Condition condition, Bindings bindings) {
        switch (condition.getType()) {
            case PATTERN: {
                return this.evaluateSinglePattern((Pattern)condition, bindings);
            }
            case NOT: 
            case EXISTS: {
                return this.evaluateExistential(condition.getType(), (Pattern)condition.getSubConditions().get(0), bindings);
            }
            case AND: {
                return condition.getSubConditions().stream().filter(c -> !(c instanceof NamedConsequenceImpl)).reduce(bindings, (b, p) -> this.evaluateCondition((Condition)p, (Bindings)b), (b1, b2) -> null);
            }
            case OR: {
                return condition.getSubConditions().stream().filter(c -> !(c instanceof NamedConsequenceImpl)).reduce(new Bindings(), (b, p) -> b.append(this.evaluateCondition((Condition)p, bindings)), (b1, b2) -> null);
            }
        }
        return null;
    }

    private Bindings evaluateSinglePattern(Pattern pattern, Bindings bindings) {
        Stream<Object> objects = this.getObjectsOfType(this.getPatternDataStore(pattern), pattern.getPatternVariable().getType());
        List<BoundTuple> tuples = objects.flatMap(obj -> this.generateMatches(pattern, bindings, obj)).collect(Collectors.toList());
        return new Bindings(tuples);
    }

    private Bindings evaluateExistential(Condition.Type existentialType, Pattern pattern, Bindings bindings) {
        List objects = this.getObjectsOfType(this.getPatternDataStore(pattern), pattern.getPatternVariable().getType()).collect(Collectors.toList());
        Predicate<BoundTuple> existentialPredicate = tuple -> objects.stream().map(obj -> tuple.bind(pattern.getPatternVariable(), obj)).anyMatch(t -> this.match(pattern.getConstraint(), (BoundTuple)t));
        if (existentialType == Condition.Type.NOT) {
            existentialPredicate = existentialPredicate.negate();
        }
        List<BoundTuple> tuples = bindings.tuples.parallelStream().filter(existentialPredicate).collect(Collectors.toList());
        return new Bindings(tuples);
    }

    private Stream<Object> getObjectsOfType(DataStore dataStore, Class type) {
        return dataStore.getObjects().parallelStream().filter(type::isInstance);
    }

    private Stream<BoundTuple> generateMatches(Pattern pattern, Bindings bindings, Object obj) {
        return bindings.tuples.parallelStream().map(t -> t.bind(pattern.getPatternVariable(), obj)).filter(t -> this.match(pattern.getConstraint(), (BoundTuple)t));
    }

    private boolean match(Constraint constraint, BoundTuple tuple) {
        return this.match(constraint, tuple.getTupleHandle());
    }

    private boolean match(Constraint constraint, TupleHandle tuple) {
        switch (constraint.getType()) {
            case SINGLE: {
                SingleConstraint singleCon = (SingleConstraint)constraint;
                Variable[] vars = singleCon.getVariables();
                switch (vars.length) {
                    case 0: {
                        try {
                            return singleCon.getPredicate().test(new Object[0]);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case 1: {
                        Object obj = tuple.get(vars[0]);
                        try {
                            return singleCon.getPredicate().test(new Object[]{obj});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case 2: {
                        Object obj1 = tuple.get(vars[0]);
                        Object obj2 = tuple.get(vars[1]);
                        try {
                            return singleCon.getPredicate().test(new Object[]{obj1, obj2});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            case MULTIPLE: {
                MultipleConstraints andCon = (MultipleConstraints)constraint;
                return andCon.getChildren().stream().allMatch(con -> this.match((Constraint)con, tuple));
            }
            case OR: {
                OrConstraints orCon = (OrConstraints)constraint;
                return orCon.getChildren().stream().anyMatch(con -> this.match((Constraint)con, tuple));
            }
        }
        return false;
    }

    static Bindings initialBindings() {
        Bindings bindings = new Bindings();
        bindings.tuples.add(new BoundTuple());
        return bindings;
    }

    private static class BoundTuple {
        private final TupleHandle tuple;

        BoundTuple() {
            this(null);
        }

        BoundTuple(TupleHandleImpl tuple) {
            this.tuple = tuple;
        }

        BoundTuple bind(Variable var, Object obj) {
            return new BoundTuple(new TupleHandleImpl((Tuple)this.tuple, obj, var));
        }

        TupleHandle getTupleHandle() {
            return this.tuple;
        }

        public String toString() {
            return this.tuple.toString();
        }
    }

    private static class Bindings {
        private final List<BoundTuple> tuples;

        Bindings() {
            this.tuples = new ArrayList<BoundTuple>();
        }

        Bindings(List<BoundTuple> tuples) {
            this.tuples = tuples;
        }

        List<TupleHandle> toTupleHandles() {
            return this.tuples.parallelStream().map(BoundTuple::getTupleHandle).collect(Collectors.toList());
        }

        public Bindings append(final Bindings other) {
            return new Bindings((List<BoundTuple>)new ArrayList<BoundTuple>(){
                {
                    this.addAll(tuples);
                    this.addAll(other.tuples);
                }
            });
        }

        public String toString() {
            return this.tuples.toString();
        }
    }
}

