/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.model.Declaration;
import org.drools.model.DeclarationSource;
import org.drools.model.FlowDSL;
import org.drools.model.Person;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.TupleHandle;
import org.drools.model.Variable;
import org.drools.model.View;
import org.drools.model.datasources.DataSource;
import org.drools.model.datasources.DataStore;
import org.drools.model.engine.BruteForceEngine;
import org.drools.model.functions.Block2;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.impl.DataSourceDefinitionImpl;
import org.drools.model.view.ViewItemBuilder;
import org.junit.Assert;
import org.junit.Test;

public class FlowDSLTest {
    @Test
    public void testJoin() {
        DataStore persons = FlowDSL.storeOf((Object[])new Person[]{new Person("Mark", 37), new Person("Edson", 35), new Person("Mario", 40), new Person("Sofia", 3)});
        ArrayList list = new ArrayList();
        Declaration markV = FlowDSL.declarationOf(Person.class, (DeclarationSource)new DataSourceDefinitionImpl("persons", false));
        Declaration olderV = FlowDSL.declarationOf(Person.class, (DeclarationSource)new DataSourceDefinitionImpl("persons", false));
        Rule rule = FlowDSL.rule((String)"join").attribute(Rule.Attribute.SALIENCE, (Object)10).attribute(Rule.Attribute.AGENDA_GROUP, (Object)"myGroup").build(new RuleItemBuilder[]{FlowDSL.expr((Variable)markV, (Predicate1 & Serializable)mark -> mark.getName().equals("Mark")), FlowDSL.expr((Variable)olderV, (Predicate1 & Serializable)older -> !older.getName().equals("Mark")), FlowDSL.expr((Variable)olderV, (Variable)markV, (Predicate2 & Serializable)(older, mark) -> older.getAge() > mark.getAge()), FlowDSL.on((Variable)olderV, (Variable)markV).execute((Block2 & Serializable)(p1, p2) -> list.add(p1.getName() + " is older than " + p2.getName()))});
        new BruteForceEngine().bind("persons", (DataSource)persons).evaluate(rule);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Mario is older than Mark", list.get(0));
        Assert.assertEquals((Object)"join", (Object)rule.getName());
        Assert.assertEquals((long)10L, (long)((Integer)rule.getAttribute(Rule.Attribute.SALIENCE)).intValue());
        Assert.assertEquals((Object)"myGroup", (Object)rule.getAttribute(Rule.Attribute.AGENDA_GROUP));
        Assert.assertEquals((Object)false, (Object)rule.getAttribute(Rule.Attribute.NO_LOOP));
    }

    @Test
    public void testJoinDifferentConstraintOrder() {
        DataStore persons = FlowDSL.storeOf((Object[])new Person[]{new Person("Mark", 37), new Person("Edson", 35), new Person("Mario", 40), new Person("Sofia", 3)});
        Declaration markV = FlowDSL.declarationOf(Person.class, (DeclarationSource)new DataSourceDefinitionImpl("persons", false));
        Declaration olderV = FlowDSL.declarationOf(Person.class, (DeclarationSource)new DataSourceDefinitionImpl("persons", false));
        View view = FlowDSL.view((ViewItemBuilder[])new ViewItemBuilder[]{FlowDSL.expr((Variable)olderV, (Predicate1 & Serializable)older -> !older.getName().equals("Mark")), FlowDSL.expr((Variable)markV, (Predicate1 & Serializable)mark -> mark.getName().equals("Mark")), FlowDSL.expr((Variable)markV, (Variable)olderV, (Predicate2 & Serializable)(mark, older) -> mark.getAge() < older.getAge())});
        List<TupleHandle> result = new BruteForceEngine().bind("persons", (DataSource)persons).evaluate(view);
        Assert.assertEquals((long)1L, (long)result.size());
        TupleHandle tuple = result.get(0);
        Assert.assertEquals((Object)"Mark", (Object)((Person)tuple.get((Variable)markV)).getName());
        Assert.assertEquals((Object)"Mario", (Object)((Person)tuple.get((Variable)olderV)).getName());
    }

    @Test
    public void testOr() {
        DataStore persons = FlowDSL.storeOf((Object[])new Person[]{new Person("Mark", 37), new Person("Edson", 35), new Person("Mario", 40), new Person("Sofia", 3)});
        Declaration markV = FlowDSL.declarationOf(Person.class, (DeclarationSource)new DataSourceDefinitionImpl("persons", false));
        Declaration otherV = FlowDSL.declarationOf(Person.class, (DeclarationSource)new DataSourceDefinitionImpl("persons", false));
        View view = FlowDSL.view((ViewItemBuilder[])new ViewItemBuilder[]{FlowDSL.expr((Variable)markV, (Predicate1 & Serializable)mark -> mark.getName().equals("Mark")), FlowDSL.or((ViewItemBuilder)FlowDSL.expr((Variable)otherV, (Variable)markV, (Predicate2 & Serializable)(other, mark) -> other.getAge() > mark.getAge()), (ViewItemBuilder[])new ViewItemBuilder[]{FlowDSL.expr((Variable)otherV, (Variable)markV, (Predicate2 & Serializable)(other, mark) -> other.getName().compareToIgnoreCase(mark.getName()) > 0)})});
        List<TupleHandle> result = new BruteForceEngine().bind("persons", (DataSource)persons).evaluate(view);
        Assert.assertEquals((long)2L, (long)result.size());
        TupleHandle tuple = result.get(0);
        Assert.assertEquals((Object)"Mark", (Object)((Person)tuple.get((Variable)markV)).getName());
        Assert.assertEquals((Object)"Mario", (Object)((Person)tuple.get((Variable)otherV)).getName());
        tuple = result.get(1);
        Assert.assertEquals((Object)"Mark", (Object)((Person)tuple.get((Variable)markV)).getName());
        Assert.assertEquals((Object)"Sofia", (Object)((Person)tuple.get((Variable)otherV)).getName());
    }

    @Test
    public void testNot() {
        DataStore persons = FlowDSL.storeOf((Object[])new Person[]{new Person("Mark", 37), new Person("Edson", 35), new Person("Mario", 40), new Person("Sofia", 3)});
        Declaration oldestV = FlowDSL.declarationOf(Person.class, (DeclarationSource)new DataSourceDefinitionImpl("persons", false));
        Declaration otherV = FlowDSL.declarationOf(Person.class, (DeclarationSource)new DataSourceDefinitionImpl("persons", false));
        View view = FlowDSL.view((ViewItemBuilder[])new ViewItemBuilder[]{FlowDSL.not((Variable)otherV, (Variable)oldestV, (Predicate2 & Serializable)(p1, p2) -> p1.getAge() > p2.getAge())});
        List<TupleHandle> result = new BruteForceEngine().bind("persons", (DataSource)persons).evaluate(view);
        Assert.assertEquals((long)1L, (long)result.size());
        TupleHandle tuple = result.get(0);
        Assert.assertEquals((Object)"Mario", (Object)((Person)tuple.get((Variable)oldestV)).getName());
    }
}

