/*
 * Decompiled with CFR 0.152.
 */
package org.drools.clips;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.clips.Appendable;
import org.drools.clips.Function;
import org.drools.clips.LispAtom;
import org.drools.clips.LispForm;
import org.drools.clips.SExpression;
import org.drools.clips.VariableLispAtom;
import org.drools.lang.descr.FunctionDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionHandlers {
    public static final FunctionHandlers INSTANCE = new FunctionHandlers();
    private Map<String, Function> map = new HashMap<String, Function>();

    public static FunctionHandlers getInstance() {
        return INSTANCE;
    }

    private FunctionHandlers() {
    }

    public Function getFunction(String name) {
        return this.map.get(name);
    }

    public void registerFunction(Function function) {
        this.map.put(function.getName(), function);
    }

    public static void dump(SExpression sExpression, Appendable appendable) {
        if (sExpression instanceof LispAtom) {
            appendable.append(((LispAtom)sExpression).getValue());
        } else {
            LispForm form = (LispForm)sExpression;
            String functionName = ((LispAtom)form.getSExpressions()[0]).getValue();
            Function function = FunctionHandlers.getInstance().getFunction(functionName);
            if (function != null) {
                function.dump(form, appendable);
            } else if (form.getSExpressions()[0] instanceof VariableLispAtom) {
                function = FunctionHandlers.getInstance().getFunction("call");
                function.dump(form, appendable);
            } else {
                appendable.append(functionName + "(");
                int length = form.getSExpressions().length;
                for (int i = 1; i < length; ++i) {
                    FunctionHandlers.dump(form.getSExpressions()[i], appendable);
                    if (i >= length - 1) continue;
                    appendable.append(", ");
                }
                appendable.append(")");
            }
        }
    }

    public static FunctionDescr createFunctionDescr(SExpression name, LispForm params, List<SExpression> content) {
        FunctionDescr descr = new FunctionDescr(((LispAtom)name).getValue(), "Object");
        for (SExpression sExpr : params.getSExpressions()) {
            String param = ((LispAtom)sExpr).getValue().trim();
            if (param.charAt(0) == '\"') {
                param = param.substring(1);
            }
            if (param.charAt(param.length() - 1) == '\"') {
                param = param.substring(0, param.length() - 1);
            }
            descr.addParameter("Object", param);
        }
        descr.setContent(content);
        return descr;
    }
}

