/*
 * Decompiled with CFR 0.152.
 */
package org.drools.clips;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import org.drools.Person;
import org.drools.StatefulSession;
import org.drools.clips.ClipsShell;
import org.drools.common.InternalRuleBase;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ClipsShellTest {
    private ByteArrayOutputStream baos;
    private ClipsShell shell;

    @Before
    public void setUp() {
        this.shell = new ClipsShell();
        this.baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(this.baos);
        this.shell.addRouter("t", p);
    }

    @Test
    public void testBind() {
        String expr = "(bind ?x (create$ 10 20 30) ) (printout t ?x)";
        this.shell.eval(expr);
        Assert.assertEquals((Object)"[10, 20, 30]", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testProgn() {
        String expr = "(progn (?x (create$ 10 20 30) ) (printout t ?x) )";
        this.shell.eval(expr);
        Assert.assertEquals((Object)"102030", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testIf() {
        String expr = "(if (< 1 3) then (printout t hello) (printout t hello) )";
        this.shell.eval(expr);
        Assert.assertEquals((Object)"hellohello", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testIfElse() {
        String expr = "(if (eq 1 3) then (printout t hello)  (printout t 1) else (printout t hello)  (printout t 2))";
        this.shell.eval(expr);
        Assert.assertEquals((Object)"hello2", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testSwitch() throws IOException {
        String expr = "(switch (?x) (case a then (printout t hello)(printout t 1)) (case b then (printout t hello)(printout t 2)) (default (printout t hello)(printout t 3)) )";
        this.shell.addVariable("$x", (Object)"a");
        this.shell.eval(expr);
        Assert.assertEquals((Object)"hello1", (Object)new String(this.baos.toByteArray()));
        this.shell.addVariable("$x", (Object)"M");
        this.shell.eval(expr);
        Assert.assertEquals((Object)"hello1hello3", (Object)new String(this.baos.toByteArray()));
        this.shell.addVariable("$x", (Object)"b");
        this.shell.eval(expr);
        Assert.assertEquals((Object)"hello1hello3hello2", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testDeffunction() {
        String function = "(deffunction max (?a ?b) (if (> ?a ?b) then (return ?a) else (return ?b) ) )";
        this.shell.eval(function);
        String expr = "(if (eq (max 3 5) 5) then (printout t right) else (printout t wrong) )";
        this.shell.eval(expr);
        Assert.assertEquals((Object)"right", (Object)new String(this.baos.toByteArray()));
        expr = "(if (eq (max ?a ?b) 5) then (printout t right) else (printout t wrong)  )";
        this.shell.addVariable("$a", (Object)"3");
        this.shell.addVariable("$b", (Object)"5");
        this.shell.eval(expr);
        Assert.assertEquals((Object)"rightright", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testDirectImportAndNew() {
        String t = "(import org.drools.Person) (bind ?p (new Person mark cheddar) ) (printout t ?p)";
        this.shell.eval(t);
        Assert.assertEquals((Object)"[Person name='mark']", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testDynamicImportAndNew() {
        String t = "(import org.drools.*) (bind ?p (new Person mark cheddar) ) (printout t ?p)";
        this.shell.eval(t);
        Assert.assertEquals((Object)"[Person name='mark']", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testSet() {
        String t = "(import org.drools.*) (bind ?p (new Person mark cheddar) ) (set ?p name bob) (printout t ?p)";
        this.shell.eval(t);
        Assert.assertEquals((Object)"[Person name='bob']", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testGet() {
        String t = "(import org.drools.*) (bind ?p (new Person mark cheddar) )(printout t (get ?p name))";
        this.shell.eval(t);
        Assert.assertEquals((Object)"mark", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testExplicitCall() {
        String t = "(import org.drools.*) (bind ?p (new Person mark cheddar) ) (call ?p setFields bob stilton 35)  (printout t (call ?p toLongString))";
        this.shell.eval(t);
        Assert.assertEquals((Object)"[Person name='bob' likes='stilton' age='35']", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testImplicitCall() {
        String t = "(import org.drools.*) (bind ?p (new Person mark cheddar) ) (?p setFields bob stilton 35)  (printout t (call ?p toLongString))";
        this.shell.eval(t);
        Assert.assertEquals((Object)"[Person name='bob' likes='stilton' age='35']", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testRuleCreation() {
        this.shell.eval("(import org.drools.Person)");
        this.shell.eval("(defrule yyy  => (printout t yy \" \" (eq 1 1) ) ) )");
        Package pkg = this.shell.getStatefulSession().getRuleBase().getPackage("MAIN");
        Rule rule = pkg.getRule("yyy");
        Assert.assertEquals((Object)"yyy", (Object)rule.getName());
        this.shell.eval("(defrule xxx (Person (name ?name&bob) (age 30) ) (Person  (name ?name) (age 35)) => (printout t xx \" \" (eq 1 1) ) )");
        rule = pkg.getRule("xxx");
        Assert.assertEquals((Object)"xxx", (Object)rule.getName());
        Assert.assertEquals((long)2L, (long)pkg.getRules().length);
        Assert.assertTrue((boolean)pkg.getImports().containsKey("org.drools.Person"));
        StatefulSession wm = this.shell.getStatefulSession();
        wm.insert((Object)new Person("bob", "cheddar", 30));
        wm.insert((Object)new Person("bob", "stilton", 35));
        wm.fireAllRules();
        Assert.assertEquals((Object)"yy truexx true", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testTemplateCreation2() throws Exception {
        this.shell.eval("(deftemplate PersonTemplate (slot name (type String) ) (slot age (type int) ) )");
        this.shell.eval("(defrule xxx (PersonTemplate (name ?name&bob) (age 30) ) (PersonTemplate  (name ?name) (age 35)) => (printout t xx \" \" (eq 1 1) ) )");
        this.shell.eval("(assert (PersonTemplate (name 'mike') (age 34)))");
        Class personClass = ((InternalRuleBase)this.shell.getStatefulSession().getRuleBase()).getRootClassLoader().loadClass("MAIN.PersonTemplate");
        Assert.assertNotNull((Object)personClass);
    }

    @Test
    @Ignore
    public void testTemplateCreation() throws Exception {
        this.shell.eval("(deftemplate Person (slot name (type String) ) (slot age (type int) ) )");
        this.shell.eval("(defrule xxx (Person (name ?name&bob) (age 30) ) => (printout t hello bob ) )");
        this.shell.eval("(assert (Person (name bob) (age 30) ) )");
        this.shell.eval("(run)");
        Assert.assertEquals((Object)"hellobob", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testTemplateCreationWithJava() throws Exception {
        this.shell.eval("(deftemplate Person (slot name (type String) ) (slot age (type int) ) )");
        this.shell.eval("(defrule yyy  => (printout t yy \" \" (eq 1 1) ) ) )");
        Package pkg = this.shell.getStatefulSession().getRuleBase().getPackage("MAIN");
        Rule rule = pkg.getRule("yyy");
        Assert.assertEquals((Object)"yyy", (Object)rule.getName());
        this.shell.eval("(defrule xxx (Person (name ?name&bob) (age 30) ) (Person  (name ?name) (age 35)) => (printout t xx \" \" (eq 1 1) ) )");
        rule = pkg.getRule("xxx");
        Assert.assertEquals((Object)"xxx", (Object)rule.getName());
        Assert.assertEquals((long)2L, (long)pkg.getRules().length);
        StatefulSession wm = this.shell.getStatefulSession();
        Class personClass = ((InternalRuleBase)this.shell.getStatefulSession().getRuleBase()).getRootClassLoader().loadClass("MAIN.Person");
        Method nameMethod = personClass.getMethod("setName", String.class);
        Method ageMethod = personClass.getMethod("setAge", Integer.TYPE);
        Object bob1 = personClass.newInstance();
        nameMethod.invoke(bob1, "bob");
        ageMethod.invoke(bob1, 30);
        Object bob2 = personClass.newInstance();
        nameMethod.invoke(bob2, "bob");
        ageMethod.invoke(bob2, 35);
        wm.insert(bob1);
        wm.insert(bob2);
        wm.fireAllRules();
        Assert.assertEquals((Object)"yy truexx true", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testEmptyLHSRule() {
        String rule1 = "(defrule testRule => (printout t hello) (printout t goodbye))";
        this.shell.eval(rule1);
        Assert.assertEquals((Object)"hellogoodbye", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testSimpleLHSRule() {
        this.shell.eval("(import org.drools.*)");
        this.shell.eval("(defrule testRule (Person (name ?name&mark) ) => (printout t hello) (printout t \" \" ?name))");
        this.shell.eval("(assert (Person (name mark) ) )");
        this.shell.eval("(run)");
        Assert.assertEquals((Object)"hello mark", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testRuleCallDeftemplate() {
        String function = "(deffunction max (?a ?b) (if (> ?a ?b) then (return ?a) else (return ?b) ) )";
        this.shell.eval(function);
        this.shell.eval("(import org.drools.*)");
        this.shell.eval("(defrule testRule (Person (age ?age) ) => (printout t hello) (printout t \" \" (max 3 ?age) ) )");
        this.shell.eval("(assert (Person (name mark) (age 32) ) )");
        this.shell.eval("(run)");
        Assert.assertEquals((Object)"hello 32", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testTwoSimpleRulesWithModify() {
        this.shell.eval("(import org.drools.*)");
        this.shell.eval("(defrule testRule1 ?p <- (Person (name ?name&mark) ) => (printout t hello) (printout t \" \" ?name) (modify ?p (name bob) ) )");
        this.shell.eval("(defrule testRule2 (Person (name ?name&bob) ) => (printout t hello) (printout t \" \" ?name))");
        this.shell.eval("(assert (Person (name mark) ) )");
        this.shell.eval("(run)");
        Assert.assertEquals((Object)"hello markhello bob", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testBlockEval() {
        String text = "(import org.drools.*)";
        text = text + "(defrule testRule1 ?p <- (Person (name ?name&mark) ) => (printout t hello) (printout t \" \" ?name) (modify ?p (name bob) ) )";
        text = text + "(defrule testRule2 (Person (name ?name&bob) ) => (printout t hello) (printout t \" \" ?name))";
        text = text + "(assert (Person (name mark) ) )";
        text = text + "(run)";
        this.shell.eval(text);
        Assert.assertEquals((Object)"hello markhello bob", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testPredicate() {
        this.shell.eval("(import org.drools.Person)");
        this.shell.eval("(defrule testRule1 (Person (name ?name) (age ?age&:(> ?age 30)) ) => (printout t hello) (printout t \" \" ?name) )");
        this.shell.eval("(assert (Person (name mark) (age 27) ) )");
        this.shell.eval("(assert (Person (name bob) (age 35) ) )");
        this.shell.eval("(run)");
        Assert.assertEquals((Object)"hello bob", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testReturnValue() {
        this.shell.eval("(import org.drools.Person)");
        this.shell.eval("(defrule testRule1 (Person (age ?age) ) (Person (name ?name) (age =(- ?age 3)) ) => (printout t hello) (printout t \" \" ?name) )");
        this.shell.eval("(assert (Person (name mark) (age 32) ) )");
        this.shell.eval("(assert (Person (name bob) (age 35) ) )");
        this.shell.eval("(run)");
        Assert.assertEquals((Object)"hello mark", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    @Ignore
    public void testTest() {
        this.shell.eval("(import org.drools.Person)");
        this.shell.eval("(defrule testRule1 (Person (age ?age1) ) (Person (name ?name) (age ?age2) ) (test(eq ?age1 (+ ?age2 3) )) => (printout t hello) )");
        this.shell.eval("(assert (Person (name mark) (age 32) ) )");
        this.shell.eval("(assert (Person (name bob) (age 35) ) )");
        this.shell.eval("(run)");
        Assert.assertEquals((Object)"hello", (Object)new String(this.baos.toByteArray()));
    }

    @Test
    public void testRun() {
        this.shell.eval("(run)");
    }

    @Test
    @Ignore
    public void testMixed() {
        this.shell.eval("(import org.drools.Cheese)");
        String str = "";
        str = str + "(deftemplate Person ";
        str = str + "  (slot name ";
        str = str + "    (type String) ) ";
        str = str + "  (slot age";
        str = str + "    (type String) ) ";
        str = str + "  (slot location";
        str = str + "    (type String) ) ";
        str = str + "  (slot cheese";
        str = str + "    (type String) ) ";
        str = str + ")";
        this.shell.eval(str);
        this.shell.eval("(deffunction max (?a ?b) (if (> ?a ?b) then (return ?a) else (return ?b) ) )");
        str = "";
        str = str + "(defrule sendsomecheese ";
        str = str + "  (Person (name ?name) (age ?personAge) (cheese ?cheeseType) (location \"london\") ) ";
        str = str + "  (Cheese (type ?cheeseType) (price ?cheesePrice&:(eq (max ?personAge ?cheesePrice) ?cheesePrice)  ) )";
        str = str + "\n=>\n";
        str = str + "  (printout t \"send some \" ?cheeseType \" \" to \" \" ?name) ";
        str = str + ")";
        this.shell.eval(str);
        this.shell.eval("(assert (Person (name mark) (location \"london\") (cheese \"cheddar\") (age 25) ) )");
        this.shell.eval("(assert (Cheese (type \"cheddar\") (price  30) ) ) ");
        this.shell.eval("(run)");
        Assert.assertEquals((Object)"send some cheddar to mark", (Object)new String(this.baos.toByteArray()));
    }
}

