/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.agent.RuleAgent;
import org.drools.decisiontable.SourcePackageProvider;

public class SourcePackageProviderTest
extends TestCase {
    public void testSourceProvider() throws Exception {
        int len;
        new SourcePackageProvider();
        File dir = SourcePackageProviderTest.getTempDirectory();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/data/ExamplePolicyPricing.xls");
        File target = new File(dir, "Something.xls");
        FileOutputStream out = new FileOutputStream(target);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
        Properties config = new Properties();
        config.setProperty("file", target.getPath());
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)config);
        SourcePackageProviderTest.assertNotNull((Object)ag);
        RuleBase rb = ag.getRuleBase();
        SourcePackageProviderTest.assertNotNull((Object)rb);
    }

    public static File getTempDirectory() {
        File f = SourcePackageProviderTest.tempDir();
        if (f.exists()) {
            if (f.isFile()) {
                throw new IllegalStateException("The temp directory exists as a file. Nuke it now !");
            }
            SourcePackageProviderTest.deleteDir(f);
            f.mkdir();
        } else {
            f.mkdir();
        }
        return f;
    }

    private static File tempDir() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        return new File(tmp, "__temp_test_drools_packages");
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = SourcePackageProviderTest.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

