/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.acme.insurance.launcher.PricingRuleLauncher;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.DecisionTableInputType;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.Person;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;

public class SpreadsheetIntegrationTest
extends TestCase {
    public void testExecute() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLS);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.xls", ((Object)((Object)this)).getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        SpreadsheetIntegrationTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        session.insert((Object)new Cheese("stilton", 42));
        session.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules();
        SpreadsheetIntegrationTest.assertEquals((int)1, (int)list.size());
        SpreadsheetIntegrationTest.assertEquals((String)"Old man stilton", (String)((String)list.get(0)));
    }

    public void testNamedWorksheet() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLS);
        dtconf.setWorksheetName("Tables_2");
        kbuilder.add(ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.xls", ((Object)((Object)this)).getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        SpreadsheetIntegrationTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        session.insert((Object)new Cheese("cheddar", 42));
        session.insert((Object)new Person("michael", "stilton", 25));
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules();
        SpreadsheetIntegrationTest.assertEquals((int)1, (int)list.size());
        SpreadsheetIntegrationTest.assertEquals((String)"Young man cheddar", (String)((String)list.get(0)));
    }

    public void testInsuranceExample() throws Exception {
        PricingRuleLauncher launcher = new PricingRuleLauncher();
        SpreadsheetIntegrationTest.assertEquals((int)120, (int)launcher.executeExample());
    }
}

