/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import junit.framework.TestCase;
import org.drools.decisiontable.parser.LhsBuilder;

public class LhsBuilderTest
extends TestCase {
    public void testBuildItUp() throws Exception {
        LhsBuilder builder = new LhsBuilder("Person");
        builder.addTemplate(1, "age");
        builder.addTemplate(2, "size != $param");
        builder.addTemplate(3, "date <");
        builder.addCellValue(1, "42");
        builder.addCellValue(2, "20");
        builder.addCellValue(3, "30");
        LhsBuilderTest.assertEquals((String)"Person(age == \"42\", size != 20, date < \"30\")", (String)builder.getResult());
        builder.clearValues();
        builder.addCellValue(2, "42");
        LhsBuilderTest.assertEquals((String)"Person(size != 42)", (String)builder.getResult());
    }

    public void testEmptyCells() {
        LhsBuilder builder = new LhsBuilder("Person");
        LhsBuilderTest.assertFalse((boolean)builder.hasValues());
    }

    public void testClassicMode() {
        LhsBuilder builder = new LhsBuilder("");
        builder.addTemplate(1, "Person(age < $param)");
        builder.addCellValue(1, "42");
        LhsBuilderTest.assertEquals((String)"Person(age < 42)", (String)builder.getResult());
        builder = new LhsBuilder(null);
        builder.addTemplate(3, "Foo(bar == $param)");
        builder.addTemplate(4, "eval(true)");
        builder.addCellValue(3, "42");
        builder.addCellValue(4, "Y");
        LhsBuilderTest.assertEquals((String)"Foo(bar == 42)\neval(true)", (String)builder.getResult());
    }

    public void testForAllAndFucntion() {
        LhsBuilder builder = new LhsBuilder("");
        builder.addTemplate(1, "forall(&&){Foo(bar != $)}");
        builder.addCellValue(1, "42,43");
        LhsBuilderTest.assertEquals((String)"Foo(bar != 42) && Foo(bar != 43)", (String)builder.getResult());
    }

    public void testForAllOr() {
        LhsBuilder builder = new LhsBuilder("Person");
        builder.addTemplate(1, "forall(||){age < $}");
        builder.addCellValue(1, "42");
        LhsBuilderTest.assertEquals((String)"Person(age < 42)", (String)builder.getResult());
    }

    public void testForAllOrPrefix() {
        LhsBuilder builder = new LhsBuilder("Person");
        builder.addTemplate(1, "age < 10 && forall(||){age < $}");
        builder.addCellValue(1, "42");
        LhsBuilderTest.assertEquals((String)"Person(age < 10 && age < 42)", (String)builder.getResult());
    }

    public void testForAllOrCSV() {
        LhsBuilder builder = new LhsBuilder("Person");
        builder.addTemplate(1, "forall(||){age < $}");
        builder.addCellValue(1, "42, 43, 44");
        LhsBuilderTest.assertEquals((String)"Person(age < 42 || age < 43 || age < 44)", (String)builder.getResult());
    }

    public void testForAllAnd() {
        LhsBuilder builder = new LhsBuilder("Person");
        builder.addTemplate(1, "forall(&&){age < $}");
        builder.addCellValue(1, "42");
        LhsBuilderTest.assertEquals((String)"Person(age < 42)", (String)builder.getResult());
    }

    public void testForAllAndCSV() {
        LhsBuilder builder = new LhsBuilder("Person");
        builder.addTemplate(1, "forall(&&){age < $}");
        builder.addCellValue(1, "42, 43, 44");
        LhsBuilderTest.assertEquals((String)"Person(age < 42 && age < 43 && age < 44)", (String)builder.getResult());
    }

    public void testForAllAndForAllOrCSVMultiple() {
        LhsBuilder builder = new LhsBuilder("Person");
        builder.addTemplate(1, "forall(&&){age < $ || age == $}");
        builder.addCellValue(1, "42, 43, 44");
        LhsBuilderTest.assertEquals((String)"Person(age < 42 || age == 42 && age < 43 || age == 43 && age < 44 || age == 44)", (String)builder.getResult());
    }

    public void testForAllsAndForAllOrCSVMultiple() {
        LhsBuilder builder = new LhsBuilder("Person");
        builder.addTemplate(1, "forall(&&){age < $ || age == $} && forall(&&){age < $ || age == $}");
        builder.addCellValue(1, "42, 43, 44");
        LhsBuilderTest.assertEquals((String)"Person(age < 42 || age == 42 && age < 43 || age == 43 && age < 44 || age == 44 && age < 42 || age == 42 && age < 43 || age == 43 && age < 44 || age == 44)", (String)builder.getResult());
    }

    public void testIdentifyFieldTypes() {
        LhsBuilder builder = new LhsBuilder("");
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.SINGLE_FIELD, (Object)builder.calcFieldType("age"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.OPERATOR_FIELD, (Object)builder.calcFieldType("age <"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.NORMAL_FIELD, (Object)builder.calcFieldType("age < $param"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.NORMAL_FIELD, (Object)builder.calcFieldType("forall(||){age < $}"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.NORMAL_FIELD, (Object)builder.calcFieldType("forall(&&){age < $}"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.NORMAL_FIELD, (Object)builder.calcFieldType("forall(,){age < $}"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.NORMAL_FIELD, (Object)builder.calcFieldType("forall(){age < $}"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.NORMAL_FIELD, (Object)builder.calcFieldType("forall(){age < $} && forall(){age == $}"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.NORMAL_FIELD, (Object)builder.calcFieldType("x && forall(){age < $} && forall(){age == $}"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.NORMAL_FIELD, (Object)builder.calcFieldType("x && forall(){age < $} && forall(){age == $} && y"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.SINGLE_FIELD, (Object)builder.calcFieldType("age < $para"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.SINGLE_FIELD, (Object)builder.calcFieldType("forall{||}{age < $}"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.SINGLE_FIELD, (Object)builder.calcFieldType("forall(){}"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.SINGLE_FIELD, (Object)builder.calcFieldType("forall(){age < $"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.SINGLE_FIELD, (Object)builder.calcFieldType("forall(){,"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.SINGLE_FIELD, (Object)builder.calcFieldType("forall({})"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.SINGLE_FIELD, (Object)builder.calcFieldType("forall({}){test})"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.SINGLE_FIELD, (Object)builder.calcFieldType("forall(&&){{}})"));
        LhsBuilderTest.assertEquals((Object)LhsBuilder.FieldType.SINGLE_FIELD, (Object)builder.calcFieldType("forall(&&){{})"));
    }

    public void testIdentifyColumnCorrectly() {
        LhsBuilder builder = new LhsBuilder(null);
        LhsBuilderTest.assertFalse((boolean)builder.isMultipleConstraints());
        builder = new LhsBuilder("Foo");
        LhsBuilderTest.assertTrue((boolean)builder.isMultipleConstraints());
        builder = new LhsBuilder("f:Foo() eval  ");
        LhsBuilderTest.assertTrue((boolean)builder.isMultipleConstraints());
        builder = new LhsBuilder("f: Foo()");
        LhsBuilderTest.assertFalse((boolean)builder.isMultipleConstraints());
    }
}

