/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.Properties;
import junit.framework.TestCase;
import org.drools.decisiontable.parser.xls.PropertiesSheetListener;

public class PropertiesSheetListenerTest
extends TestCase {
    public void testProperties() {
        PropertiesSheetListener listener = new PropertiesSheetListener();
        listener.startSheet("test");
        listener.newRow(0, 4);
        listener.newCell(0, 0, "", -1);
        listener.newCell(0, 1, "key1", -1);
        listener.newCell(0, 2, "value1", -1);
        listener.newRow(1, 4);
        listener.newCell(1, 1, "key2", -1);
        listener.newCell(1, 3, "value2", -1);
        Properties props = listener.getProperties();
        listener.newRow(2, 4);
        listener.newCell(1, 1, "key3", -1);
        PropertiesSheetListenerTest.assertEquals((String)"value1", (String)props.getProperty("Key1"));
        PropertiesSheetListenerTest.assertEquals((String)"value2", (String)props.getProperty("key2"));
    }

    public void testCaseInsensitive() {
        PropertiesSheetListener.CaseInsensitiveMap map = new PropertiesSheetListener.CaseInsensitiveMap();
        map.setProperty("x3", "hey");
        map.setProperty("x4", "wHee");
        map.setProperty("XXx", "hey2");
        PropertiesSheetListenerTest.assertNull((Object)map.getProperty("x"));
        PropertiesSheetListenerTest.assertEquals((String)"hey", (String)map.getProperty("x3"));
        PropertiesSheetListenerTest.assertEquals((String)"hey", (String)map.getProperty("X3"));
        PropertiesSheetListenerTest.assertEquals((String)"wHee", (String)map.getProperty("x4"));
        PropertiesSheetListenerTest.assertEquals((String)"hey2", (String)map.getProperty("xxx"));
        PropertiesSheetListenerTest.assertEquals((String)"hey2", (String)map.getProperty("XXX"));
        PropertiesSheetListenerTest.assertEquals((String)"hey2", (String)map.getProperty("XXx"));
        PropertiesSheetListenerTest.assertEquals((String)"Whee2", (String)map.getProperty("x", "Whee2"));
    }
}

