/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.List;
import junit.framework.TestCase;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.template.parser.DecisionTableParseException;

public class RuleSheetParserUtilTest
extends TestCase {
    public void testRuleName() {
        String row = "  RuleTable       This is my rule name";
        String result = RuleSheetParserUtil.getRuleName((String)"  RuleTable       This is my rule name");
        RuleSheetParserUtilTest.assertEquals((String)"This is my rule name", (String)result);
    }

    public void testInvalidRuleName() {
        String row = "RuleTable       This is my rule name (type class)";
        try {
            String result = RuleSheetParserUtil.getRuleName((String)"RuleTable       This is my rule name (type class)");
            RuleSheetParserUtilTest.fail((String)("should have failed, but get result: " + result));
        }
        catch (IllegalArgumentException e) {
            RuleSheetParserUtilTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void testIsStringMeaningTrue() {
        RuleSheetParserUtilTest.assertTrue((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"true"));
        RuleSheetParserUtilTest.assertTrue((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"TRUE"));
        RuleSheetParserUtilTest.assertTrue((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"yes"));
        RuleSheetParserUtilTest.assertTrue((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"oN"));
        RuleSheetParserUtilTest.assertFalse((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"no"));
        RuleSheetParserUtilTest.assertFalse((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"false"));
        RuleSheetParserUtilTest.assertFalse((boolean)RuleSheetParserUtil.isStringMeaningTrue(null));
    }

    public void testListImports() {
        String cellVal = null;
        List list = RuleSheetParserUtil.getImportList(cellVal);
        RuleSheetParserUtilTest.assertNotNull((Object)list);
        RuleSheetParserUtilTest.assertEquals((int)0, (int)list.size());
        RuleSheetParserUtilTest.assertEquals((int)0, (int)RuleSheetParserUtil.getImportList((String)"").size());
        cellVal = "com.something.Yeah, com.something.No,com.something.yeah.*";
        list = RuleSheetParserUtil.getImportList((String)cellVal);
        RuleSheetParserUtilTest.assertEquals((int)3, (int)list.size());
        RuleSheetParserUtilTest.assertEquals((String)"com.something.Yeah", (String)((Import)list.get(0)).getClassName());
        RuleSheetParserUtilTest.assertEquals((String)"com.something.No", (String)((Import)list.get(1)).getClassName());
        RuleSheetParserUtilTest.assertEquals((String)"com.something.yeah.*", (String)((Import)list.get(2)).getClassName());
    }

    public void testListVariables() {
        List varList = RuleSheetParserUtil.getVariableList((String)"Var1 var1, Var2 var2,Var3 var3");
        RuleSheetParserUtilTest.assertNotNull((Object)varList);
        RuleSheetParserUtilTest.assertEquals((int)3, (int)varList.size());
        Global var = (Global)varList.get(0);
        RuleSheetParserUtilTest.assertEquals((String)"Var1", (String)var.getClassName());
        var = (Global)varList.get(2);
        RuleSheetParserUtilTest.assertEquals((String)"Var3", (String)var.getClassName());
        RuleSheetParserUtilTest.assertEquals((String)"var3", (String)var.getIdentifier());
    }

    public void testBadVariableFormat() {
        String bad = "class1, object2";
        try {
            RuleSheetParserUtil.getVariableList((String)"class1, object2");
            RuleSheetParserUtilTest.fail((String)"should not work");
        }
        catch (DecisionTableParseException e) {
            RuleSheetParserUtilTest.assertNotNull((Object)e.getMessage());
        }
    }
}

