/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.decisiontable.parser.csv.CsvLineParser;
import org.drools.decisiontable.parser.csv.CsvParser;
import org.drools.template.parser.DataListener;

public class CsvParserTest
extends TestCase {
    public void testCsv() {
        MockSheetListener listener = new MockSheetListener();
        CsvLineParser lineParser = new CsvLineParser();
        CsvParser parser = new CsvParser((DataListener)listener, lineParser);
        parser.parseFile(((Object)((Object)this)).getClass().getResourceAsStream("/data/TestCsv.csv"));
        CsvParserTest.assertEquals((String)"A", (String)listener.getCell(0, 0));
        CsvParserTest.assertEquals((String)"B", (String)listener.getCell(0, 1));
        CsvParserTest.assertEquals((String)"", (String)listener.getCell(2, 0));
        CsvParserTest.assertEquals((String)"C", (String)listener.getCell(1, 0));
        CsvParserTest.assertEquals((String)"D", (String)listener.getCell(1, 1));
        CsvParserTest.assertEquals((String)"E", (String)listener.getCell(1, 3));
    }

    public void testCellMergeHandling() {
        CsvParser parser = new CsvParser((DataListener)null, null);
        CsvParserTest.assertEquals((int)-1, (int)parser.calcStartMerge(-1, 1, "foo"));
        CsvParserTest.assertEquals((int)42, (int)parser.calcStartMerge(-1, 42, "..."));
        CsvParserTest.assertEquals((int)42, (int)parser.calcStartMerge(42, 43, "..."));
        CsvParserTest.assertEquals((int)-1, (int)parser.calcStartMerge(42, 44, "VanHalen"));
        CsvParserTest.assertEquals((String)"VanHalen", (String)parser.calcCellText(-1, "VanHalen"));
        CsvParserTest.assertEquals((String)"VanHalen", (String)parser.calcCellText(42, "VanHalen..."));
        CsvParserTest.assertEquals((String)"", (String)parser.calcCellText(42, "..."));
    }

    static class MockSheetListener
    implements DataListener {
        Map<String, String> data = new HashMap<String, String>();

        MockSheetListener() {
        }

        public String getCell(int row, int col) {
            return this.data.get(this.cellKey(row, col));
        }

        public void startSheet(String name) {
        }

        public void finishSheet() {
        }

        public void newRow(int rowNumber, int columns) {
        }

        public void newCell(int row, int column, String value, int mergeCellStart) {
            this.data.put(this.cellKey(row, column), value);
        }

        String cellKey(int row, int column) {
            return "R" + row + "C" + column;
        }
    }
}

