/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.Person;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.agent.KnowledgeAgent;
import org.kie.internal.agent.KnowledgeAgentFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ChangeSetTest {
    @Test
    public void testIntegration() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeset1Test.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 25));
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"Young man cheddar", list.get(0));
        Assert.assertEquals((Object)"rule1", list.get(1));
        Assert.assertEquals((Object)"rule2", list.get(2));
    }

    @Test
    public void multipleSheets() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"multipleSheetsChangeSet.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 25));
        ksession.insert((Object)new Person("Jane", "stilton", 55));
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Young man cheddar"));
        Assert.assertTrue((boolean)list.contains("Jane eats cheddar"));
    }

    @Test
    public void testCSV() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeSetTestCSV.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
        Assert.assertEquals((long)3L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
    }

    @Test
    @Ignore
    public void testCSVByKnowledgeAgent() {
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"csv agent");
        kagent.applyChangeSet(ResourceFactory.newClassPathResource((String)"changeSetTestCSV.xml", this.getClass()));
        KnowledgeBase kbase = kagent.getKnowledgeBase();
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
        Assert.assertEquals((long)3L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testCSVByKnowledgeAgentWithFileReader() throws IOException {
        try {
            File targetTestFilesDir = new File("target/testFiles");
            targetTestFilesDir.mkdirs();
            File changeSetFile = new File(targetTestFilesDir, "changeSetTestCSV.xml");
            FileUtils.copyURLToFile((URL)this.getClass().getResource("changeSetTestCSV.xml"), (File)changeSetFile);
            KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"csv agent");
            kagent.applyChangeSet(ResourceFactory.newFileResource((File)changeSetFile));
            KnowledgeBase kbase = kagent.getKnowledgeBase();
            Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
            Assert.assertEquals((long)3L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }
}

