/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.concurrent.TimeUnit;
import org.drools.core.time.SessionPseudoClock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.time.Calendar;

public class CalendarTimerResourcesTest {
    private KieSession ksession;
    private SessionPseudoClock clock;
    private static final Calendar TUESDAY = new Calendar(){

        public boolean isTimeIncluded(long timestamp) {
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTimeInMillis(timestamp);
            int day = c.get(7);
            return day == 3;
        }
    };

    @Before
    public void init() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmodule = ks.newKieModuleModel();
        KieBaseModel baseModel = kmodule.newKieBaseModel("defaultKBase").setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM);
        baseModel.newKieSessionModel("defaultKSession").setDefault(true).setClockType(ClockTypeOption.get((String)"pseudo"));
        kfs.writeKModuleXML(kmodule.toXML());
        kfs.write(ks.getResources().newClassPathResource("calendar_timer.xls", this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)0L, (long)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        this.ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        this.clock = (SessionPseudoClock)this.ksession.getSessionClock();
    }

    @Test
    public void test() {
        this.ksession.getCalendars().set("tuesday", TUESDAY);
        this.clock.advanceTime(4L, TimeUnit.DAYS);
        this.ksession.fireAllRules();
    }

    @After
    public void clear() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }
}

