/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.util.HashMap;
import java.util.Map;
import org.drools.decisiontable.parser.csv.CsvLineParser;
import org.drools.decisiontable.parser.csv.CsvParser;
import org.drools.template.parser.DataListener;
import org.junit.Assert;
import org.junit.Test;

public class CsvParserTest {
    @Test
    public void testCsv() {
        MockSheetListener listener = new MockSheetListener();
        CsvLineParser lineParser = new CsvLineParser();
        CsvParser parser = new CsvParser((DataListener)listener, lineParser);
        parser.parseFile(this.getClass().getResourceAsStream("/data/TestCsv.csv"));
        Assert.assertEquals((Object)"A", (Object)listener.getCell(0, 0));
        Assert.assertEquals((Object)"B", (Object)listener.getCell(0, 1));
        Assert.assertEquals((Object)"", (Object)listener.getCell(2, 0));
        Assert.assertEquals((Object)"C", (Object)listener.getCell(1, 0));
        Assert.assertEquals((Object)"D", (Object)listener.getCell(1, 1));
        Assert.assertEquals((Object)"E", (Object)listener.getCell(1, 3));
    }

    @Test
    public void testCellMergeHandling() {
        CsvParser parser = new CsvParser((DataListener)null, null);
        Assert.assertEquals((long)-1L, (long)parser.calcStartMerge(-1, 1, "foo"));
        Assert.assertEquals((long)42L, (long)parser.calcStartMerge(-1, 42, "..."));
        Assert.assertEquals((long)42L, (long)parser.calcStartMerge(42, 43, "..."));
        Assert.assertEquals((long)-1L, (long)parser.calcStartMerge(42, 44, "VanHalen"));
        Assert.assertEquals((Object)"VanHalen", (Object)parser.calcCellText(-1, "VanHalen"));
        Assert.assertEquals((Object)"VanHalen", (Object)parser.calcCellText(42, "VanHalen..."));
        Assert.assertEquals((Object)"", (Object)parser.calcCellText(42, "..."));
    }

    static class MockSheetListener
    implements DataListener {
        Map<String, String> data = new HashMap<String, String>();

        MockSheetListener() {
        }

        public String getCell(int row, int col) {
            return this.data.get(this.cellKey(row, col));
        }

        public void startSheet(String name) {
        }

        public void finishSheet() {
        }

        public void newRow(int rowNumber, int columns) {
        }

        public void newCell(int row, int column, String value, int mergeCellStart) {
            this.data.put(this.cellKey(row, column), value);
        }

        String cellKey(int row, int column) {
            return "R" + row + "C" + column;
        }
    }
}

