/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.junit.Assert;
import org.junit.Test;

public class ExcelParserTest {
    private static final String LAST_CELL_VALUE = "last";
    private static final String FIRST_CELL_CONTENT = "first";

    @Test
    public void testCellMerge() throws Exception {
        ExcelParser parser = new ExcelParser((Map)null);
        CellRangeAddress[] ranges = new CellRangeAddress[1];
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        Cell cell = sheet.createRow(2).createCell(2);
        ranges[0] = new CellRangeAddress(2, 7, 2, 5);
        cell.setCellValue(FIRST_CELL_CONTENT);
        cell = sheet.createRow(7).createCell(5);
        cell.setCellValue(LAST_CELL_VALUE);
        cell = sheet.createRow(1).createCell(1);
        Assert.assertNull((Object)parser.getRangeIfMerged(cell, ranges));
        cell = sheet.getRow(2).createCell(5);
        cell.setCellValue("wrong");
        CellRangeAddress rangeIfMerged = parser.getRangeIfMerged(cell, ranges);
        Assert.assertEquals((Object)FIRST_CELL_CONTENT, (Object)sheet.getRow(rangeIfMerged.getFirstRow()).getCell(rangeIfMerged.getFirstColumn()).getStringCellValue());
    }
}

