/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.IOException;
import java.math.BigDecimal;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.decisiontable.ValueHolder;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class IgnoreNumericFormatTest {
    @Test
    public void testPercentAndCurrencyFormat() throws IOException {
        SpreadsheetCompiler compiler = new SpreadsheetCompiler();
        String drl = compiler.compile(ResourceFactory.newClassPathResource((String)"ignore-numeric-format.xls", this.getClass()).getInputStream(), InputType.XLS);
        System.out.println(drl);
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLSX);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"ignore-numeric-format.xls", this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ValueHolder a = new ValueHolder("A");
        ValueHolder b = new ValueHolder("B");
        ValueHolder c = new ValueHolder("C");
        ValueHolder d = new ValueHolder("D");
        ksession.insert((Object)a);
        ksession.insert((Object)b);
        ksession.insert((Object)c);
        ksession.insert((Object)d);
        ksession.fireAllRules();
        Assert.assertEquals((Object)new BigDecimal("0.0"), (Object)a.getPercentValue());
        Assert.assertEquals((Object)new BigDecimal("0.0"), (Object)a.getCurrencyValue1());
        Assert.assertEquals((Object)new BigDecimal("0.0"), (Object)a.getCurrencyValue2());
        Assert.assertEquals((long)0L, (long)a.getIntValue());
        Assert.assertEquals((double)0.0, (double)a.getDoubleValue(), (double)0.0);
        Assert.assertEquals((Object)new BigDecimal("0.01"), (Object)b.getPercentValue());
        Assert.assertEquals((Object)new BigDecimal("0.5"), (Object)b.getCurrencyValue1());
        Assert.assertEquals((Object)new BigDecimal("0.5"), (Object)b.getCurrencyValue2());
        Assert.assertEquals((long)-1L, (long)b.getIntValue());
        Assert.assertEquals((double)0.5, (double)b.getDoubleValue(), (double)0.0);
        Assert.assertEquals((Object)new BigDecimal("0.5"), (Object)c.getPercentValue());
        Assert.assertEquals((Object)new BigDecimal("1.0"), (Object)c.getCurrencyValue1());
        Assert.assertEquals((Object)new BigDecimal("1.0"), (Object)c.getCurrencyValue2());
        Assert.assertEquals((long)1L, (long)c.getIntValue());
        Assert.assertEquals((double)-1.0, (double)c.getDoubleValue(), (double)0.0);
        Assert.assertEquals((Object)new BigDecimal("1.0"), (Object)d.getPercentValue());
        Assert.assertEquals((Object)new BigDecimal("100.0"), (Object)d.getCurrencyValue1());
        Assert.assertEquals((Object)new BigDecimal("100.0"), (Object)d.getCurrencyValue2());
        Assert.assertEquals((long)100L, (long)d.getIntValue());
        Assert.assertEquals((double)100.0, (double)d.getDoubleValue(), (double)0.0);
        ksession.dispose();
    }
}

