/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.integrationtests;

import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;

public class IncrementalCompilationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateXLSResources() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        InputStream in1 = null;
        InputStream in2 = null;
        try {
            in1 = this.getClass().getResourceAsStream("incrementalBuild.dtable.drl.xls");
            kfs.write("src/main/resources/incrementalBuild1.dtable.drl.xls", KieServices.Factory.get().getResources().newInputStreamResource(in1));
            in2 = this.getClass().getResourceAsStream("incrementalBuild.dtable.drl.xls");
            kfs.write("src/main/resources/incrementalBuild2.dtable.drl.xls", KieServices.Factory.get().getResources().newInputStreamResource(in2));
            List messages = ks.newKieBuilder(kfs).buildAll().getResults().getMessages();
            Assert.assertFalse((boolean)messages.isEmpty());
        }
        finally {
            if (in1 != null) {
                in1.close();
            }
            if (in2 != null) {
                in2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalCompilationDuplicateXLSResources() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        InputStream in1 = null;
        InputStream in2 = null;
        try {
            in1 = this.getClass().getResourceAsStream("incrementalBuild.dtable.drl.xls");
            kfs.write("src/main/resources/incrementalBuild1.dtable.drl.xls", KieServices.Factory.get().getResources().newInputStreamResource(in1));
            KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
            Assert.assertEquals((long)0L, (long)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
            in2 = this.getClass().getResourceAsStream("incrementalBuild.dtable.drl.xls");
            kfs.write("src/main/resources/incrementalBuild2.dtable.drl.xls", KieServices.Factory.get().getResources().newInputStreamResource(in2));
            IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/incrementalBuild2.dtable.drl.xls"}).build();
            Assert.assertEquals((long)1L, (long)addResults.getAddedMessages().size());
            Assert.assertEquals((long)0L, (long)addResults.getRemovedMessages().size());
            List messages = ks.newKieBuilder(kfs).buildAll().getResults().getMessages();
            Assert.assertFalse((boolean)messages.isEmpty());
        }
        finally {
            if (in1 != null) {
                in1.close();
            }
            if (in2 != null) {
                in2.close();
            }
        }
    }
}

