/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.xls.PropertiesSheetListener;
import org.junit.Test;

public class PropertiesSheetListenerTest {
    @Test
    public void testProperties() {
        PropertiesSheetListener listener = new PropertiesSheetListener();
        listener.startSheet("test");
        listener.newRow(0, 4);
        listener.newCell(0, 0, "", -1);
        listener.newCell(0, 1, "key1", -1);
        listener.newCell(0, 2, "value1", -1);
        listener.newRow(1, 4);
        listener.newCell(1, 1, "key2", -1);
        listener.newCell(1, 3, "value2", -1);
        PropertiesSheetListener.CaseInsensitiveMap props = listener.getProperties();
        listener.newRow(2, 4);
        listener.newCell(1, 1, "key3", -1);
        Assertions.assertThat((String)props.getSingleProperty("Key1")).isEqualTo("value1");
        Assertions.assertThat((String)props.getSingleProperty("key2")).isEqualTo("value2");
    }

    @Test
    public void testCaseInsensitive() {
        PropertiesSheetListener.CaseInsensitiveMap map = new PropertiesSheetListener.CaseInsensitiveMap();
        map.addProperty("x3", new String[]{"hey", "B2"});
        map.addProperty("x4", new String[]{"wHee", "C3"});
        map.addProperty("XXx", new String[]{"hey2", "D4"});
        Assertions.assertThat((List)map.getProperty("x")).isNull();
        Assertions.assertThat((String)map.getSingleProperty("x3")).isEqualTo("hey");
        Assertions.assertThat((String)map.getSingleProperty("X3")).isEqualTo("hey");
        Assertions.assertThat((String)map.getSingleProperty("x4")).isEqualTo("wHee");
        Assertions.assertThat((String)map.getSingleProperty("xxx")).isEqualTo("hey2");
        Assertions.assertThat((String)map.getSingleProperty("XXX")).isEqualTo("hey2");
        Assertions.assertThat((String)map.getSingleProperty("XXx")).isEqualTo("hey2");
        Assertions.assertThat((String)map.getSingleProperty("x", "Whee2")).isEqualTo("Whee2");
    }
}

