/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.drools.util.IoUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;

public class DumpGeneratedDrlTest {
    private final String DUMMY_DTABLE_CSV_SOURCE = "\"RuleSet\",\"org.drools.decisiontable\",,,\n,,,,\n,,,,\n\"RuleTable agenda-group\",,,,\n\"NAME\",\"CONDITION\",\"Lock-On-Active\",\"Auto-Focus\",\"ACTION\"\n,,,,\n,\"String(this == \"\"$param\"\")\",,,\n\"rule names\",\"string for test\",,,\n\"lockOnActiveRule\",\"lockOnActiveRule\",\"true\",,\n\"autoFocusRule\",\"autoFocusRule\",,\"true\",";
    private File dumpDir;
    private String dumpDirPropOrigValue;

    @Before
    public void setupAndCleanDumpDir() {
        this.dumpDir = new File("target/drools-dump-dir");
        if (this.dumpDir.exists()) {
            FileUtils.deleteQuietly((File)this.dumpDir);
        }
        this.dumpDir.mkdirs();
        this.dumpDirPropOrigValue = System.getProperty("drools.dump.dir");
        System.setProperty("drools.dump.dir", this.dumpDir.getAbsolutePath());
    }

    @Test
    public void testGeneratedDrlFromIsDumpedIfSpecified() {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.CSV);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource resource = ResourceFactory.newByteArrayResource((byte[])"\"RuleSet\",\"org.drools.decisiontable\",,,\n,,,,\n,,,,\n\"RuleTable agenda-group\",,,,\n\"NAME\",\"CONDITION\",\"Lock-On-Active\",\"Auto-Focus\",\"ACTION\"\n,,,,\n,\"String(this == \"\"$param\"\")\",,,\n\"rule names\",\"string for test\",,,\n\"lockOnActiveRule\",\"lockOnActiveRule\",\"true\",,\n\"autoFocusRule\",\"autoFocusRule\",,\"true\",".getBytes(IoUtils.UTF8_CHARSET));
        resource.setSourcePath("some/source/path/dummy-dtable.csv");
        kbuilder.add(resource, ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)("Unexpected Drools compilation errors: " + kbuilder.getErrors().toString()));
        }
        this.assertGeneratedDrlExists(this.dumpDir, "some_source_path_dummy-dtable.csv.drl");
    }

    @Test
    public void testDTableWithNullSrcPathIsCorrectlyDumped() {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.CSV);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource resource = ResourceFactory.newByteArrayResource((byte[])"\"RuleSet\",\"org.drools.decisiontable\",,,\n,,,,\n,,,,\n\"RuleTable agenda-group\",,,,\n\"NAME\",\"CONDITION\",\"Lock-On-Active\",\"Auto-Focus\",\"ACTION\"\n,,,,\n,\"String(this == \"\"$param\"\")\",,,\n\"rule names\",\"string for test\",,,\n\"lockOnActiveRule\",\"lockOnActiveRule\",\"true\",,\n\"autoFocusRule\",\"autoFocusRule\",,\"true\",".getBytes(IoUtils.UTF8_CHARSET));
        kbuilder.add(resource, ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)("Unexpected Drools compilation errors: " + kbuilder.getErrors().toString()));
        }
        this.assertGeneratedDrlExists(this.dumpDir, null);
    }

    @Test
    public void testUseReleaseIdInGeneratedDumpForProjectResource() {
        ReleaseId releaseId = KieServices.get().getRepository().getDefaultReleaseId();
        new KieHelper().addContent("\"RuleSet\",\"org.drools.decisiontable\",,,\n,,,,\n,,,,\n\"RuleTable agenda-group\",,,,\n\"NAME\",\"CONDITION\",\"Lock-On-Active\",\"Auto-Focus\",\"ACTION\"\n,,,,\n,\"String(this == \"\"$param\"\")\",,,\n\"rule names\",\"string for test\",,,\n\"lockOnActiveRule\",\"lockOnActiveRule\",\"true\",,\n\"autoFocusRule\",\"autoFocusRule\",,\"true\",", "some/source/path/project-dtable.drl.csv").build(new KieBaseOption[0]);
        this.assertGeneratedDrlExists(this.dumpDir, releaseId.getGroupId() + "_" + releaseId.getArtifactId() + "_some_source_path_project-dtable.drl.csv.drl");
    }

    @After
    public void restoreConfig() {
        if (this.dumpDirPropOrigValue != null) {
            System.setProperty("drools.dump.dir", this.dumpDirPropOrigValue);
        }
    }

    private void assertGeneratedDrlExists(File dumpDir, String expectedFilename) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dumpDir.exists()).as("Dump dir should exist!", new Object[0])).isTrue();
        File[] generatedDrls = dumpDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".drl");
            }
        });
        ((AbstractIntegerAssert)Assertions.assertThat((int)generatedDrls.length).as("There should be exactly one generated DRL file!", new Object[0])).isEqualTo(1);
        if (expectedFilename != null) {
            ((AbstractStringAssert)Assertions.assertThat((String)generatedDrls[0].getName()).as("Unexpected name of the file with generated DRL!", new Object[0])).isEqualTo(expectedFilename);
        }
    }
}

