/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.IOException;
import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.decisiontable.ValueHolder;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Test;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class IgnoreNumericFormatTest {
    @Test
    public void testPercentAndCurrencyFormat() throws IOException {
        this.ignoreNumericFormat("ignore-numeric-format.drl.xls");
    }

    @Test
    public void testPercentAndCurrencyFormatWithReferenceCells() throws IOException {
        this.ignoreNumericFormat("ignore-numeric-format-ref-cell.drl.xls");
    }

    private void ignoreNumericFormat(String fileName) throws IOException {
        SpreadsheetCompiler compiler = new SpreadsheetCompiler();
        String drl = compiler.compile(ResourceFactory.newClassPathResource((String)fileName, this.getClass()).getInputStream(), InputType.XLS);
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLSX);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)fileName, this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ValueHolder a = new ValueHolder("A");
        ValueHolder b = new ValueHolder("B");
        ValueHolder c = new ValueHolder("C");
        ValueHolder d = new ValueHolder("D");
        ksession.insert((Object)a);
        ksession.insert((Object)b);
        ksession.insert((Object)c);
        ksession.insert((Object)d);
        ksession.fireAllRules();
        Assertions.assertThat((BigDecimal)a.getPercentValue()).isEqualTo((Object)new BigDecimal("0.0"));
        Assertions.assertThat((BigDecimal)a.getCurrencyValue1()).isEqualTo((Object)new BigDecimal("0.0"));
        Assertions.assertThat((BigDecimal)a.getCurrencyValue2()).isEqualTo((Object)new BigDecimal("0.0"));
        Assertions.assertThat((BigDecimal)a.getCurrencyValue3()).isEqualTo((Object)new BigDecimal("0.0"));
        Assertions.assertThat((int)a.getIntValue()).isZero();
        Assertions.assertThat((double)a.getDoubleValue()).isZero();
        Assertions.assertThat((BigDecimal)b.getPercentValue()).isEqualTo((Object)new BigDecimal("0.01"));
        Assertions.assertThat((BigDecimal)b.getCurrencyValue1()).isEqualTo((Object)new BigDecimal("0.5"));
        Assertions.assertThat((BigDecimal)b.getCurrencyValue2()).isEqualTo((Object)new BigDecimal("0.5"));
        Assertions.assertThat((BigDecimal)b.getCurrencyValue3()).isEqualTo((Object)new BigDecimal("0.5"));
        Assertions.assertThat((int)b.getIntValue()).isEqualTo(-1);
        Assertions.assertThat((double)b.getDoubleValue()).isEqualTo(0.5);
        Assertions.assertThat((BigDecimal)c.getPercentValue()).isEqualTo((Object)new BigDecimal("0.5"));
        Assertions.assertThat((BigDecimal)c.getCurrencyValue1()).isEqualTo((Object)new BigDecimal("1.0"));
        Assertions.assertThat((BigDecimal)c.getCurrencyValue2()).isEqualTo((Object)new BigDecimal("1.0"));
        Assertions.assertThat((BigDecimal)c.getCurrencyValue3()).isEqualTo((Object)new BigDecimal("1.0"));
        Assertions.assertThat((int)c.getIntValue()).isEqualTo(1);
        Assertions.assertThat((double)c.getDoubleValue()).isEqualTo(-1.0);
        Assertions.assertThat((BigDecimal)d.getPercentValue()).isEqualTo((Object)new BigDecimal("1.0"));
        Assertions.assertThat((BigDecimal)d.getCurrencyValue1()).isEqualTo((Object)new BigDecimal("100.0"));
        Assertions.assertThat((BigDecimal)d.getCurrencyValue2()).isEqualTo((Object)new BigDecimal("100.0"));
        Assertions.assertThat((BigDecimal)d.getCurrencyValue3()).isEqualTo((Object)new BigDecimal("100.0"));
        Assertions.assertThat((int)d.getIntValue()).isEqualTo(100);
        Assertions.assertThat((double)d.getDoubleValue()).isEqualTo(100.0);
        ksession.dispose();
    }
}

