/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.LhsBuilder;
import org.junit.Test;

public class LhsBuilderTest {
    @Test
    public void testBuildItUp() throws Exception {
        LhsBuilder builder = new LhsBuilder(9, 1, "Person");
        builder.addTemplate(10, 1, "age");
        builder.addTemplate(10, 2, "size != $param");
        builder.addTemplate(10, 3, "date <");
        builder.addCellValue(11, 1, "42");
        builder.addCellValue(11, 2, "20");
        builder.addCellValue(11, 3, "30");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Person(age == \"42\", size != 20, date < \"30\")");
        builder.clearValues();
        builder.addCellValue(12, 2, "42");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Person(size != 42)");
    }

    @Test
    public void testEmptyCells() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Person");
        Assertions.assertThat((boolean)builder.hasValues()).isFalse();
    }

    @Test
    public void testClassicMode() {
        LhsBuilder builder = new LhsBuilder(9, 1, "");
        builder.addTemplate(10, 1, "Person(age < $param)");
        builder.addCellValue(11, 1, "42");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Person(age < 42)");
        builder = new LhsBuilder(9, 3, null);
        builder.addTemplate(10, 3, "Foo(bar == $param)");
        builder.addTemplate(10, 4, "eval(true)");
        builder.addCellValue(11, 3, "42");
        builder.addCellValue(11, 4, "Y");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Foo(bar == 42)\neval(true)");
    }

    @Test
    public void testForAllAndFucntion() {
        LhsBuilder builder = new LhsBuilder(9, 1, "");
        builder.addTemplate(10, 1, "forall(&&){Foo(bar != $)}");
        builder.addCellValue(11, 1, "42,43");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Foo(bar != 42) && Foo(bar != 43)");
    }

    @Test
    public void testForAllOr() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Person");
        builder.addTemplate(10, 1, "forall(||){age < $}");
        builder.addCellValue(11, 1, "42");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Person(age < 42)");
    }

    @Test
    public void testForAllOrPrefix() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Person");
        builder.addTemplate(10, 1, "age < 10 && forall(||){age < $}");
        builder.addCellValue(11, 1, "42");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Person(age < 10 && age < 42)");
    }

    @Test
    public void testForAllOrCSV() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Person");
        builder.addTemplate(10, 1, "forall(||){age < $}");
        builder.addCellValue(11, 1, "42, 43, 44");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Person(age < 42 || age < 43 || age < 44)");
    }

    @Test
    public void testForAllAnd() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Person");
        builder.addTemplate(10, 1, "forall(&&){age < $}");
        builder.addCellValue(11, 1, "42");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Person(age < 42)");
    }

    @Test
    public void testForAllAndCSV() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Person");
        builder.addTemplate(10, 1, "forall(&&){age < $}");
        builder.addCellValue(11, 1, "42, 43, 44");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Person(age < 42 && age < 43 && age < 44)");
    }

    @Test
    public void testForAllAndForAllOrCSVMultiple() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Person");
        builder.addTemplate(10, 1, "forall(&&){age < $ || age == $}");
        builder.addCellValue(11, 1, "42, 43, 44");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Person(age < 42 || age == 42 && age < 43 || age == 43 && age < 44 || age == 44)");
    }

    @Test
    public void testForAllsAndForAllOrCSVMultiple() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Person");
        builder.addTemplate(10, 1, "forall(&&){age < $ || age == $} && forall(&&){age < $ || age == $}");
        builder.addCellValue(11, 1, "42, 43, 44");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Person(age < 42 || age == 42 && age < 43 || age == 43 && age < 44 || age == 44 && age < 42 || age == 42 && age < 43 || age == 43 && age < 44 || age == 44)");
    }

    @Test
    public void testIdentifyFieldTypes() {
        LhsBuilder builder = new LhsBuilder(9, 1, "");
        Assertions.assertThat((Comparable)builder.calcFieldType("age")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("age <")).isEqualTo((Object)LhsBuilder.FieldType.OPERATOR_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("age < $param")).isEqualTo((Object)LhsBuilder.FieldType.NORMAL_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall(||){age < $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall(&&){age < $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall(,){age < $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall(){age < $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall(){age < $} && forall(){age == $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("x && forall(){age < $} && forall(){age == $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("x && forall(){age < $} && forall(){age == $} && y")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("age < $para")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall{||}{age < $}")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall(){}")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall(){age < $")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall(){,")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall({})")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall({}){test})")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall(&&){{}})")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)builder.calcFieldType("forall(&&){{})")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
    }

    @Test
    public void testIdentifyColumnCorrectly() {
        LhsBuilder builder = new LhsBuilder(9, 1, null);
        Assertions.assertThat((boolean)builder.isMultipleConstraints()).isFalse();
        builder = new LhsBuilder(9, 1, "Foo");
        Assertions.assertThat((boolean)builder.isMultipleConstraints()).isTrue();
        builder = new LhsBuilder(9, 1, "f:Foo() eval  ");
        Assertions.assertThat((boolean)builder.isMultipleConstraints()).isTrue();
        builder = new LhsBuilder(9, 1, "f: Foo()");
        Assertions.assertThat((boolean)builder.isMultipleConstraints()).isTrue();
    }

    @Test
    public void testTypeConst3() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Type");
        builder.addTemplate(10, 1, "flda");
        builder.addTemplate(10, 2, "fldb >");
        builder.addTemplate(10, 3, "fldc str[startsWith]");
        builder.addCellValue(11, 1, "good");
        builder.addCellValue(11, 2, "42");
        builder.addCellValue(11, 3, "abc");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Type(flda == \"good\", fldb > \"42\", fldc str[startsWith] \"abc\")");
    }

    @Test
    public void testTypeParConst2() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Type()");
        builder.addTemplate(10, 1, "flda");
        builder.addTemplate(10, 2, "fldb >");
        builder.addCellValue(11, 1, "good");
        builder.addCellValue(11, 2, "42");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Type(flda == \"good\", fldb > \"42\")");
    }

    @Test
    public void testTypeConstFrom() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Type from $west");
        builder.addTemplate(10, 1, "flda");
        builder.addCellValue(11, 1, "good");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Type(flda == \"good\") from $west");
    }

    @Test
    public void testTypeEvalExp2() {
        LhsBuilder builder = new LhsBuilder(9, 1, "Type($a:a,$b:b) eval");
        builder.addTemplate(10, 1, "$a > $param");
        builder.addTemplate(10, 2, "$b < $param");
        builder.addCellValue(11, 1, "1");
        builder.addCellValue(11, 2, "99");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Type($a:a,$b:b) eval($a > 1 && $b < 99)");
    }

    @Test
    public void testEvalExp2() {
        LhsBuilder builder = new LhsBuilder(9, 1, "eval()");
        builder.addTemplate(10, 1, "$a > $param");
        builder.addTemplate(10, 2, "$b < $param");
        builder.addCellValue(11, 1, "1");
        builder.addCellValue(11, 2, "99");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("eval($a > 1 && $b < 99)");
    }

    @Test
    public void testTypeParPlain() {
        LhsBuilder builder = new LhsBuilder(9, 1, null);
        builder.addTemplate(10, 1, "Type()");
        builder.addCellValue(11, 1, "x");
        Assertions.assertThat((String)builder.getResult()).isEqualTo("Type()");
    }
}

